#! /bin/csh -f
#/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
# *                                                                 *
# * Copyright (C) 1998 Timothy E. Dowling                           *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of the GNU General Public License     *
# * as published by the Free Software Foundation; either version 2  *
# * of the License, or (at your option) any later version.          *
# * A copy of this License is in the file:                          *
# *   $EPIC_PATH/License.txt                                        *
# *                                                                 *
# * This program is distributed in the hope that it will be useful, *
# * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
# *                                                                 *
# * You should have received a copy of the GNU General Public       *
# * License along with this program; if not, write to the Free      *
# * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
# * Boston, MA  02111-1307, USA.                                    *
# *                                                                 *
# * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#
# C shell that launches EPIC model on the MPI host.
#
# The presense of the directory $MPI_PATH/boot signals usage of 
# LAM MPI, which the EPIC makefiles are not set up to use. Otherwise, 
# the MPICH syntax is used.
#

if ( -e $MPI_PATH/boot ) then 
  echo 'Error: mpi_launch: EPIC makefiles are not set up to use LAM's MPI'
  exit
else 
  exec $MPI_PATH/bin/mpirun -nolocal -np $1 mpi_epic.$MACHINE_TYPE \
       -itback $2 -itsave $3 -itout $4 -socket $5 -view_host $6 $7 ; 
endif




