
/*================= enthalpy_condensation() ===================================*/

/*
 *  P. Stratman
 *  [what do I do?]
 */

double enthalpy_condensation(char   *chem,
                             double  temperature) 
{
  char
    header[N_STR],
    infile[N_STR];
  int
    index,j,i;
  static int
    ndat[MAX_NVARS],
    initialized=0;
  double 
    enth,t_d;
  static double
    *tdat[MAX_NVARS],
    *enthdat[MAX_NVARS],
    *enth_y2[MAX_NVARS],
    first_denthdt[MAX_NVARS],
    last_denthdt[MAX_NVARS];
  FILE
    *enth_vs_t;

  /*
   * Initialization:
   */
  if (!initialized) {
    /* 
     * Loop through known condensables and set up data table splines: 
     */
    for (index = FIRST_HUMIDITY; index <= LAST_HUMIDITY; index++) {
      if (IAMNODE == NODE0) {
        sprintf(infile,EPIC_PATH"/data/chemistry/enthalpy/condensation/enth_vs_t.%s",
                var.chem_name[index]);
        enth_vs_t = fopen(infile,"r");
        if (!enth_vs_t) {
          fprintf(stderr,"Error: enthalpy_condensation(): failed to open %s.\n",infile);
          exit(1);
        }
        /* Skip over header: */
        for (j = 0; j < 6; j++) {
          fgets(header,100,enth_vs_t);  
        }
        /* Input number of data points: */
        fscanf(enth_vs_t,"%d",ndat+index); 
      }

#if defined(EPIC_MPI)
      MPI_Bcast(ndat+index,1,MPI_INT,NODE0,para.comm);
#endif

      /* Allocate memory: */
      tdat[   index] = dvector(0,ndat[index]-1);
      enthdat[index] = dvector(0,ndat[index]-1);
      enth_y2[count] = dvector(0,ndat[index]-1);

      if (IAMNODE == NODE0) {
        /* Input enth(T): */
        for (j = 0; j < ndat[index]; j++) {
          fscanf(enth_vs_t,"%lf %lf",tdat[index]+j,enthdat[index]+j);
        }
        fclose(enth_vs_t);
      }

#if defined(EPIC_MPI)
      MPI_Bcast(   tdat[index],ndat[index],MPI_DOUBLE,NODE0,para.comm);
      MPI_Bcast(enthdat[index],ndat[index],MPI_DOUBLE,NODE0,para.comm);
#endif

      /* Calculate cubic spline coefficients: */


    }

    initialized = 1;
  }
  /* End of initialization. */

  /* Apply cubic spline: */



  return enth;
}

/*================= end of enthalpy_condensation() ==============================*/



    /* Set endpoint slopes: */
    first_dedt[count-1] = 
          (enthdat[count-1][1]-enthdat[count-1][0])/
          (tdat[count-1][1]-tdat[count-1][0]);
    last_dedt[count-1]  = 
          
(enthdat[count-1][ndat[count-1]-1]-enthdat[count-1][ndat[count-1]-2])/
          (tdat[count-1][ndat[count-1]-1]-tdat[count-1][ndat[count-1]-2]);
    /* Prepare for cubic-spline interpolation: */
    spline(tdat[count-1],enthdat[count-1],ndat[count-1],
           first_dedt[count-1],last_dbdt[count-1],enth_y2[count-1]);
  }

/* begin cubic interpolation evaluation */

if (temperature <= tdat[i] [0]) {

   /* at or before start of table */

   enth = enthdat[i][0]+first_dedt[i]*(temperature-tdat[i][0]);
}

else if (temperature >= tdat[i][ndat[i]-1]) {

   /* at or after end of table   */

   enth = enthdat[i][ndat[i]-1]+last_dedt[i]*(temperature-tdat[i] [ndat[i] - 1]);
}

else {

   j    = find_place_in_table(ndat[i], tdat[i], &temperature, &t_d);
   enth = splint(temperature, tdat[i] + j, enthdat[i] + j, 
                 enth_y2[i] + j, t_d);
}

