/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                 *
 * Copyright (C) 1998 Timothy E. Dowling                           *
 *                                                                 */
/* This program is free software; you can redistribute it and/or   */
/* modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 * A copy of this License is in the file:                          */
/*   $EPIC_PATH/License.txt                                        */
/*                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
 *                                                                 *
 * You should have received a copy of the GNU General Public       *
 * License along with this program; if not, write to the Free      *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
 * Boston, MA  02111-1307, USA.                                    *
 *                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * *  avs_epic.h * * * * * * * * * * * * * * * * * * * * 
 *                                                                           *
 *       Timothy E. Dowling                                                  *
 *                                                                           *
 *       User defined data types for AVS io ports.                           *
 *                                                                           *
 *       NOTE: These definitions are also be needed in non-AVS files.        *
 *             They are located here to avoid redundancy.                    *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* 
 * NOTE: In user-data definitions, such as avs_epic.h, AVS gives 
 * "User data: syntax error" for long comment lines that have a backslash.
 *
 * NOTE: This user-data file has the appearance of a C header file, but
 * AVS excludes preprocessor macros (#define). Hence, there are notes
 * indicating where parameters such as MAX_NVARS must be put in by hand.
 */


/*
 *  Structures: 
 */

/*
 * NOTE: Additions to planetspec need to be added to var_read() and
 *       var_write() in epic_funcs_io.c so that they will be passed properly.
 */

typedef struct {
  int
    secs;
  int 
    years;
} timespec;

typedef struct {
  char   
    name[16],           /* name of planet                                     */
    class[16];          /* gas-giant or terrestrial                           */
  double  
    re,                 /* equatorial radius, m                               */
    rp,                 /* polar radius, m                                    */
    omega,              /* angular velocity, 1/s                              */
    cp,                 /* specific heat at constant pressure                 */
    rgas,               /* gas constant                                       */
    kappa,              /* rgas/cp                                            */
    g,                  /* surface gravitational acceleration                 */
    x_he,               /* number fraction of helium                          */
    x_h2,               /* number fraction of molecular hydrogen              */
    x_3,                /* number fraction of remaining constituents          */
    a,                  /* orbit semimajor axis, in AU                        */
    e,                  /* orbit eccentricity                                 */
    orbit_period;       /* orbit period, in years                             */
} planetspec;

/* 
 * Domain structure for AVS port.
 *
 * NOTE: AVS is restrictive in what it allows in user-defined port data types.
 * Not allowed are pointers,C preprocessor directives, or structures.
 *
 */

typedef struct{
  /* From gridspec: */
  char  
    /* 
     * NOTE: 16 = GEOM_STR 
     *        7 = MAX_NU_ORDER+1
     *        3 = TOPDIM
     */
    geometry[16];
  double
    data_version,
    globe_lonbot,
    globe_lontop,
    globe_latbot,
    globe_lattop;
  char
    f_plane_map[16];
  double
    f_plane_lat0,
    f_plane_half_width;
  int  
    dt,                  /* timestep, s                                     */
    cfl_dt,              /* CFL timestep                                    */
    nk,                  /* number of vertical layers                       */
    nj,                  /* number of grid points in latitude               */
    ni,                  /* number of grid points in longitude              */
    wrap[3],             /* periodicity flag                                */
    pad[3],              /* boundary pad width                              */
    jlo,                 /* lower index for j, 0 for globe geometry         */
    jfirst,              /* used to handle C-grid for q and v variables     */
    klast_active,        /* terrestrial planets have active k = nk          */
    we_num_nodes,        /* number of nodes on this computer                */
    they_num_nodes;      /* number of nodes on other computer               */
  double 
    dln,                 /* longitudinal grid spacing, deg                  */
    dlt,                 /* latitudinal  grid spacing, deg                  */
    theta_bot,           /* theta for bottom of model                       */
    theta_top,           /* theta for top of model                          */
    press0,              /* reference pressure                              */
    mont0,               /* reference Montgomery potential                  */
    hasten;              /* artificial speed-up factor for relaxation times */
  int
    k_sponge,            /* range of sponge layers                          */
    init_type,           /* indicates initialization: 0=T(p), 1=T(y,p), etc.*/
    newt_cool_on,        /* 1 enables Newtonian cooling                     */
    thermal_conduct_on;  /* 1 enables thermal conduction                    */
  char
    eos[8];              /* equation of state: "ideal", "virial"            */
  int
    itback,              /* disk backup interval                            */
    itout,               /* view interval                                   */
    itsave;              /* disk save interval                              */
  int   
    aux_a,               /* for any use                                     */
    aux_b,               /* for any use                                     */
    aux_c;               /* for any use                                     */
  double
    aux_fa,              /* for any use                                     */
    aux_fb,              /* for any use                                     */
    aux_fc;              /* for any use                                     */
  double
    prandtl,
    /* NOTE: 7 = MAX_NU_ORDER+1 */
    nu[7],                /* viscosity coefficients                         */
    theta[401],           /* theta array,  assumes nk <= 200                */ 
    rgas[201],            /* rgas  array                                    */ 
    kappa[201],           /* kappa array                                    */
    p_avg[201],           /* p_avg array                                    */
    qmin[201],            /* array of qmin's                                */
    qmax[201],            /* array of qmax's                                */
    tmin[201],            /* array of tmin's                                */
    tmax[201];            /* array of tmax's                                */
  /* From variables structure: */
  int
    nvars,               /* number of carried prognostic variables          */
    /* 
     * NOTE: Update all values below when MAX_NVARS changes in epic.h.
     *       The values correspond to the following:
     *         13 = MAX_NVARS
     *         14 = MAX_NVARS+1 
     *         64 = CHEM_NM_SZ  
     */
    chem_on[14],         /* 1 implies active chemical                       */
    index[13];           /* actual memory index used for carried variables  */
  char
    chem_name[ 14][64],  /* list of defined chemicals                       */
    tend_name[ 14][64],  /* tendency names, e.g., dhdt                      */
    chem_units[14][64],  /* units                                           */
    tend_units[14][64];  /* units                                           */
  double
    time_fp_bar;         /* Nominal: 3.e+8*1000.*100. [time*1bar, mks]      */
  char
    view_host[80];       /* machine running EPIC_RECEIVE                    */
} domainspec;


/* * * * * * * * * * end of avs_epic.h * * * * * * * * * * * * * * * * * * * */
