/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                 *
 * Copyright (C) 1998 Timothy E. Dowling                           *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 * A copy of this License is in the file:                          *
 *   $EPIC_PATH/License.txt                                        *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
 *                                                                 *
 * You should have received a copy of the GNU General Public       *
 * License along with this program; if not, write to the Free      *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
 * Boston, MA  02111-1307, USA.                                    *
 *                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHEMICAL_ELEMENTS_H
#define CHEMICAL_ELEMENTS_H

/*
 * Molar mass ("atomic weight") data are from the periodic table of  
 * Atkins, "Physical Chemistry," 5th edition, Freeman, New York, 1994.
 *
 * Solar abundance data are from Grevesse and Anders' Appendix A,
 * Table 1, p. 1229-30 in "Solar Interior and Atmosphere," 
 * Cox, Livingston, and Matthews, Eds., Arizona, 1991.
 *
 * Solar abundances are in the form log10(N_el/N_H)+12,
 * where N_el is the number abundance of the given element, and 
 * N_H is the number abundance of hydrogen atoms.
 * (Unpublished abundances are assigned the value -10.)
 *
 */

chem_element
  Element[LAST_ATOMIC_NUMBER+1] = {
    {  0," ", " ",             0.,  -10.00},
    {  1,"H", "hydrogen",      1.008,12.00},
    {  2,"He","helium",        4.003,10.99},
    {  3,"Li","lithium",       6.941, 1.16},
    {  4,"Be","beryllium",     9.012, 1.15},
    {  5,"B", "boron",        10.81,  2.6 },
    {  6,"C", "carbon",       12.01,  8.60},
    {  7,"N", "nitrogen",     14.01,  8.00},
    {  8,"O", "oxygen",       16.00,  8.93},
    {  9,"F", "fluorine",     19.00,  4.56},
    { 10,"Ne","neon",         20.18,  8.09},
    { 11,"Na","sodium",       22.99,  6.33},
    { 12,"Mg","magnesium",    24.30,  7.58},
    { 13,"Al","aluminum",     26.98,  6.47},
    { 14,"Si","silicon",      28.09,  7.55},
    { 15,"P", "phosphorus",   30.97,  5.45},
    { 16,"S", "sulfur",       32.07,  7.21},
    { 17,"Cl","chlorine",     35.45,  5.5 },
    { 18,"Ar","argon",        39.95,  6.56},
    { 19,"K", "potassium",    39.10,  5.12},
    { 20,"Ca","calcium",      40.08,  6.36},
    { 21,"Sc","scandium",     44.96,  3.10},
    { 22,"Ti","titanium",     47.88,  4.99},
    { 23,"V", "vanadium",     50.94,  4.00},
    { 24,"Cr","chromium",     52.00,  5.67},
    { 25,"Mn","manganese",    54.94,  5.39},
    { 26,"Fe","iron",         55.85,  7.67},
    { 27,"Co","cobalt",       58.93,  4.92},
    { 28,"Ni","nickel",       58.69,  6.25},
    { 29,"Cu","copper",       63.55,  4.21},
    { 30,"Zn","zinc",         65.39,  4.60},
    { 31,"Ga","gallium",      69.72,  2.88},
    { 32,"Ge","germanium",    72.61,  3.41},
    /* Next 4 abundances are meteorite values: */
    { 33,"As","arsenic",      74.92,  2.37},
    { 34,"Se","selenium",     78.96,  3.35},
    { 35,"Br","bromine",      79.90,  2.63},
    { 36,"Kr","krypton",      83.80,  3.23},
    { 37,"Rb","rubidium",     85.47,  2.60},
    { 38,"Sr","strontium",    87.62,  2.90},
    { 39,"Y", "yttrium",      88.91,  2.24},
    { 40,"Zr","zirconium",    91.22,  2.60},
    { 41,"Nb","niobium",      92.91,  1.42},
    { 42,"Mo","molybdenum",   95.94,  1.92},
    { 43,"Tc","technetium",   98.91,-10.00},
    { 44,"Ru","ruthenium",   101.1,   1.84},
    { 45,"Rh","rhodium",     102.9,   1.12},
    { 46,"Pd","palladium",   106.4,   1.69},
    { 47,"Ag","silver",      107.9,   0.94},
    { 48,"Cd","cadmium",     112.4,   1.86},
    { 49,"In","indium",      114.8,   1.66},
    { 50,"Sn","tin",         118.7,   2.0 },
    { 51,"Sb","antimony",    121.8,   1.0 },
    /* Next 4 abundances are meteorite values: */
    { 52,"Te","tellurium",   127.6,   2.24},
    { 53,"I", "iodine",      126.9,   1.51},
    { 54,"Xe","xenon",       131.3,   2.23},
    { 55,"Cs","cesium",      132.9,   1.12},
    { 56,"Ba","barium",      137.3,   2.13},
    { 57,"La","lanthanum",   138.9,   1.22},
    { 58,"Ce","cerium",      140.1,   1.55},
    { 59,"Pr","praseodymium",140.9,   0.71},
    { 60,"Nd","neodymium",   144.2,   1.50},
    { 61,"Pm","promethium",  144.9, -10.00},
    { 62,"Sm","samarium",    150.4,   1.00},
    { 63,"Eu","europium",    152.0,   0.51},
    { 64,"Gd","gadolinium",  157.2,   1.12},
    { 65,"Tb","terbium",     158.9,  -0.1 },
    { 66,"Dy","dysprosium",  162.5,   1.1 },
    { 67,"Ho","holmium",     164.9,   0.26},
    { 68,"Er","erbium",      167.3,   0.93},
    { 69,"Tm","thulium",     168.9,   0.00},
    { 70,"Yb","ytterbium",   173.0,   1.08},
    { 71,"Lu","lutetium",    175.0,   0.76},
    { 72,"Hf","hafnium",     178.5,   0.88},
    /* Next abundance is the meteorite value: */
    { 73,"Ta","tantalum",    180.9,   0.13},
    { 74,"W", "tungsten",    183.8,   1.11},
    /* Next abundance is the meteorite value: */
    { 75,"Re","rhenium",     186.2,   0.27},
    { 76,"Os","osmium",      190.2,   1.45},
    { 77,"Ir","iridium",     192.2,   1.35},
    { 78,"Pt","platinum",    195.1,   1.8 },
    { 79,"Au","gold",        197.0,   1.01},
    /* Next abundance is the meteorite value: */
    { 80,"Hg","mercury",     200.6,   1.09},
    { 81,"Tl","thallium",    204.4,   0.9 },
    { 82,"Pb","lead",        207.2,   1.85},
    /* Next abundance is the meteorite value: */
    { 83,"Bi","bismuth",     209.0,   0.71},
    { 84,"Po","polonium",    210.0, -10.00},
    { 85,"At","astatine",    210.0, -10.00},
    { 86,"Rn","radon",       222.0, -10.00},
    { 87,"Fr","francium",    223.0, -10.00},
    { 88,"Ra","radium",      226.0, -10.00},
    { 89,"Ac","actinium",    227.0, -10.00},
    { 90,"Th","thorium",     232.0,   0.12},
    { 91,"Pa","protactinium",231.0, -10.00},
    /* Next abundance is the meteorite value: */
    { 92,"U", "uranium",     238.0,  -0.49},
    { 93,"Np","neptunium",   237.0, -10.00},
    { 94,"Pu","plutonium",   239.1, -10.00},
    { 95,"Am","americium",   243.1, -10.00},
    { 96,"Cm","curium",      247.1, -10.00},
    { 97,"Bk","berkelium",   247.1, -10.00},
    { 98,"Cf","californium", 252.1, -10.00},
    { 99,"Es","einsteinium", 252.1, -10.00},
    {100,"Fm","fermium",     257.1, -10.00},
    {101,"Md","mendelevium", 256.1, -10.00},
    {102,"No","nobelium",    259.1, -10.00},
    {103,"Lr","lawrencium",  260.1, -10.00}
  };

#endif

 
  
  
  
