/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                 *
 * Copyright (C) 1998 Timothy E. Dowling                           *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 * A copy of this License is in the file:                          *
 *   $EPIC_PATH/License.txt                                        *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
 *                                                                 *
 * You should have received a copy of the GNU General Public       *
 * License along with this program; if not, write to the Free      *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
 * Boston, MA  02111-1307, USA.                                    *
 *                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef EPIC_IO_MACROS_H
#define EPIC_IO_MACROS_H

/*======================= input/output macros =====================*/

/*
 * The following macros make it possible to mention each data item in  
 * functions like var_read() and var_write() only once, regardless 
 * of io_type.
 */

/*
 * Because netCDF assumes that the last dimension of a variable varies the 
 * fastest, the number associated with each dimension is backwards from 
 * the usual EPIC convention:
 */
#define NETCDF_IT_INDEX 0
#define NETCDF_K_INDEX  1
#define NETCDF_J_INDEX  2
#define NETCDF_I_INDEX  3

/*
 * Input macros:
 */

#define READC(node,prefix,struct,joiner,member,num) \
  if (io_type == VIA_FILE) { \
    if (node == IAMNODE) { \
      nc_err = nc_inq_atttype(nc_id,NC_GLOBAL,#struct "_" #member,&the_nc_type); \
      if (nc_err == NC_NOERR && the_nc_type == NC_CHAR) { \
        nc_get_att_text(nc_id,NC_GLOBAL,#struct "_" #member, prefix ## struct ## joiner ## member ); \
      } \
    } \
    bcast_char(node, prefix ##struct ## joiner ## member ,num); \
  } \
  else { \
    Read(node, prefix ## struct ## joiner ## member ,sizeof(char),(num),DONT_SWAP,io,fd,node); \
  }

#define READI(node,prefix,struct,joiner,member,num) \
  if (io_type == VIA_FILE) { \
    if (node == IAMNODE) { \
      nc_err = nc_inq_atttype(nc_id,NC_GLOBAL,#struct "_" #member,&the_nc_type); \
      if (nc_err == NC_NOERR && the_nc_type == NC_INT) { \
        nc_get_att_int(nc_id,NC_GLOBAL,#struct "_" #member, prefix ## struct ## joiner ## member ); \
      } \
    } \
    bcast_int(node, prefix ## struct ## joiner ## member ,num); \
  } \
  else { \
    Read(node, prefix ## struct ## joiner ## member  ,sizeof(int),(num),BSWAP,io,fd,node); \
  }

#define READD(node,prefix,struct,joiner,member,num) \
  if (io_type == VIA_FILE) { \
    if (node == IAMNODE) { \
      nc_err = nc_inq_atttype(nc_id,NC_GLOBAL,#struct "_" #member,&the_nc_type); \
      if (nc_err == NC_NOERR && the_nc_type == NC_DOUBLE) { \
        nc_get_att_double(nc_id,NC_GLOBAL,#struct "_" #member, prefix ## struct ## joiner ## member ); \
      } \
    } \
    bcast_double(node, prefix ## struct ## joiner ## member ,num); \
  } \
  else { \
    Read(node, prefix ## struct ## joiner ## member ,sizeof(double),(num),BSWAP,io,fd,node); \
  }

/* 
 * Output macros:
 */

#define WRITEC(node,prefix,struct,joiner,member,num) \
  if (io_type == VIA_FILE) { \
    if (node == IAMNODE) { \
      nc_err = nc_put_att_text(nc_id,NC_GLOBAL,#struct "_" #member, \
                               num, prefix ## struct ## joiner ## member ); \
      if (nc_err != NC_NOERR) { \
        fprintf(stderr,"Error: WRITEC: %s, %s\n", \
                nc_strerror(nc_err),#struct #joiner #member ); \
        exit(1); \
      } \
    } \
  } \
  else { \
    Write(node, prefix ## struct ## joiner ## member ,sizeof(char),(num),DONT_SWAP,io,fd); \
  }

#define WRITEI(node,prefix,struct,joiner,member,num) \
  if (io_type == VIA_FILE) { \
    if (node == IAMNODE) { \
      nc_err = nc_put_att_int(nc_id,NC_GLOBAL,#struct "_" #member,NC_INT, \
                                num, prefix ## struct ## joiner ## member ); \
      if (nc_err != NC_NOERR) { \
        fprintf(stderr,"Error: WRITEI: %s, %s\n", \
                nc_strerror(nc_err),#struct #joiner #member ); \
        exit(1); \
      } \
    } \
  } \
  else { \
    Write(node, prefix ## struct ## joiner ## member ,sizeof(int),(num),BSWAP,io,fd); \
  }

#define WRITED(node,prefix,struct,joiner,member,num) \
  if (io_type == VIA_FILE) { \
    if (node == IAMNODE) { \
      nc_err = nc_put_att_double(nc_id,NC_GLOBAL,#struct "_" #member,NC_DOUBLE, \
                                 num,  prefix ## struct ## joiner ## member ); \
      if (nc_err != NC_NOERR) { \
        fprintf(stderr,"Error: WRITED: %s, %s \n", \
                nc_strerror(nc_err),#struct #joiner #member ); \
        exit(1); \
      } \
    } \
  } \
  else { \
    Write(node, prefix ## struct ## joiner ## member ,sizeof(double),(num),BSWAP,io,fd); \
  }

/*============================ end of input/output macros =================================*/

#endif
