#! /bin/csh -f
#/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
# *                                                                 *
# * Copyright (C) 1998 Timothy E. Dowling                           *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of the GNU General Public License     *
# * as published by the Free Software Foundation; either version 2  *
# * of the License, or (at your option) any later version.          *
# * A copy of this License is in the file:                          *
# *   $EPIC_PATH/License.txt                                        *
# *                                                                 *
# * This program is distributed in the hope that it will be useful, *
# * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
# *                                                                 *
# * You should have received a copy of the GNU General Public       *
# * License along with this program; if not, write to the Free      *
# * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
# * Boston, MA  02111-1307, USA.                                    *
# *                                                                 *
# * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#
# C shell that launches EPIC model on the MPI host.
#

if ( $MPI_TYPE == sp2 ) then 
  setenv MP_FENCE flag_fence ;
  poe mpi_epic.$MACHINE_TYPE -resd yes -euilib us -rmpool 0 \
    -stdoutmode unordered -infolevel 2 \
     flag_fence \
    -itback $2 -itsave $3 -itextract $4 -itrun $5 -socket $6 -view_host $7 $8 ; 
else if ( $MPI_TYPE == LAM ) then 
  exec mpirun -O  -np $1 mpi_epic.$MACHINE_TYPE -- \
    -itback $2 -itsave $3 -itextract $4 -itrun $5 -socket $6 -view_host $7 $8 ; 
else 
  exec $MPI_TYPE/bin/mpirun -np $1 mpi_epic.$MACHINE_TYPE \
    -itback $2 -itsave $3 -itextract $4 -itrun $5 -socket $6 -view_host $7 $8 ; 
endif
