*                                                                 
* Copyright (C) 1998 Michael D. Smith                            
*                                                                 
* This program is free software; you can redistribute it and/or   
* modify it under the terms of the GNU General Public License     
* as published by the Free Software Foundation; either version 2  
* of the License, or (at your option) any later version.          
* A copy of this License is in the file:    
*   $EPIC_PATH/License.txt.                          
*                                                                 
* This program is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of  
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            
*                                                                 
* You should have received a copy of the GNU General Public       
* License along with this program; if not, write to the Free      
* Software Foundation, Inc., 59 Temple Place - Suite 330,         
* Boston, MA  02111-1307, USA.                                    
*                                                                 

c
c  Version 1. 6/20/95
c
      subroutine convadj(nlevels,grav0,hfrac,p0,temp0,fp0)
      implicit none
      integer i,j,bottom,top,nlevels,init/0/
      integer conv(401,2),convl(401)
      real*8 a(2000,6),temp(401),fp(401),p(401),grav,temp5
      real*8 p0(2*nlevels),temp0(nlevels),fp0(nlevels),grav0
      real*8 hfrac,gascon,x0,x1,x2,tol,superad(401,2),tot1,tot2
      real*8 deltap(401),junk(401),x0b,x1b,x2b,fp2(401)
      real*8 theta00,cpr,tol2,theta0(400,3),junk1(401),cphe
      real*8 junk2(401),avemu,dlntemp
      save
c
      grav=grav0*100.d0                   ! MKS -> CGS
      gascon=8.314d7                      ! Universal gas constant
      avemu=2.d0*hfrac+4.d0*(1.d0-hfrac)
      tol=0.00001d0                       ! something small
      tol2=2.d0*tol
      do i=1,nlevels
         p(i)=log(10.d0*p0(2*(nlevels+1-i)))   ! invert, MKS -> log(CGS)
         deltap(i)=10.d0*(p0(2*(nlevels+1-i)+1)-p0(2*(nlevels+1-i)-1))
         temp(i)=temp0(nlevels+1-i)
         fp(i)=fp0(nlevels+1-i)
      end do
c
c  Set-up
c
      if (init.eq.0) then
c
c  Set up tables of para frac, ortho-para energy diff, specific heats
c    column 1=fp, column 2=ortho rot. energy, column 3=para rot. energy
c    column 4=cp(para), column 5=cp(ortho), column 6=cp(equil)
c
         init=1
         call parafrac(a)
c
c  Calculate theta arrays
c
         cpr=2.5d0
         cphe=(1.d0-hfrac)*2.5d0
         theta00=log(1.5d0)
         theta0(1,1)=0.d0
         theta0(1,2)=0.d0
         theta0(1,3)=0.d0
         do i=2,400
            temp5=5.*i
            dlntemp=log(i+.5d0)-log(i-.5d0)
            theta0(i,1)=theta0(i-1,1)+a(temp5,4)*dlntemp/cpr
            theta0(i,2)=theta0(i-1,2)+a(temp5,5)*dlntemp/cpr
            theta0(i,3)=theta0(i-1,3)+2.5d0*dlntemp/cpr
         end do
      end if
c
c  ***** Check for CONVECTION -- flag layers where it is occurring *****
c
      do i=1,nlevels       ! reset convection flags
         convl(i)=0
      end do
c
 50   do i=1,nlevels-1
c move bubble up
         call makead(4,hfrac,cphe,i,i+1,temp(i),a,p,junk,fp)
         superad(i,1)=(temp(i+1)-temp(i)-junk(i+1)+junk(i))/
     +                                          (p(i+1)-p(i))
         if (superad(i,1).gt.tol) then
            conv(i,1)=1
         else
            conv(i,1)=0
         end if
c move bubble down
         call makead(4,hfrac,cphe,i+1,i,temp(i+1),a,p,junk,fp)
         superad(i,2)=(temp(i+1)-temp(i)-junk(i+1)+junk(i))/
     +                                          (p(i+1)-p(i))
         if (superad(i,2).gt.tol) then
            conv(i,2)=1
         else
            conv(i,2)=0
         end if
      end do         
      superad(nlevels,1)=0.
      superad(nlevels,2)=0.
c
c ********************************
c  Find NEW regions of convection
c ********************************
c
      do i=1,nlevels-1         ! average of upward and downward
         if (superad(i,1)+superad(i,2).gt.tol2) then
            if (convl(i).eq.0) convl(i)=1
         else
            if (convl(i).eq.2) convl(i)=0
         end if
      end do
c
c  Looking for a NEW convecting layer
c
 55   do i=1,nlevels
         if (convl(i).eq.1) goto 60
      end do
      goto 999                 ! NO NEW CONVECTING REGIONS -> DONE!
c
c  Look for bottom of convecting layer. convl(i)>0 is any convecting layer.
c
 60   do while ((convl(i).ne.0).and.(i.ge.1))
         i=i-1
      end do
      i=i+1
      bottom=max(i,1)
c
c  Look for top of convecting layer
c
      do while ((convl(i).ne.0).and.(i.le.nlevels))
         i=i+1
      end do
      top=min(i,nlevels)
c
c **************************
c  Do convective adjustment. Find initial enthalpy, entropy
c **************************
c
      call intentropy(bottom,top,temp,a,deltap,cpr,cphe,
     +                theta0,theta00,p,fp,hfrac,x0)
      call enthalpy(bottom,top,temp,fp,a,deltap,hfrac,gascon,x0b)
c     
c  Mix fp. store in array fp2 temporarily (until we're sure it's OK energetically)
c
      tot1=0.d0
      tot2=0.d0
      do j=bottom,top
         tot1=tot1+fp(j)*deltap(j)/grav
         tot2=tot2+deltap(j)/grav
      end do
      do j=1,nlevels
         fp2(j)=fp(j)
      end do
      do j=bottom,top
         fp2(j)=tot1/tot2
      end do
c
c ************************************************
c  Find new temperature. Conserve total enthalpy.
c ************************************************
c
      call makead(4,hfrac,cphe,bottom,top,temp(bottom),
     +           a,p,junk1,fp2)
      call intentropy(bottom,top,junk1,a,deltap,cpr,cphe,
     +           theta0,theta00,p,fp2,hfrac,x1)
c
      call makead(4,hfrac,cphe,bottom,top,temp(bottom)+.001d0,
     +           a,p,junk2,fp2)
      call intentropy(bottom,top,junk2,a,deltap,cpr,cphe,
     +           theta0,theta00,p,fp2,hfrac,x2)
c
      junk(bottom)=temp(bottom)+.001*(x0-x1)/(x2-x1)
      call makead(4,hfrac,cphe,bottom,top,junk(bottom),
     +          a,p,junk,fp2)
      call enthalpy(bottom,top,junk,fp2,a,deltap,hfrac,gascon,x0)
c
c  Mark convecting region. convl(j)=2 => mixing tried but not allowed
c                          convl(j)=3 => mixing tried AND allowed. Mixed.
c
      if (x0.gt.x0b) then
         do j=bottom,top-1           ! mixing not allowed energetically
            if (convl(j).lt.3) convl(j)=2
         end do
         goto 55
      else                           ! mixing allowed energetically
         call enthalpy(bottom,top,junk1,fp2,a,deltap,hfrac,
     +              gascon,x1b)
         call enthalpy(bottom,top,junk2,fp2,a,deltap,hfrac,
     +              gascon,x2b)
         temp(bottom)=temp(bottom)+.001*(x0b-x1b)/(x2b-x1b)
c
         call makead(4,hfrac,cphe,bottom,top,temp(bottom),
     +               a,p,temp,fp2)
         do j=bottom,top-1
            fp(j)=fp2(j)
            convl(j)=3
         end do
         fp(top)=fp2(top)
      end if
      goto 50
c
 999  do i=1,nlevels
         temp0(nlevels+1-i)=temp(i)
         fp0(nlevels+1-i)=fp(i)
      end do
      return
      end
c**************************************************************************
      subroutine parafrac(a)
      implicit none
      integer j,xx,tt
      real*8 fp,fo,t,f,ep,eo,x,cpp,cpo,cpp2,cpo2
      real*8 a(2000,6),cpe,cpe2
      save
c
      f(xx)=(59.322d0*xx*(xx+1)-.0471d0*xx*xx*(xx+1)*(xx+1))*1.438786d0
c
      do tt=10,2000
         t=tt/5.d0
         fp=0.d0
         fo=0.d0
         eo=0.d0
         ep=0.d0
         cpp=0.d0
         cpo=0.d0
         cpe=0.d0
         cpp2=0.d0
         cpo2=0.d0
         cpe2=0.d0
         do j=0,16,2
            x=(2.d0*j+1)*exp(-f(j)/t)
            fp=fp+x
            ep=ep+x*f(j)
            cpp=cpp+x*f(j)*f(j)/(t*t)
            cpe=cpe+x*f(j)*f(j)/(t*t)
            cpp2=cpp2+x*f(j)/t
            cpe2=cpe2+x*f(j)/t
            x=3.d0*(2*(j+1)+1)*exp(-f(j+1)/t)
            fo=fo+x
            eo=eo+x*f(j+1)
            cpo=cpo+x*f(j+1)*f(j+1)/(t*t)
            cpe=cpe+x*f(j+1)*f(j+1)/(t*t)
            cpo2=cpo2+x*f(j+1)/t
            cpe2=cpe2+x*f(j+1)/t
         end do
         a(tt,1)=fp/(fp+fo)
         a(tt,2)=ep/fp
         a(tt,3)=eo/fo
         a(tt,4)=2.5d0+cpp/fp-(cpp2/fp)**2
         a(tt,5)=2.5d0+cpo/fo-(cpo2/fo)**2
         a(tt,6)=2.5d0+cpe/(fp+fo)-(cpe2/(fp+fo))**2
      end do
c
      return
      end
c*************************************************************************
      subroutine enthalpy(bottom,top,temp,fp,a,deltap,
     +                    hfrac,gascon,tot1)
      implicit none
      integer j,bottom,top
      real*8 tot1,a(2000,6),temp(401),hfrac,gascon,deltap(401)
      real*8 a2,a3,temp1,temp5,uh,uhe,uint,avemu,fp(401)
      save
c
      avemu=2.d0*hfrac+4.d0*(1.-hfrac)
c
      tot1=0.
      do j=bottom,top
         temp5=5.*temp(j)
         temp1=int(temp5)
         a2=a(temp1+.1,2)+(temp5-temp1)*(a(temp1+1.1,2)-a(temp1+.1,2))
         a3=a(temp1+.1,3)+(temp5-temp1)*(a(temp1+1.1,3)-a(temp1+.1,3))
c
         uh=(2.5d0*temp(j)+fp(j)*a2+(1.d0-fp(j))*a3)
         uhe=2.5d0*temp(j)
         uint=(gascon/avemu)*(uh*hfrac+uhe*(1.d0-hfrac))
         tot1=tot1+uint*deltap(j)
      end do
c
      return
      end
c************************************************************************
      subroutine makead(case,hfrac,cphe,level1,level2,t1,
     +                   a,p,temp,fp)
      implicit none
      integer i,case,iter,level1,level2,x
      real*8 a(2000,6),hfrac,temp(401),fp(401),cp0,cpave,t1
      real*8 temp1,a1,a1i,a4,a5,a6,a4i,a5i,a6i,tlast,temp5,cphe
      real*8 p(401)
      save
c
c  Make an adiabat from level1 to level2 (up or down). t1 is the
c  temperature at level1. The new temperature is stored in the
c  array temp. The number of iterations used in integrating
c  forward to find temperature is in the variable iter.
c
c  case=1 is intermediate adiabat, case=2 is equilibrium adiabat
c  case=3 is adiabat computed with specified fp (in fp array)
c  case=4 uses a constant fp=fp(level1). For cases 1 and 2, a new fp
c  is computed (equilibrium fp) and is stored in the array fp
c
      temp5=5.*t1
      temp1=int(temp5)
      a1=a(temp1+.1,1)+(temp5-temp1)*(a(temp1+1.1,1)-a(temp1+.1,1))
c
      temp(level1)=t1
      if ((case.eq.1).or.(case.eq.2)) fp(level1)=a1
      if (level1.eq.level2) goto 999
      if (level1.lt.level2) x=1           ! integrate upward
      if (level1.gt.level2) x=-1          ! integrate downward
c
      do i=level1+x,level2,x
         temp5=5.*temp(i-x)
         temp1=int(temp5)
         a4=a(temp1+.1,4)+(temp5-temp1)*(a(temp1+1.1,4)-a(temp1+.1,4))
         a5=a(temp1+.1,5)+(temp5-temp1)*(a(temp1+1.1,5)-a(temp1+.1,5))
c
         if (case.eq.2) then
            a6=a(temp1+.1,6)+(temp5-temp1)*
     +        (a(temp1+1.1,6)-a(temp1+.1,6))
            cp0=hfrac*a6+cphe
         else
            cp0=fp(i-x)*a4+(1.d0-fp(i-x))*a5
            cp0=hfrac*cp0+cphe
         end if
         temp(i)=temp(i-x)+(p(i)-p(i-x))*temp(i-x)/cp0
c
         if ((case.eq.1).or.(case.eq.2)) then
            temp5=5.*temp(i)
            temp1=int(temp5)
            a1i=a(temp1+.1,1)+(temp5-temp1)*
     +         (a(temp1+1.1,1)-a(temp1+.1,1))
            fp(i)=a1i
         end if
c
         tlast=-999.
         iter=0
         do while ((abs(tlast-temp(i)).gt.1.e-6).and.(iter.lt.5))
            tlast=temp(i)
            iter=iter+1
            temp5=5.*temp(i)
            temp1=int(temp5)
            a4i=a(temp1+.1,4)+(temp5-temp1)*
     +          (a(temp1+1.1,4)-a(temp1+.1,4))
            a5i=a(temp1+.1,5)+(temp5-temp1)*
     +          (a(temp1+1.1,5)-a(temp1+.1,5))
c
            if (case.eq.2) then
               a6i=a(temp1+.1,6)+(temp5-temp1)*
     +             (a(temp1+1.1,6)-a(temp1+.1,6))
               cpave=hfrac*.5d0*(a6+a6i)+cphe
            else if (case.eq.4) then
               cpave=.5d0*(fp(level1)*(a4+a4i)+
     +                    (1.d0-fp(level1))*(a5+a5i))
               cpave=hfrac*cpave+cphe
            else
               cpave=.5d0*(fp(i)*a4i+(1.d0-fp(i))*a5i+
     +                     fp(i-x)*a4+(1.d0-fp(i-x))*a5)
               cpave=hfrac*cpave+cphe
            end if
            temp(i)=temp(i-x)+(p(i)-p(i-x))*
     +              .5d0*(temp(i-x)+temp(i))/cpave
c
            if ((case.eq.1).or.(case.eq.2)) then
               temp5=5.*temp(i)
               temp1=int(temp5)
               a1i=a(temp1+.1,1)+(temp5-temp1)*
     +            (a(temp1+1.1,1)-a(temp1+.1,1))
               fp(i)=a1i
            end if
         end do
      end do
c
 999  return
      end
c**************************************************************************
      subroutine intentropy(bottom,top,temp,a,deltap,cpr,cphe,
     +                 theta0,theta00,p,fp,hfrac,tot)
      implicit none
      integer i,bottom,top,tmax
      real*8 tot,temp(401),hfrac,a(2000,6),theta0(400,3),temp0
      real*8 fp(401),deltap(401),p(401),cpr,theta00
      real*8 dlnp,cp0,dlntemp2,a4,a5,temp5,temp1,theta,cphe
      save
c
c  Integrate ln(theta) dp
c
      tot=0.d0
      do i=bottom,top
c
         tmax=int(temp(i)-.5)
         theta=theta00+hfrac*(fp(i)*theta0(tmax,1)+(1.d0-fp(i))*
     +          theta0(tmax,2))+(1.d0-hfrac)*theta0(tmax,3)
         dlntemp2=log(temp(i))-log(tmax+.5d0)
         temp0=.5d0*(temp(i)+tmax+.5d0)
         temp5=5.*temp0
         temp1=int(temp5)
         a4=a(temp1+.1,4)+(temp5-temp1)*(a(temp1+1.1,4)-a(temp1+.1,4))
         a5=a(temp1+.1,5)+(temp5-temp1)*(a(temp1+1.1,5)-a(temp1+.1,5))
         cp0=hfrac*(fp(i)*a4+(1.d0-fp(i))*a5)+cphe
         theta=theta+cp0*dlntemp2/cpr
         dlnp=p(i)-log(1.d6)               ! reference pressure = 1.d6
         theta=theta-dlnp/cpr
c
         tot=tot+theta*deltap(i)
      end do
c
      return
      end


