*                                                                 
* Copyright (C) 1998 Peter J. Gierasch                            
*                                                                 
* This program is free software; you can redistribute it and/or   
* modify it under the terms of the GNU General Public License     
* as published by the Free Software Foundation; either version 2  
* of the License, or (at your option) any later version.          
* A copy of this License is in the file:                          
*   $EPIC_PATH/License.txt                                            
*                                                                 
* This program is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of  
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            
*                                                                 
* You should have received a copy of the GNU General Public       
* License along with this program; if not, write to the Free      
* Software Foundation, Inc., 59 Temple Place - Suite 330,         
* Boston, MA  02111-1307, USA.                                    
*                                                                 

      subroutine get_enthalpy(fp,temperature,h,ff,fpe,uoup)
      parameter(mdim=111,ndim=11)
      implicit double precision (a-h,o-z)
      real*8 thermo_vector(5),temp_grid(mdim),thermo_array(mdim,5)
      common/enthalpy_table/temp_grid,thermo_array,mmax1
      common/composition/xh2,xhe,x3,cpr
      data ccoln/-2.105769/ccpln/-1.666421/

      if(temperature.le.20)then
        h=cpr*temperature
        ff=0.
        fpe=1.
        uoup=175.1340d0
      elseif(temperature.gt.500.)then
        ho=1545.3790+3.5*(temperature-500.)
        hp=1720.3776+3.5*(temperature-500.)
        h=xh2*((1.-fp)*ho+fp*hp)+(xhe*2.5+x3*3.5)*temperature
        ff= xh2*2.5*(ccpln-ccoln)*temperature
     &          -xh2*(hp-ho)
        fpe=0.25
        uoup=0.0d0
      else
        em=dble(mmax1-1)*(temperature    -temp_grid(1))/  ! 0 < em < mmax1-1
     &                    (temp_grid(mmax1)-temp_grid(1))
        m=1+int(em)
        if(m.eq.mmax1)then                     ! 1 < m < mmax1-1
          m=m-1
          fract=1.
        else
          fract=mod(em,1.d0)
        endif
        do j=1,5
          thermo_vector(j)=thermo_array(m,j)*(1.-fract)
     &           +thermo_array(m+1,j)*fract
        enddo
        h=xh2*( (1.-fp)*thermo_vector(1)+fp*thermo_vector(2) )
     &           +xhe*2.5*temperature  +x3*3.5*temperature
        ff=xh2*thermo_vector(3)
        fpe=thermo_vector(4)
        uoup=thermo_vector(5)
      endif

      return
      end

      subroutine get_theta(fp,p,temperature,theta,th_ortho,th_para)
      parameter(mdim=111)
      implicit double precision (a-h,o-z)
      real*8 t_grid(mdim),theta_array(mdim,2),thermo_vector(2)
      common/theta_table/t_grid,theta_array,mmax2
      common/composition/xh2,xhe,x3,cpr
      data ccoln/-2.105769/ccpln/-1.666421/p0/1.0d5/

      if (temperature .le. 20.) then
        theta    = temperature
        th_ortho = temperature
        th_para  = temperature
      elseif (temperature .gt. 500.) then
        cc       = xh2*2.5*((1.-fp)*ccoln+fp*ccpln)
        theta = exp(cc/cpr)*temperature**((3.5*xh2+2.5*xhe+3.5*x3)/cpr)
        tt       = temperature**(3.5/2.5)
        th_ortho = 0.12175*tt
        th_para  = 0.18892*tt
      else
        em=dble(mmax2-1)*(temperature   -t_grid(1))/  ! 0 < em < mmax2-1
     &                    (t_grid(mmax2)-t_grid(1))
        m=1+int(em)
        if(m.eq.mmax2)then                     ! 1 < m < mmax2-1
          m=m-1
          fract=1.
        else
          fract=mod(em,1.d0)
        endif
        do j=1,2
          thermo_vector(j)=theta_array(m,j)*(1.-fract)
     &            +theta_array(m+1,j)*fract
        enddo
        thetaln=xh2*( (1.-fp)*log(thermo_vector(1))
     &           +fp*log(thermo_vector(2)) )
     &           +(xhe*2.5+x3*3.5)*log(temperature)/cpr
        theta    = exp(thetaln)
        th_ortho = thermo_vector(1)
        th_para  = thermo_vector(2)
      endif
      pp       = (p0/p)**(1./cpr)
      theta    = theta*pp
      th_ortho = th_ortho*pp
      th_para  = th_para*pp

      return
      end

      subroutine setup(xh2_input,xhe_input,x3_input,cpr_output)
      parameter(mdim=111,ndim=11)
      implicit double precision (a-h,o-z)
      real*8 fpdat(ndim),theta_grid(mdim),t(mdim,ndim),t_grid(mdim)
      real*8 temp(500),tho(500),thp(500)
      real*8 temp_grid(mdim),thermo_array(mdim,5),theta_array(mdim,2)
      common/temp_table/fpdat,theta_grid,t,mmax,nmax
      common/enthalpy_table/temp_grid,thermo_array,mmax1
      common/theta_table/t_grid,theta_array,mmax2
      common/composition/xh2,xhe,x3,cpr
      data max3/500/
      xh2=xh2_input
      xhe=xhe_input
      x3 =x3_input
      cpr=(2.5*(xh2+xhe)+3.5*x3)/(xh2+xhe+x3)
      cpr_output=cpr
      call h2properties(max3,temp,tho,thp)
      call theta2t_table(max3,temp,tho,thp)
      return
      end

      subroutine get_temperature(fp,p,theta,temperature)
      parameter(mdim=111,ndim=11)
      implicit double precision (a-h,o-z)
      real*8 fpdat(ndim),theta_grid(mdim),t(mdim,ndim)
      common/temp_table/fpdat,theta_grid,t,mmax,nmax
      common/composition/xh2,xhe,x3,cpr
      data ccoln/-2.1054/ccpln/-1.6671/p0/1.0d5/

      theta1=theta*(p/p0)**(1./cpr)

      if(theta1.le.20.)then
        temperature=theta1
      elseif(theta1.ge.600.)then
        tlog=(  cpr*log(theta1)-2.5*xh2*((1.-fp)*ccoln+fp*ccpln)  )/
     &                      (2.5*xhe+3.5*(1.-xhe))
        temperature=exp(tlog)
      else

        en=1.+dble(nmax-1)*(fp-fpdat(1))/(fpdat(nmax)-fpdat(1))   ! 1 < en < nmax
        n=int( en )
        if(n.eq.nmax)then
          n=n-1                                         ! 1 < n  < nmax-1
          fract_fp=1.
        else
          fract_fp=mod(en,1.0d0)                  !  fract_fp between 0 and 1
        endif

        em=1.+dble(mmax-1)*(theta1-theta_grid(1))/
     &                      (theta_grid(mmax)-theta_grid(1))
        m=int( em )
        if(m.eq.mmax)then
          m=m-1
          fract_theta=1.
        else
          fract_theta=mod(em,1.0d0)
        endif
        temperature=t(m,n)    *(1.-fract_theta)*(1.-fract_fp)
     &           +t(m,n+1)  *(1.-fract_theta)*fract_fp
     &           +t(m+1,n)  *fract_theta     *(1.-fract_fp)
     &           +t(m+1,n+1)*fract_theta     *fract_fp
      endif

      return
      end



      subroutine h2properties(max3,t,tho,thp)
      parameter(mdim=111,ndim=11)
      implicit double precision (a-h,o-z)
      real*8 t_grid(mdim)
      real*8 temp_grid(mdim),thermo_array(mdim,5),theta_array(mdim,2)
      real*8 t(max3),tho(max3),thp(max3)
      real*8 a(8)
      common/enthalpy_table/temp_grid,thermo_array,mmax1
      common/theta_table/t_grid,theta_array,mmax2

      call numbers(c1)
      c2=log(9.d0)
      p=1.
      theta = 87.567
      do i=1,max3
        temperature=dble(i)
            if(temperature.lt.10.)then
              ho=2.5*temperature
              hp=2.5*temperature
              pottempo=temperature
              pottempp=temperature
              ff=0.
              a(1)=0.d0
              a(2)=175.1340d0
              a(3)=0.d0
            else
        call hydrogen(temperature,a)
c        write(*,'(i4,8f10.4)')i,a(1),a(2),a(3),a(4),a(5),
c     &                   a(6)+a(2)/temperature,a(7)+a(3)/temperature,a(8)
c 1=T, 2,3=u rot for o, p, 4,5=cp for o, p, 6,7=s rot=ln(Z)/N+u/T o, p, 8=cpeq
c        write(1,'(i4,8f10.4)')i,a(1),a(2),a(3),a(4),a(5),
c     &                   a(6)+a(2)/temperature,a(7)+a(3)/temperature,a(8)
c enthalpies normalized to 0 at T = 0, per particle divided by k
        ho=a(2)+2.5*temperature-2*theta
        hp=a(3)+2.5*temperature
c entropies normalized at p0, T-->0, per particle divided by k
        so=-log(p)+2.5*log(temperature)
     &              +1.5*log(2.)+c1+(ho+2.*theta)/temperature+a(6)
        sp=-log(p)+2.5*log(temperature)
     &              +1.5*log(2.)+c1+hp/temperature+a(7)
c potential temperatures, equal T as T-->0
        pottempo=exp(0.4d0*(so-log(9.d0)-1.5*log(2.)-c1-2.5))
        pottempp=exp(0.4d0*(sp          -1.5*log(2.)-c1-2.5))
c curly F, equals -free energy difference, normalized at T=0
        ff=-(so-log(9.d0)-1.5*log(2.)-c1-2.5-ho/temperature)
     &      +(sp-1.5*log(2.)-c1-2.5-hp/temperature)
        ff=ff*temperature
            endif
c Save T, ortho and para enthalpies (offset so h(T=0)=0, ortho and para entropies,
c ortho and para potential temperatures, and curly F. Units are per particle, 
c divided by Boltzmann constant. Potential temperatures and curly F are degrees K and 
c degrees K per particle over k.
        t(i)=temperature
        tho(i)=pottempo
        thp(i)=pottempp
        if(mod(i,5).eq.0)then
          ii=i/5
          temp_grid(ii)=temperature
          thermo_array(ii,1)=ho
          thermo_array(ii,2)=hp
          thermo_array(ii,3)=ff
          thermo_array(ii,4)=a(1)
          thermo_array(ii,5)=a(2)-a(3)
          t_grid(ii)=temperature
          theta_array(ii,1)=pottempo
          theta_array(ii,2)=pottempp
          mmax1=ii
          mmax2=ii
        endif
      enddo
      return
      end

      subroutine numbers(c1)
      implicit double precision (a-h,o-z)
      avagadro=6.02217d23
      atomic_wt=1.66053d-24
      bar=1.01325d06
      boltzmann=1.38062d-16
      degree_kelvin=1.d00
      pi=3.1415926536d00
      planck=6.6262d-27

      c1=log((boltzmann*degree_kelvin)**2.5
     &          /bar*(2.*pi*atomic_wt/planck**2)**1.5)
c      write(*,*)'c1 = ',c1

      return
      end

      subroutine hydrogen(temperature,a)
c    a(1:8) is returned:
c    a(1) equilibrium para fraction
c    a(2),a(3) ortho, para rotational internal energy per particle over k
c    a(4),a(5) ortho, para rotational cp per particle, units k
c    a(6),a(7) ortho, para rotational -Helmholtz free energy per particle over kT
c    a(8) equilibrium H2 (converting) cp per particle, units k
      implicit double precision (a-h,o-z)
      real*8 a(8),z(2,3)
      integer jn(2)
      theta = 87.567
c
      y = theta/temperature
      if(y.gt.30.)y=30.
      do n=1,2
        do m=1,3
          z(n,m)=0.
        enddo
      enddo
      do j=1,50
        jn(1)=2*j-1
        jn(2)=jn(1)-1
        do n=1,2
          ndegeneracy=1+(2-n)*2
          term=ndegeneracy*(2*jn(n)+1)*exp(-jn(n)*(jn(n)+1)*y)
          do m=1,3
            z(n,m)=z(n,m)+term
            if(m.lt.3)term=term*jn(n)*(jn(n)+1)
          enddo
        enddo
        if(j.gt.1 .and. term.lt. 1.d-20) go to 1
      enddo
1     den=z(1,1)+z(2,1)
      a(1)=z(2,1)/den                 !para fraction in equilibrium
      do n=1,2
        a(1+n) = theta*z(n,2)/z(n,1)  !ortho, para rot. energy, over k, per particle
        a(3+n) = y*y*( z(n,1)*z(n,3) - z(n,2)**2 ) /z(n,1)**2
                                      !rot. cp, units k per particle
        a(5+n) = log(z(n,1))          !-rot. Helmholtz free energy per particle, over kT
      enddo
      a(8) = (1.-a(1))*a(4)+a(1)*a(5)
     &    +(a(3)-a(2))*y/temperature*
     &             ( z(2,2)*z(1,1) - z(2,1)*z(1,2) ) /den**2 
                                      !rot. cp equilibrium
c
      return
      end


      subroutine theta2t_table(max3,temp,tho,thp)

      parameter(mmdim=500,mdim=111,ndim=11)
      implicit double precision (a-h,o-z)
      real*8 tho(max3),thp(max3),temp(max3)
      real*8 tvector(mmdim),thvector(mmdim)
      real*8 fpdat(ndim),theta_grid(mdim),t(mdim,ndim)
c      Currently not used:
c      real*8 kappa3,kappahe
      common/temp_table/fpdat,theta_grid,t,mmax,nmax
      common/composition/xh2,xhe,x3,cpr

      data mmax/59/nmax/11/
      data thmin/20.0/thmax/600./fpmin/0.0/fpmax/1.0/
      data cprh2/2.5/cprhe/2.5/cpr3/3.5/

c x3 has cp = 3.5 at all temperatures
c reference value cpr = cp(T->0)

      do m=1,mmax
        theta_grid(m)=(thmin*(mmax-m)+thmax*(m-1))/dble(mmax-1)
      enddo

      do n=1,nmax
        fpdat(n)=(fpmin*(nmax-n)+fpmax*(n-1))/dble(nmax-1)
        do i=1,max3
          thetaln=(  xh2*cprh2*(1.-fpdat(n))*log(tho(i))
     &              +xh2*cprh2*fpdat(n)     *log(thp(i))
     &              +(xhe*cprhe+x3*cpr3) *log(temp(i))   )/cpr
          thvector(i)=exp(thetaln)
          tvector(i)=temp(i)
        enddo
        call trgrid(tvector,max3,mmax,thvector,theta_grid)
        do m=1,mmax
          t(m,n)=tvector(m)
        enddo
      enddo

c      open(1,file='theta2t.table')
c      columns=dble(nmax)
c      write(1,'(<nmax+1>f8.3)')
c     &     columns,(fpdat(n),n=1,nmax)
c      write(1,'(<nmax+1>f8.3)')
c     &     (theta_grid(m),(t(m,n),n=1,nmax),m=1,mmax)
c      close(1)
      return
      end


      subroutine trgrid(a,jm,im,tj,ti)
      implicit double precision (a-h,o-z)
      real*8 a(1000),tj(jm),ti(im),aa(1000)
c
c  TRansform GRID from 1,jm to 1,im. tj and ti are the same function
c  but on the two different grids. The new representation of a is
c  returned in the same array.
c
c  Given a(j), tj(j) and ti(i), find a(i).
c
c  Assume tj and ti monotonic (but possibly in different directions).
c  tj should cover the range of ti; it will extrapolate past end points if not.
c
c  First check direction of increase of tj and reverse tj(j) and 
c  a(j) if necessary.
c
      sign = (tj(jm)-tj(1)) / (ti(im)-ti(1))
      if(sign.lt.0)then
            do 4 i = 1,jm
4            aa(jm+1-i) = tj(i)
            do 5 i = 1,jm
5            tj(i) = aa(i)
            do 10 i = 1,jm
10            aa(jm+1-i) = a(i)
            do 11 i = 1,jm
11            a(i) = aa(i)
      endif
c
c  Now interpolate to find a on the "i" grid.
c
      direction = (tj(jm)-tj(1))/abs(tj(jm)-tj(1))
      do 3 j=1,jm
3      aa(j)=a(j)
      a(im)=aa(jm)
      j=2
      do 1 i=1,im
2      if( (tj(j)-ti(i))*direction .lt. 0. )then
          if(j.lt.jm)then
            j=j+1
            go to 2
          endif
       endif
1      a(i)=aa(j-1)+(aa(j)-aa(j-1))*(ti(i)-tj(j-1))/(tj(j)-tj(j-1))
c
c  Finally put tj back into initial order if necessary.
c
c      if(isign.lt.0)then
c            do 6 i = 1,jm
c6            aa(jm+1-i)=tj(i)
c            do 7 i = 1,jm
c7            tj(i) = aa(i)
c      endif
c
      return
      end




