pro contour,file,pchoice

if (pchoice EQ 1) then begin
  set_plot,'ps'
  device,filename='contour.ps',/landscape
endif

pi  = 4.*atan(1.,1.)
deg = pi/180.

st  =string(80)

; Declare variables

nk = 0 && nj = 0 && nk = 0
latbot   = 0. && lattop   = 0.
pbot     = 0. && ptop     = 0.
a1 = 0. && a2 = 0. 
a3 = 0. 

openr,12,file
readf,12,nk,nj,latbot,lattip,ptop,pbot
readf,12,st


lat    = fltarr(nj,nk)
p_avg  = fltarr(nj,nk)
t_eq   = fltarr(nj,nk)

for k = 1,(nk) do begin
  for j = 1,(nj) do begin
    readf,12,a1,a2,a3
    lat(j,k)      = a1
    p_avg(j,k)    = a2
    t_eq(j,k)     = a2    
  endfor
endfor
close,12
 
tmax = max(t_eq(*,*),min = tmin)

; Define contours:
ncont     = 10
deltacont = (tmax-tmin)/(ncont-1)
contval   = fltarr(ncont)
for j = 0,(ncont-1) do begin
  contval(j) = tmin + j*deltacont
endfor

delx   = (lattop-latbot)
xn     = delx/30
xmarks = fltarr(xn+1)
for j = 0,xn do begin
  xmarks(j) = latbot+(lattop-latbot)*j/xn
endfor

xbot = latbot-xn/2
xtop = lattop+xn/2

contour,t_eq(*,*),lat(*,*),p_avg(*,*), $
  xrange = [xbot,xtop],xstyle = 1, xcharsize = 1.5, xthick = 2., $ 
  xticks = xn, xtickv = xmarks, $
  yrange = [pmax,pmin], ystyle = 1, ytype = 1, ycharsize = 1.5, ythick = 2., $
  nlevels = ncont, levels = contval, c_linestyle = (contval lt 0.0), font = 0, $
  thick = 2., $
  xtitle='Latitude [deg]',ytitle='Pressure [mbar]'

if (pchoice EQ 1) then begin
 device,/close
 set_plot,'x'
endif

return
end


