*
* Copyright (C) 1998 Peter J. Gierasch
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* A copy of this License is in the file:
*   $EPIC_PATH/License.txt
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the Free
* Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA  02111-1307, USA.
*

c
c Saturation vapor pressure subroutines.  
c Returned values are in cgs units.
c

      subroutine psh2o(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,10)
      data a/162.2,1.e-6,172.8,1.e-5,184.8,1.e-4,198.5,1.e-3,214.5,1.e-2
     &      ,223.16,0.0296,233.16,0.0966,243.16,0.317,273.16,4.579
     &      ,373.16,760./
      imax=10
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &            (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end


      subroutine psnh3(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,10)
      data a/93.,1.e-6,98.6,1.e-5,104.8,1.e-4,111.8,1.e-3,120.,1.e-2
     &      ,163.,1.0,193.96,40.,204.76,100.
     &      ,227.76,400.,239.56,760./
      imax=10
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &               (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end

      subroutine psh2s(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,4)
      data a/119.6,0.1,138.26,1.
     &      ,201.36,400.,212.97,760./
      imax=4
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &            (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end

      subroutine psnh4sh(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,4)
      data a/221.9,1.32e3,244.3,1.32e4
     &      ,273.0,1.32e5,306.3,1.e6  /
      imax=4
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &              (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=exp(pln)
      return
      end

      subroutine psph3(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,5)
      data a/101.5,0.1,113.89,1.,130.49,10.,153.95,100.,185.38,760./
      imax=5
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &            (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end

      subroutine psgeh4(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,4)
      data a/109.7,1.,127.6,10.,152.4,100.,184.0,760./
      imax=4
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &             (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end


      subroutine psch4(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,9)
      data a/48.2,0.001,53.1,0.01,59.4,0.1,67.3,1.,77.7,10.,90.66,87.5,
     &       91.8,100.,111.7,760.,134.9,3800./
c
c Units degree Kelvin, pressure Torr.  760 Torr = 1013 mb.
c Triple point 90.66 K.  Data from Landolt-Bo^"rnstein, 1990, Numerical data and 
c functional relationships in science and technology, Springer-Verlag, Berlin.
c
      imax=9
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &              (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end


      subroutine psco2(temperature,pressure)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z),INTEGER(I-N)
      real*8 a(2,12)
      data a/93.,0.013e-3,113.,5.9e-3,133.,0.431,153.,9.81,173.,104.8,
     &       193.,672.2,216.4,3885.2,233.,7545.,253.,14781.,273.,26142.,
     &       293.,42959.,303.,54084./
c
c Units degree Kelvin, pressure Torr.  760 Torr = 1013 mb.
c Triple point 216.4 K.  Data from Handbook of Chem. and Physics.
c
      imax=9
      cgspertorr=1.013e6/760.
      if(temperature.lt.a(1,imax))then
        do i=2,imax
          if (temperature.lt.a(1,i))then
            aa=( log(a(2,i))-log(a(2,i-1)) )/(1./a(1,i-1)-1./a(1,i))
            pln=log(a(2,i-1))+aa*(1./a(1,i-1)-1./temperature)
            go to 1
          endif
        enddo
      else
        aa=( log(a(2,imax))-log(a(2,imax-1)) )/
     &             (1./a(1,imax-1)-1./a(1,imax))
        pln=log(a(2,imax))+aa*(1./a(1,imax)-1./temperature)
      endif
1     pressure=cgspertorr*exp(pln)
      return
      end




