/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                 *
 * Copyright (C) 1998 Timothy E. Dowling                           *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 * A copy of this License is in the file:                          *
 *   $EPIC_PATH/License.txt                                        *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
 *                                                                 *
 * You should have received a copy of the GNU General Public       *
 * License along with this program; if not, write to the Free      *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
 * Boston, MA  02111-1307, USA.                                    *
 *                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * *  transpose.c  * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *       Timothy E. Dowling                                                  *
 *                                                                           *
 *       Transpose a series of files of type                                 *
 *         uvptheta_ddddd-hh:mm:ss.dat                                       *
 *       into a series of type                                               *
 *         theta.u                                                           *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <epic.h>

/* Compile with:
cc -O -I$EPIC_PATH/include -DEPIC_PATH=\"$EPIC_PATH\" -o transpose transpose.c
*/

/*========================== main() =========================================*/

main(int    argc, 
     char **argv)
{
  int
    nk,nj,ni,nt,
    j,jj,l,
    i=1,
    ifile,
    requested_var,
    num_vars,
    shift,
    itmp,
   *day;
  int
    time[2];
  char
    path[80],
    name[8],
    symbol[80],
    header[1024],
    outfile_str[80],
    **infiles,
    *ptr;
  double
    *var,
    *lat,
    theta,
    tmp;
  FILE
    *infile,
    *outfile;

  if (argc == 1) {
    fprintf(stderr,"Usage: %s requested_var# path/prefix*suffix \n",argv[0]);
    return;
  }

  sscanf(argv[1],"%d",&requested_var);
  if (requested_var > 10 || requested_var < 1) {
    fprintf(stderr,"Requested variable = %d outside range.\n",
                    requested_var);
    exit(1);
  }

  nt = argc-2;

  /* Allocate memory */
  infiles = (char  **)calloc((nt+1),sizeof(char *));
  for (ifile = 1; ifile <= nt; ifile++) {
    infiles[ifile] = (char *)calloc(80,sizeof(char));
    strcpy(infiles[ifile],argv[ifile+1]);
  }

  /* Determine path of input files: */
  strcpy(path,argv[2]);
  ptr = strrchr(path,'/');
  if (ptr) {
    *ptr = '\0';
  }
  else {
    /* No path given, so use "." */
    strcpy(path,".");
  }

  /* 
   * Read first file to get sizes and requested variable's symbol.
   */
  infile = fopen(infiles[1],"r");

  fscanf(infile," system: %s  t = %d s, %d yrs \n",
                 name,&time[0],&time[1]);
  fscanf(infile," nk = %d nj = %d ni = %d theta = %lf\n",
         &nk,&nj,&ni,&theta);

  /* Allocate memory */
  day     = (int    *)calloc(     (nt+1),sizeof(int   ));
  lat     = (double *)calloc(     (nj+1),sizeof(double));
  var     = (double *)calloc(     (nt+1),sizeof(double));

  fgets(header,1024,infile);
  fscanf(infile," %d\n",&num_vars);

  if (requested_var > num_vars) {
    fprintf(stderr,"Requested variable = %d > %d \n",
                    requested_var,num_vars);
    exit(1);
  }

  /* l = 0 skips over lat */
  for (l = 0; l <= requested_var; l++) {
    fscanf(infile,"%s",symbol);
  }
  fclose(infile);

  *strchr(symbol,'(') = '\0';

  /* Determine days from infile names: */
  for (ifile = 1; ifile <= nt; ifile++) {
    sscanf((char *)strchr(infiles[ifile],'.')-5,"%05d",&day[ifile]);
  }

  sprintf(outfile_str,"%s/theta%05.0f.%s",path,theta,symbol);
  outfile = fopen(outfile_str,"w");

  fprintf(outfile," system: %s \n",name);
  fprintf(outfile," nk = %d nj = %d ni = %d theta = %5.0f\n",
                   nk,nj,ni,theta);
  fprintf(outfile," Columns marked by time in days. \n");
  fprintf(outfile," %d\n",nt);
  fprintf(outfile,"   lat   ");
  for (ifile = 1; ifile <= nt; ifile++) {
    fprintf(outfile,"%s(%05d)   ",symbol,day[ifile]);
  }
  fprintf(outfile,"\n");

  for (j = grid.jlo; j <= nj; j++) {
    /* Loop over input files */
    for (ifile = 1; ifile <= nt; ifile++) {
      infile = fopen(infiles[ifile],"r");
      fscanf(infile," system: %s  t = %d s, %d yrs \n",
                     name,&time[0],&time[1]);
      fscanf(infile," nk = %d nj = %d ni = %d theta = %lf\n",
                    &nk,&nj,&ni,&tmp);
      if (tmp != theta) {
        fprintf(stderr,"Error reading theta, %f != %f \n",
                        tmp,theta);
        exit(1);
      }
      fgets(header,1024,infile);
      fscanf(infile," %d\n",&itmp);
      fgets(header,1024,infile);
      if (itmp != num_vars) {
        fprintf(stderr,"Error reading num_vars, %d != %d \n",
                        itmp,num_vars);
        exit(1);
      }
      for (jj = grid.jlo; jj <= j; jj++) {
        fscanf(infile,"%lf",&lat[jj]);
        for (l = 1; l <= num_vars; l++) {
          fscanf(infile,"%lf",&tmp);
          if (j == jj && l == requested_var) {
            var[ifile] = tmp;
          }
        }
      }
      fclose(infile);
    }
    fprintf(outfile," %6.1f",lat[j]);
    for (ifile = 1; ifile <= nt; ifile++) {
      fprintf(outfile," %9.2e ",var[ifile]);
    }
    fprintf(outfile,"\n");
  }

  fclose(outfile);

  /* Free memory */
  for (ifile = 1; ifile <= nt; ifile++) {
    free(infiles[ifile]);
  }
  free(infiles);
  free(var);
  free(lat);
  free(day);

  fprintf(stderr,"Wrote file %s \n",outfile_str);

  return;
}

/*======================== end of main() ===================================*/

/* * * * * * * * * * * * * end of transpose.c * * * * * * * * * * * * * * * */ 
