/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                 *
 * Copyright (C) 1998 Timothy E. Dowling                           *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 * A copy of this License is in the file:                          *
 *   $EPIC_PATH/License.txt                                        *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
 *                                                                 *
 * You should have received a copy of the GNU General Public       *
 * License along with this program; if not, write to the Free      *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
 * Boston, MA  02111-1307, USA.                                    *
 *                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 *  AVS subroutine module to create colorbar key
 *
 *  21 January 1993
 *
 *  Albert Fischer 
 *
 */

#include<avs/avs.h>
#include<avs/flow.h>
#include<avs/geom.h>
#include<avs/colormap.h>

#define    RED     0
#define    GREEN   1
#define    BLUE    2
#define    X_COORD 0
#define    Y_COORD 1
#define    Z_COORD 2

typedef float FLOAT3[3];

/*
 * Prototypes:
 */
int colorbar();
int compute(AVScolormap   *colormap, 
            GEOMedit_list *list);
void hsv_to_rgb(double h, double s, double v, 
		double *r,double *g,double *b);

AVSinit_modules()
{
  AVSmodule_from_desc(colorbar);
}

int colorbar()       /* This is the AVS description function */
{
  int  
    input,output; /* Port descriptors */

  AVSset_module_name("Colorbar", MODULE_MAPPER);
  input  = AVScreate_input_port("Colormap", "colormap", REQUIRED);
  output = AVScreate_output_port("Colorbar", "geom");
  AVSautofree_output(output);
  AVSset_compute_proc(compute);

  return(1);
}

int compute(AVScolormap *colormap, GEOMedit_list *list)
{
  GEOMobj     
    *obj = GEOM_NULL;
  int         
    i, j, count;
  FLOAT3      
    *verts,
    *colors;
  double       
    hue, sat, val,
    red, green, blue,
    ref_x, ref_y, ref_z,
    height, width;

  verts =  (FLOAT3 *) malloc(sizeof(FLOAT3)*256*2);
  colors = (FLOAT3 *) malloc(sizeof(FLOAT3)*256*2);

  count = 0;
  for (i = 0; i < 256; i++) {
    for (j = 0; j < 2; j++) {

      hue = colormap->hue[i];
      sat = colormap->saturation[i];
      val = colormap->value[i];
      hsv_to_rgb(hue, sat, val, &red, &green, &blue);
      colors[count][RED]   = (float)red;
      colors[count][GREEN] = (float)green;
      colors[count][BLUE]  = (float)blue;

      verts[count][X_COORD] = (float) -1.+((double)(i)/255.)*2.;
      verts[count][Y_COORD] = (float) -3.+.2*(double)(j);
      verts[count][Z_COORD] = (float) 1.;

      count++;
    }
  }

  obj = GEOMcreate_mesh(GEOM_NULL,(float *)verts,2,256,GEOM_COPY_DATA);
  GEOMadd_float_colors(obj,(float *)colors,2*256,GEOM_COPY_DATA);
  GEOMgen_normals(obj,0);
  GEOMcvt_mesh_to_polytri(obj,GEOM_SURFACE|GEOM_WIREFRAME);

  *list = GEOMinit_edit_list(*list);
  GEOMedit_geometry(*list,"colorbar",obj);
  GEOMedit_render_mode(*list,"colorbar","no_light");
  GEOMdestroy_obj(obj);

  return(1);
}



