/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                 *
 * Copyright (C) 1998 Timothy E. Dowling                           *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 * A copy of this License is in the file:                          *
 *   $EPIC_PATH/License.txt                                        *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
 *                                                                 *
 * You should have received a copy of the GNU General Public       *
 * License along with this program; if not, write to the Free      *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,         *
 * Boston, MA  02111-1307, USA.                                    *
 *                                                                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <math.h>

void hsv_to_rgb (double h,  double s,  double v,
		 double *r, double *g, double *b)
/*
 *	Function to convert HSV values to RGB
 *	All values are in range [0., 1.]
 *
 *	1 August 1991, A. Fischer
 *	Adapted from "Computer Graphics: Principles and Practice, 2nd Ed."
 *	by Foley, van Dam, Feiner & Hughes, 1990, page 593.
 */
{
  int	
    i;
  double 
    f,p,q,t;

	if (s == 0.) {		/* The color is on the black- 		*/
	    *r = v;		/* and-white center line		*/
	    *g = v;
	    *b = v;
	} else {
	    if (h == 1.)
		h = 0.;
	    h = h * 6.;		/* hue is now in [0., 6.) 		*/
	    i = (int)floor(h);	/* floor returns largest integer <= h 	*/
	    f = h - (double)i;	/* f is the fractional part of h.	*/
	    p = v * (1 - s);
	    q = v * (1 - (s * f));
	    t = v * (1 - (s * (1 - f)));
	    switch (i) {
		case 0: 
		    *r = v;
		    *g = t;
		    *b = p;
		    break;
		case 1: 
		    *r = q;
		    *g = v;
		    *b = p;
		    break;
		case 2: 
		    *r = p;
		    *g = v;
		    *b = t;
		    break;
		case 3: 
		    *r = p;
		    *g = q;
		    *b = v;
		    break;
		case 4: 
		    *r = t;
		    *g = p;
		    *b = v;
		    break;
		case 5: 
		    *r = v;
		    *g = p;
		    *b = q;
	    }
	}
}
	    
