;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*                                                                 *
;* Copyright (C) 1998-2003 Raul Morales-Juberias                   *
;*                                                                 *
;* This program is free software; you can redistribute it and/or   *
;* modify it under the terms of the GNU General Public License     *
;* as published by the Free Software Foundation; either version 2  *
;* of the License, or (at your option) any later version.          *
;* A copy of this License is in the file:                          *
;*   $EPIC4_PATH/License.txt                                       *
;*                                                                 *
;* This program is distributed in the hope that it will be useful, *
;* but WITHOUT ANY WARRANTY; without even the implied warranty of  *
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.            *
;*                                                                 *
;* You should have received a copy of the GNU General Public       *
;* License along with this program; if not, write to the Free      *
;* Software Foundation, Inc., 51 Franklin Street, Fifth Floor,     *
;* Boston, MA 02110-1301, USA.                                     *
;*                                                                 *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;* This procedure creates a script to read the data in a given netCDF  *
;* file into IDL variables to be used in viewer programs	       *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

pro nc2idl

epic_path = getenv('EPIC4_PATH')+'/'
path      = getenv('IDL_EPIC_PATH')+'/'

infile    = dialog_pickfile(/read,filter='*.nc',path=path)
script    = path+'script'
print,strcompress('Creating file '+script+' ...')

; Ensure that the netCDF format is supported on the current platform.
if not(ncdf_exists()) then begin 
   print, "The Network Common Data Format is not supported on this platform."
   return
endif

; Open the netcdf file for reading.
ncid = NCDF_OPEN(strcompress(infile, /remove_all))
if (ncid EQ -1) then begin
   print, "The file "+infile+" could not be opened, please check the path."
   return
endif

; Open the output script file for writing.
openw, unit, script, /GET_LUN, ERROR=err
if (err NE 0) then begin
   print, !err_string
   return
endif

; Retrieve general information about this netCDF file.
ncidinfo = NCDF_INQUIRE(ncid)

; Write the file header.
printf, unit, ";* * * * * * * * * * * * * * * *  * * * * * * * * * * * * * * * * * *"
printf, unit, "; IDL script for reading the NetCDF files generated by the EPIC code
printf, unit, ";* * * * * * * * * * * * * * * *  * * * * * * * * * * * * * * * * * *"
printf, unit, ""
printf, unit, "print,strcompress('You are reading the file '+'"+infile+"')"
printf, unit, "filename = '"+infile+"'"
printf, unit, "ncid = NCDF_OPEN('"+infile+"')            ; Open The NetCDF file"
printf, unit, ""
printf, unit,"ncdf_diminq, ncid, 0,time_dim,trange"
printf, unit,"varnames=strarr("+strcompress(string(ncidinfo.Nvars))+")"
names     = strarr(ncidinfo.Nvars)

; Place the variables in local arrays.
for i=0, ncidinfo.Nvars-1 do begin 
   vardata = NCDF_VARINQ(ncid, i)
   varname = vardata.name
   names[i] = vardata.name
   printf, unit, "NCDF_VARGET, ncid, "+strcompress(string(i))+", "+varname+"      ; Read in variable '"+vardata.Name+"'
   printf, unit, "varnames["+strcompress(string(i))+"]="+"string('"+varname+"')"

      for j=0, vardata.Natts-1 do begin
         att = NCDF_ATTNAME(ncid, i, j)
         attname = strcompress(varname+"_"+strcompress(att,/REMOVE_ALL))
         printf, unit, "   NCDF_ATTGET, ncid, "+strcompress(string(i))+", '"+att+"', "+attname
         printf, unit, "   "+attname+" = STRING("+attname+")" 
      endfor
   printf, unit, ""
endfor

; Place the global attributes in local arrays.
  printf, unit, "; Read in the Global Attributes."
  for i=0, ncidinfo.Ngatts-1 do begin
     name = NCDF_ATTNAME(ncid, /GLOBAL, i)
     attname = name
     printf, unit, "NCDF_ATTGET, ncid, /GLOBAL, '"+name+"', "+attname
     printf, unit, attname+" = STRING("+attname+")"
  endfor
  printf, unit, ""

printf, unit, "NCDF_CLOSE, ncid      ; Close the NetCDF file"

printf, unit, "print,strcompress('"+infile+"'+' read')"
print,''
select = 'u'
print,'Select the name of the variable to be used by the rendering programs: '
print, names
read,select

printf, unit, "var2plot = "+select
printf, unit, "var2plotname = '"+string(select)+"'"

; Close the open script file.
free_lun, unit

print,''
print,'Done'

; Return to the caller.
return

; End procedure.
end
