%
% PlotEpicDatFile: Script plots column data from .dat files generated by epic.  
%  Input must be specified in PlotEpicDatFile or set externally by setting
%  load_graphy_options_externally=TRUE;
%
% Required input :  directory,
%                   plot_type
%
% Optional input :  fig_pos, fig_width, fig_color, AxisFontSize, 
%                   Title, XLimits, YLimits, 
%                   xtick, xticklabel, ytick, yticklabel,
%                   postPlot
%                   
%
% The parameter "plot_type" loads pre-defined plotting options.  New plot_types 
%  can be specified in PlotEpicDatFile_defaults.m  Current options are:
%
%                   'THETA-ZETA-VS-P'
%                   'T-VS-P'
%                   'U-VS-P'
%                   'U-VS-LAT'
%                   'VORTICITY-VS-LAT'
%
%


%%
%%----------------------- Definitions ----------------------------
%%
starttime=clock;
TRUE = 1; FALSE = 0;
 

%%
%%------------------Check For Interactive Run----------------------
%%

% the following options must be set prior to executing this script
load_graph_options_externally_exists = length( who('load_graph_options_externally') );

LoadGraphOptions = TRUE;
if load_graph_options_externally_exists
   if load_graph_options_externally
      LoadGraphOptions = FALSE;
   end
end


%%
%%-------------------Graph Options----------------------- 
%%
if LoadGraphOptions
fprintf('Loading Graph Options from PlotEpicDat.m \n')
checkEPICncPATHs();

directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_680mb_no_balance/' ];
%directory = [EPIC_DATA_PATH '/Venus/experiment09/' ];

plot_type = 'THETA-ZETA-K-VS-P';

%fig_width     = [560];
%AxisFontSize  = 20 * min(fig_width) / 560;
%Title         = '\zeta_0=152.128, \zeta_1=420,  (old default)';
%Title         = '\zeta_0=187.447, \zeta_1==555.291,  (calculated)';
%Title         = '\zeta_0=185, \zeta_1=540,  (chosen)';
%Title         = '\zeta_0=155, \zeta_1=575,  (chosen)';
%Title         = '\zeta_0=165, \zeta_1=480,  (chosen)';

%XLimits       = [ 100 900 ];
%YLimits       = 

%xtick         = 
%xticklabel    = 
%ytick         = 
%yticklabel    = 

%postPlot      = 'grid on';
%postPlot      = 'reverseFigAndAxesColors';


end
PlotEpicDatFile_defaults
%%
%%------------------------------------------------------- 
%%



%%
%% ------------------- Get Data from file --------------
%%
fprintf('Reading Data from file ....\n')
num_plot_lines = length(plot_line);
%filepath  = [ directory filename ];
%for ipl=1:num_plot_lines
%
%  % open file
%  fpntr = fopen( filepath, 'r' );
%  if fpntr<0
%     error([ ' Can not find file ' filepath])
%  end
%
%  % skip over header
%  line=1;  
%  while line < file_s_line
%     lineread=fgetl(fpntr); 
%     line = line+1;
%     if feof(fpntr)
%       error([' Can not find the first line of data in ' filepath])
%     end 
%  end
%    
%  % read data from file into variables
%  while 1 
%     clear tmp
%     lineread=fgetl(fpntr);
%     if length(lineread)==0, break, end 
%   
%     tmp = str2num( lineread );
%     if plot_line(ipl).col_x_data > length(tmp)
%        error([' Column ' num2str( plot_line(ipl).col_x_data ) ' does not exist in file ' filepath ])
%     end
%     if plot_line(ipl).col_y_data > length(tmp)
%        error([' Column ' num2str( plot_line(ipl).col_y_data ) ' does not exist in file ' filepath ])
%     end
%
%     line = line+1;
%     plot_line(ipl).x_data( line-file_s_line ) = tmp( plot_line(ipl).col_x_data );
%     plot_line(ipl).y_data( line-file_s_line ) = tmp( plot_line(ipl).col_y_data );
%     
%     if feof(fpntr), break, end 
%  end 
%  fclose(fpntr); 
%end

for ipl=1:num_plot_lines
  filepath    = [ directory plot_line(ipl).filename ];
  file_s_line = plot_line(ipl).file_s_line;
  
  %%
  %% ------------------- Get Data from file --------------
  %%

  % open file
  fpntr = fopen( filepath, 'r' );
  if fpntr<0
     error([ ' Can not find file ' filepath])
  end

  % skip over header
  line=1;  
  while line < file_s_line
     lineread=fgetl(fpntr); 
     line = line+1;
     if feof(fpntr)
       error([' Can not find the first line of data in ' filepath])
     end 
  end
    
  % read data from file into variables
  clear file_data
  while 1 
     clear tmp
     lineread=fgetl(fpntr);
     if length(lineread)==0, break, end 
   
     tmp = str2num( lineread );

     line = line+1;
     file_data( :, line-file_s_line ) = tmp';
     
     if feof(fpntr), break, end 
  end 
  fclose(fpntr); 

  [num_cols num_rows] = size( file_data );


  %%
  %% ------------------- Set Data for Plotting --------------
  %%
%for ipl=1:num_plot_lines

  if ischar( plot_line(ipl).col_x_data )
    plot_line(ipl).valid_legend_data = FALSE;

    col = str2num( plot_line(ipl).col_x_data );
    min_x_data = min( file_data(col,:) );
    max_x_data = max( file_data(col,:) );

    for ik=1:num_rows
      new_plot_line = plot_line(ipl);
      new_plot_line.x_data = [ min_x_data max_x_data ];
      new_plot_line.y_data = [ file_data(plot_line(ipl).col_y_data,ik) file_data(plot_line(ipl).col_y_data,ik) ];
      plot_line(num_plot_lines+ik) = new_plot_line;
    end

  else

    if plot_line(ipl).col_x_data > num_cols
       error([' Column ' num2str( plot_line(ipl).col_x_data ) ' does not exist in file ' filepath ])
    end
    if plot_line(ipl).col_y_data > num_cols
       error([' Column ' num2str( plot_line(ipl).col_y_data ) ' does not exist in file ' filepath ])
    end
    plot_line(ipl).x_data = file_data( plot_line(ipl).col_x_data, : );
    plot_line(ipl).y_data = file_data( plot_line(ipl).col_y_data, : );
    plot_line(ipl).valid_legend_data = TRUE;
  end

end

for ipl=1:num_plot_lines
  if ischar( plot_line(ipl).col_x_data )
    plot_line(ipl) = [];
  end
end

num_plot_lines = length(plot_line);


%%
%% -------------------- Display Figure ------------------
%%
fprintf('Graphing Data ....\n')
figure
fig_pos(3:4) = [ fig_width(1) fig_width(length(fig_width)) ];
set(gcf,'Position', fig_pos);

fcolor = 'w';
if length(who('fig_color'))
  fcolor = fig_color;
end
set(gcf,'Color',fcolor);

hold on


%%
%% -------------------- Display Data on Figure ------------------
%%
for ipl=1:num_plot_lines

  clear X Y lt
  X = plot_line(ipl).x_data;
  Y = plot_line(ipl).y_data;

  if isfield(plot_line, 'x_scale')
    if length(plot_line(ipl).x_scale)>0
      X = X * plot_line(ipl).x_scale;
    end
  end
  if isfield(plot_line, 'y_scale')
    if length(plot_line(ipl).y_scale)>0
      Y = Y * plot_line(ipl).y_scale;
    end
  end

  if isfield( plot_line , 'linetype' )
    if length( plot_line(ipl).linetype ) > 0
       lt = plot_line(ipl).linetype;
    end
  end

  if length(who('lt')) == FALSE
     all_colors_used = TRUE;
     if length(who('lhandle'))
      for ilh=1:length(lhandle)
        for ac=1:length(auto_color)
           if get(lhandle(ilh), 'Color') == auto_color(ac).map
              auto_color(ac).found = TRUE;
           end
           all_colors_used = all_colors_used * auto_color(ac).found;
        end
      end
     end
     if all_colors_used
        for ac=1:length(auto_color)
           auto_color(ac).found = FALSE;
        end
     end
     ac=1;
     while length(who('lt')) == FALSE
        if auto_color(ac).found == FALSE
           lt = auto_color(ac).char;
        end
        ac=ac+1;
     end
     plot_line(ipl).linetype = lt;
  end

  lhandle(ipl) = plot( X, Y, lt );
  box on

  if length(who('LogXData'))
  if LogXData
     set(gca,'XScale', 'log')
  end
  end

  if length(who('LogYData'))
  if LogYData
     set(gca,'YScale', 'log')
  end
  end

  linewidth = 1.0 * min(fig_width)/560;
  if isfield( plot_line, 'linewidth' )
     if length( plot_line(ipl).linewidth ) > 0
       linewidth = plot_line(ipl).linewidth;
     end
  end
  set( lhandle(ipl), 'LineWidth', linewidth );

  markersize = 8.0 * min(fig_width)/560;
  if isfield( plot_line, 'markersize' )
     if length( plot_line(ipl).markersize ) > 0
       markersize = plot_line(ipl).markersize;
     end
  end
  set( lhandle(ipl), 'MarkerSize', markersize );


end

fprintf('\nData Graphed:\n');
for ipl = 1 : num_plot_lines
  clear name lt
  name = plot_line(ipl).name;
  for ic=length(name):-1:1
     if name(ic)=='\'
        name(ic) = [];
     end
  end
  lt = plot_line(ipl).linetype;
  if length(lt) < 3
     lt(length(lt)+1:3) = ' ';
  end
  fprintf(['\t(' lt ')  ' name '\n']);
end
 

%%
%% ---------------------------- Post Plotting Functions ---------------------------
%%
if length(who('AxisFontSize'))
  set(gca,'FontSize', AxisFontSize );
end
 
if length(who('Title'))
  title( Title );
end
 
if length(who('XLabel'))
  xlabel( XLabel );
end
 
if length(who('YLabel'))
  ylabel( YLabel );
end

if length(who('XLimits'))
  cur_axis = axis;
  cur_axis(1) = XLimits(1);
  cur_axis(2) = XLimits(2);
  axis( cur_axis );
end

if length(who('YLimits'))
  cur_axis = axis;
  cur_axis(3) = YLimits(1);
  cur_axis(4) = YLimits(2);
  axis( cur_axis );
end
 
revX=FALSE;
if length(who('ReverseXaxis'))
  revX = ReverseXaxis;
end
revY=FALSE;
if length(who('ReverseYaxis'))
  revY = ReverseYaxis;
end
if revX & not(revY)
   view(180,-90);
elseif not(revX) & revY
   view(0,-90);
elseif revX & revY
   view(180,90);
end

if length(who('xtick'))
  set(gca,'XTick',xtick);
end
if length(who('ytick'))
  set(gca,'YTick',ytick);
end
if length(who('xticklabel'))
  set(gca,'XTickLabel',xticklabel);
end
if length(who('yticklabel'))
  set(gca,'YTickLabel',yticklabel);
end

if length(who('SquareAxes'))
   if SquareAxes
      fpos = get(gcf,'Position');
      apos = get(gca,'Position');
      if fpos(3) > fpos(4)
          apos(3) = apos(4)*fpos(4) / fpos(3);
      else
          apos(4) = apos(3)*fpos(3) / fpos(4);
      end
      xbuff = 0.035 * fpos(3)/560;
      apos(1) = 0.5*(1.0 - apos(3)) + xbuff;
      set(gca,'Position',apos);
   end
end

if length(who('DisplayLegend'))
  if DisplayLegend
     if length(who('LegendLocation'))
        leg_loc = LegendLocation;
     else
        leg_loc = 'Best';
     end
     Legend = 'leg_handle = legend(gca, ';
     for ipl=1:num_plot_lines
        if plot_line(ipl).valid_legend_data
          Legend = [ Legend '''' plot_line(ipl).name ''',' ]; 
        end
     end
     Legend = [ Legend  ' ''Location'', ''' leg_loc ''' ); ' ];
     eval( Legend );
     legend boxoff
  end
end


if length(who('postPlot'))
  eval( postPlot );
end

 
%fprintf('\n\tRun Time = %f minutes\n\n', etime(clock,starttime)/60) 
 
 
 
 
