%
% PlotEpicNC:  Script plots variables from extract files generated by epic.  Input must be
%  set in PlotEpicNC or set externally by appropriately setting the variables 
%  load_files_externally, load_comparisons_externally, and extract_ncfile_externally.  
%
% 06-16-06: Line plots mark change the line style of k_sigma to '-.' to indicate the first layer of
%           the theta region.  Also, attempted to add ability to extract the k=0 layer for interface
%           variables (theta, p3, etc.), but the var() function returns the k=1 index when k=0 is 
%           specified.  Thus, the capability to extract interface variables on k=0 was therefore removed. 
%
%
% Key Input options:  filepath               (full path to the nc extract file)
%                     extract_it             (time indices to extract from nc file)
%                     extracct_ik            (depth indices to extract from nc file)
%                     vars_to_plot(:).name   (names of variables to plot)                     
%                     scale_data             (multiply all data points by a constant)
%                     logarithmic_plot       (take log10 of data, must specify min_logarithmic_limit)
%                     plot_type              (see below)
%
% plot_type options:   
%
%   _______________________________________________________________________________________ 
%  |                    |               |                 |                |               |
%  |                    |     Plot      |      Plot       |      Plot      | Num. Required |
%  |        Name        |     Type      |   Coordinates   |   Dimensions   |   Variables   |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |    SCALAR-CART     |     Color     |    Cartesean    |       2D       |       1       |
%  |                    |               |                 |                |               |
%  | SCALAR-MULTI-LAYER |     Color     |    Cartesean    |       3D       |     > 1       |
%  |                    |               |                 |                |               |
%  |   SCALAR-SPHERE    |     Color     |    Spherical    |       3D       |       1       |
%  |                    |               |                 |                |               |
%  |   SCALAR-CONTOUR   |    Contour    |    Cartesean    |       2D       |       1       |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |  TOPOGRAPHY-CART   |    Surface    |    Cartesean    |       3D       |       1       |
%  |                    |               |                 |                |               |
%  | TOPOGRAPHY-SPHERE  |    Surface    |    Spherical    |       3D       |       1       |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |    VECTOR-CART     |    Vector     |    Cartesean    |       2D       |       2       |
%  |                    |               |                 |                |               |
%  |   VECTOR-SPHERE    |    Vector     |    Spherical    |       3D       |       2       |
%  |                    |               |                 |                |               |
%  |  VECTOR-CONTOUR    |    Contour    |    Cartesean    |       2D       |       2       |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |  LONG-SLICE-LINE   |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |  LONG-SLICE-RLINE  |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |  LONG-SLICE-SURF   |    Surface    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |  LONG-SLICE-CONT   |    Contour    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |  LONG-SLICE-PSURF  |    Surface    |   Pres vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |  LONG-SLICE-PCONT  |    Contour    |   Pres vs Lat   |       2D       |      > 2      |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |   ZONAL-AVE-LINE   |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-AVE-RLINE  |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-AVE-SURF   |    Surface    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-AVE-CONT   |    Contour    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-AVE-PSURF  |    Surface    |   Pres vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-AVE-PCONT  |    Contour    |   Pres vs Lat   |       2D       |      > 2      |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |   ZONAL-MAX-LINE   |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-MAX-RLINE  |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-MAX-SURF   |    Surface    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-MAX-CONT   |    Contour    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-MAX-PSURF  |    Surface    |   Pres vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-MAX-PCONT  |    Contour    |   Pres vs Lat   |       2D       |      > 2      |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  |   ZONAL-ANOM-LINE  |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-ANOM-RLINE |     Line      | Variable vs Lat |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-ANOM-SURF  |    Surface    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-ANOM-CONT  |    Contour    |   Zeta vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-ANOM-PSURF |    Surface    |   Pres vs Lat   |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  |   ZONAL-ANOM-PCONT |    Contour    |   Pres vs Lat   |       2D       |      > 2      |
%  |____________________|_______________|_________________|________________|_______________|
%  |                    |               |                 |                |               |
%  | VERTICAL-AVE-SURF  |    Surface    |    Cartesean    |       2D       |      > 2      |
%  |                    |               |                 |                |               |
%  | VERTICAL-AVE-CONT  |    Contour    |    Cartesean    |       2D       |      > 2      |
%  |____________________|_______________|_________________|________________|_______________|
%  Note:  A "variable" is defined here as any 2D field (e.g., the zonal velocity on layers k1
%         and k2 is defined as 2 sepparate variables).
%
%
% plot_type dependent options:
%                     vector_arrow_scale     (used by VECTOR plots, 1.0=no effect)
%                     num_rotations          (used by TOPOGRAPHY, and SPHERE plots)
%                     longitude_slice        (used by LONG-SLICE, default=0.0)
%                     value_at_poles         (should be 0.0 for variable 'v';  can also set to 'average')
%                     shading_type           (used in surface plots, default is matlab default shading)
%
%                     contour_plot_type      (0 => standard line contour, 1 => filled contours)
%                     num_contour_lines      (number of automatically generated contours)
%                     contour_lines          (array specifying which contours are drawn)
%                     contour_lines_label    (array specifying which contours are labeled; 'none' to turn off)
%
% Additional input options:
%                     plot_grid_only         (show mesh only)
%                     use_auto_color_map     (default is TRUE, must specify zmin and zmax when FALSE)
%                     convert_Pa_to_mbar     (convert variables with units of Pa to milibars, default is FALSE)
%                     min_display_resolution interpolate data to a finer resolution before displaying (helps with contour plots)
%
%                     fig_pos                (X and Y position of lower left corner of figure)
%                     fig_width              (suggested 560)
%                     background_color       (color of figure outside of axis :  'k', 'w', 'g', etc.)
%                     alter_fig_width_for_globe  (makes globe visually pleasing, default is FALSE)
%                     override_fig_orientation   (explicitly set figure position, width, and height)
%
%                     disp_axis              (set to FALSE to not display axes)
%                     maximize_display       (set to TRUE to use entire figure as canvass)
%                     fill_axis_in_figure    (0.0 to 1.0 where 1.0 uses the Matlab default)
%                     left_right_justify     (0.0=full left  ,  0.5=center,  1.0=full right)
%                     bottom_top_justify     (0.0=full bottom,  0.5=center,  1.0=full top  )
%                     AxisFontSize           (default is 16 * fig_width / 420)
%                     override_axis_limits   (explicitly set axis limits)
%
%                     Title                  
%                     XLabel                 (override x-axis label)
%                     YLabel                 (override y-axis label)
%                     xtick, xticklabel      (position and labels of ticks on x-axis)
%                     ytick, yticklabel      (position and labels of ticks on x-axis)
%
%                     colormap_type          (e.g., 'rbg', 'gray', 'light-gray')
%                     color_bar_orientation  (1=horiz, 2=vert, 0=off)
%                     color_bar_width        (percentage of figure to expand colorbar, default is 0.75)
%                     color_bar_font_size    (default is 12 * fig_width / 560)
%
%                     display_text_box       (set to TRUE to display the text messge defined by text_box)
%
%


%
% Initialize
%
EpicNC_initialize


%
% Input file and directory
%
if ( SetFile==TRUE )
  fprintf('Setting Input File .....\n')
  checkEPICncPATHs();

  %directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_100mb_exp_balance/'];
  %directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_100mb_inv_balance/'];
  %directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_100mb_no_balance/'];
  %directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_680mb_exp_balance/'];
  %directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_680mb_inv_balance/'];
  %directory = [EPIC_DATA_PATH '/Jupiter/grs_McIntyre_psigma_680mb_no_balance/'];

  directory = [EPIC_DATA_PATH '/Jupiter/Herrnstein_balance_develop/'];
  %directory = [EPIC_DATA_PATH '/Venus/experiment09/'];
  %filename = 'extract30-49.nc';
  filename = 'epic.nc';
  
  filepath = [ directory filename ];
end


%
% Output Parameters
%
if ( SetOutput==TRUE )   
  fprintf('Setting Ouput Parameters .....\n')
  %bmp_filename  = [directory 'saved_fig'];

  iv=1;
  %vars_to_plot(iv).name = 'u';     iv=iv+1;
  %vars_to_plot(iv).name = 'v';     iv=iv+1;
  %vars_to_plot(iv).name = 'p3';     iv=iv+1;
  vars_to_plot(iv).name = 'theta';     iv=iv+1;
  %vars_to_plot(iv).name = 't3';     iv=iv+1;
  %vars_to_plot(iv).name = 'gz2';     iv=iv+1;
  %vars_to_plot(iv).name = 'pv2';     iv=iv+1;
  %vars_to_plot(iv).name = 'vort2';     iv=iv+1;
  %vars_to_plot(iv).name = 'hdry';     iv=iv+1;
  %vars_to_plot(iv).name = 'exner3';     iv=iv+1;
  %vars_to_plot(iv).name = 'rho3';     iv=iv+1;

  extract_it = 'first';
  extract_ik = 'all';

  %plot_type = 'VERTICAL-AVE-CONT';
  %plot_type = 'VECTOR-CART';
  plot_type = 'LONG-SLICE-LINE';
  %plot_type = 'ZONAL-AVE-PCONT';

  vector_arrow_scale    = 3.0;
  thin_vector_plot_iters = 2;
  %scale_data            = 1.0e9;
  convert_Pa_to_mbar    = TRUE;
  longitude_slice       = 00.0;
  num_rotations         = 0.0;
  %background_color      = 'k';

  logarithmic_plot      = FALSE;
  min_logarithmic_limit = 1.0e-2;

  shading_type          = 'interp';  
  plot_grid_only        = FALSE;
  
  use_auto_color_map    = TRUE;
  zmin = -170;  zmax = 120;
  colormap_type         = 'light-gray';
  remap_to_pressure_surfaces = FALSE; 
  
  fig_pos = [ 50, 375 ];   % X and Y lower corners of figure as displayed on screen
  fig_width = 420;
  %fig_width = 560;         % use this setting for making high resolution bitmaps
  %fig_width = 900;        % use this setting for making super high resolution bitmaps
  alter_fig_width_for_globe = FALSE;

  Title = ' ';

  disp_axis           = TRUE;
  maximize_display    = FALSE;
  fill_axis_in_figure = 0.85;
  AxisFontSize        = 16 * fig_width / 420;

  color_bar_orientation = 1;   % 1 for horizontal,  2 for vertical
  color_bar_width       = 0.750;
  color_bar_font_size   = 12 * fig_width / 560;
  
  display_text_box = FALSE;
  text_box.name            = 'g/m^2  =  10\^';
  %text_box.location        = [ 0.35*(1.0-color_bar_width)  0.075 ];
  text_box.location        = [ 0.01  0.035 ];
  text_box.font_size       = 15;
  text_box.character_width = 1;
  text_box.background      = 'white';  % 'none'
  text_box.edge            = 'none';      % 'none'
  

end
PlotEpicNC_defaults
%%
%%
%%



%%
%% Extract Data
%%
if ( ExtractNCdata )
  fprintf('Extracting NC File .....\n')
  clear epic_vars dimensions
  %epic_vars = getEpicVarFromMatFile(vars_to_plot,'/Users/aherrnst/CPL/Venus/experiment09/MatFiles/TimeAverageEpicData_Venus');
  [epic_vars, dimensions, nc_file] = ExtractEpicNCdata( filepath, vars_to_plot, extract_it, extract_ik );
  %nc_file(1).pntr = netcdf([EPIC_DATA_PATH '/Venus_Flat/experiment07/extract.nc']);
end
%%
%%
%%



%%
%% Plot NC Data
%%   
for iv=1 : 1 : num_plot_vars

   plot_success = FALSE;

   setExtractIndices

   %for it=1:length(extract_it), if extract_it(it)<=length( var(nc_file,'time' )
   for it=1:1:length(extract_it), if it<=length( epic_vars(iv).time )
     for ik=1:1:length(extract_ik), if extract_ik(ik)<=length( var(nc_file(1).pntr,'sigmatheta_u') )

        prepareDataForPlotting
        displayNewFigure

        processDataForPlotting
        processPrettyGraphics

        fprintf([' (min,max) = (' num2str(zmin) ', ' num2str(zmax) ')\n']);
        plot_success = TRUE;
     end, end
   end, end

end % loop over variables
   
%getChannelMaxMin( nc_file, epic_vars, vars_to_plot, [-35 -15], 'VECTOR2D' )

%
% Display Text Box
%
if ( display_text_box ) 
   tb_id = displayTextBox( text_box );
end
   



%%
%% write figure to bmp file
%%
if length( who('bmp_filename') ) == 1
   fprintf(['writing file ' bmp_filename '\n'])
   writeFig2Bitmap( bmp_filename );
end


