  

%
% MxN attributes
%
%attribute_name    = 'Div_EP_Flux';
if length(who('root_data_dir'))==0
   root_data_dir  = [EPIC_DATA_PATH slash]; 
end
if length(who('planet'))==0
   planet         = 'Venus';
end
if length(who('experiment_dir'))==0
   experiment_dir = 'experiment06';
end

nc_file_directory     = [root_data_dir planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];


postExtract      = [ 'processEpicVarsForEPflux;  ' ];
postPlot         = [ 'box on;  '                              ...
                     ... %'view(0.05, 90.025); '                   ...            % (necessary to see plot box)
                     'set(gca,''ZColor'',''w'');  '           ...
                   ];

if length(who('PresentationSlides'))>0
  if PresentationSlides
     postPlot = [postPlot ' view(0.05, 90.025); '];
  end
end


%
% PlotEpicNC attributes
%
PlotData          = 'PlotEpicNC;';
plot_type         = 'SCALAR-CONTOUR';
%plot_type         = 'SCALAR-CART';
contour_plot_type = 1;    % 0 => no fill contours,  1 => filled contours
num_contour_lines = 10;

iv=1;
vars_to_plot(iv).name = 'u';         iv=iv+1;
vars_to_plot(iv).name = 'v';         iv=iv+1;
vars_to_plot(iv).name = 'hdry';      iv=iv+1;
vars_to_plot(iv).name = 'theta';     iv=iv+1;
vars_to_plot(iv).name = 'theta2';    iv=iv+1;
vars_to_plot(iv).name = 'mont2';     iv=iv+1;
vars_to_plot(iv).name = 'hdry3';     iv=iv+1;
vars_to_plot(iv).name = 'p3';        iv=iv+1;
vars_to_plot(iv).name = 'heat3';     iv=iv+1;
vars_to_plot(iv).name = 'exner3';    iv=iv+1;

%extract_it     = 121;
extract_ik     = 'all'; 

%Title  = 'Topography';
Title  = ' ';
XLabel = 'Latitude';
YLabel = 'Potential Temperature  ( K ) ';
xtick  = [-90 -45 0 45 90];
left_right_justify  = 0.68;

%
% THESE OPTIONS NEED TO BE MORE USER FRIENDLY
%
%logarithmic_plot      = TRUE;
%min_logarithmic_limit = 1.0e-20;
%use_auto_color_map    = FALSE;
%zmin = -10.0;  zmax = -4.0;
%postExtract = [postExtract 'epic_vars(1).units = ''m/s^2''; ' ];

logarithmic_plot     = FALSE;
scale_data           = 1.0e06;
use_auto_color_map   = TRUE;
%zmin = 0;  zmax = 10;
postExtract = [postExtract 'epic_vars(1).units = ''x10^{-6} m/s^2''; ' ];


if strcmp(plot_type,'SCALAR-CONTOUR')>0
   change_contour_colors = TRUE;
   if length(who('PresentationFigs'))
      change_contour_colors = not( PresentationFigs );
   end
   if change_contour_colors
      %postPlot = [   postPlot            ...
      %             ' invertPlotColors; ' ...
      %           ]; 
   end
end



if length(strfind(plot_type,'CONTOUR'))==0  |  contour_plot_type==1
  display_colorbar_fig  = TRUE;
else
  display_colorbar_fig  = FALSE;
end

%colormap_type         = 'gray';
make_x_data_periodic  = FALSE;
AxisFontSize          = 8 * max(fig_width_mxn) / 420;
%override_axis_limits  = [-90 90 285 515 ];
%override_axis_limits  = [-90 90 300 515 ];
display_time_text_box = TRUE; 
clear value_at_poles
  
color_bar_width = 0.75;
%postColorbarPlot      = 'reverseFigAndAxesColors';
 
%TitleFont = AxisFontSize+5;
time_text_box.location = [ 0.01 0.5 ];
time_text_box.font_size = 20;

if length(who('makeSlidesEpicNC_overrides'))
   eval( makeSlidesEpicNC_overrides );
end 


