
%
% Side attributes
%
checkEPICncPATHs
if length(who('root_data_dir'))==FALSE
  root_data_dir         = [EPIC_DATA_PATH slash]; 
end
if length(who('planet'))==FALSE
  planet                = 'Venus';
end
if length(who('experiment_dir'))==FALSE
  experiment_dir        = 'experiment06';
end

nc_file_directory     = [root_data_dir planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];


%
% PlotEpicNC attributes
%
PlotData              = 'PlotEpicNC';

Title                 = 'Meridional Wind';
vars_to_plot.name     = 'v'; 
YLabel                = 'm / s';
slide_freq            = 10;
%extract_it            = 'last';  % (always comment out for animations!!!)
extract_ik            = 'all'; 
value_at_poles        = 0.0;
AxisFontSize          = 8 * max(fig_width_mxn) / 420;
display_text_box      = FALSE;
display_time_text_box = TRUE; 
time_text_box.font_size = 20;

if length(who('longitude_slice')) == 0
  longitude_slice       = 0.0;
end

if strfind( planet, 'Venus' )
  override_axis_limits  = [-90 90 -60.0 20.0];
  xtick                 = [-90 -45 0 45 90];
elseif strfind( planet, 'Jupiter' )
  %override_axis_limits  = [-38 -8 -300.0 300.0];
  %xtick                 = [-38 -30.5 -23 -15.5 -8];
end

if length(who('makeSlidesEpicNC_overrides'))
   eval( makeSlidesEpicNC_overrides );
end 

if length(who('plot_type'))==0
   plot_type = 'LONG-SLICE-LINE';
end

