
%
% Side attributes
%
checkEPICncPATHs
if length(who('root_data_dir'))==FALSE
  root_data_dir         = [EPIC_DATA_PATH slash]; 
end
if length(who('planet'))==FALSE
  planet                = 'Venus';
end
if length(who('experiment_dir'))==FALSE
  experiment_dir        = 'experiment06';
end

nc_file_directory     = [root_data_dir planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];


%
% PlotEpicNC attributes
%
PlotData              = 'PlotEpicNC';

Title                 = 'Pressure';
%YLabel                = '10^6 Pa';
%scale_data            = 1.0e-06;
vars_to_plot.name     = 'p3'; 
logarithmic_plot      = TRUE;
slide_freq            = 10;
%extract_it            = 'last';  % (always comment out for animations!!!)
extract_ik            = 'all'; 
AxisFontSize          = 8 * max(fig_width_mxn) / 420;
display_text_box      = FALSE;
display_time_text_box = TRUE; 
time_text_box.font_size = 20;

if length(who('longitude_slice')) == 0
  longitude_slice       = 0.0;
end

if strfind( planet, 'Venus' )
  override_axis_limits  = [-90 90 10^2 2*10^7];
  xtick                 = [-90 -45 0 45 90];
  ytick                 = [10^2 10^3 10^4 10^5 10^6 10^7];
elseif strfind( planet, 'Jupiter' )
  convert_Pa_to_mbar    = TRUE;
  %override_axis_limits  = [-38 -8 10^0 10^4];
  %xtick                 = [-38 -30.5 -23 -15.5 -8];
  ytick                 = [10^2 10^3 10^4 10^5 10^6];    % (in units of Pa, conversion to mbar occurs below)
end


if length(who('makeSlidesEpicNC_overrides'))
   eval( makeSlidesEpicNC_overrides );
   if length(strfind( plot_type, 'ZONAL-MAX' )) > 0
      plot_type = 'LONG-SLICE-RLINE';
   end
   if strcmp( plot_type, 'ZONAL-AVE-LINE' )
      plot_type = 'ZONAL-AVE-RLINE';
   end
   if strcmp( plot_type, 'LONG-SLICE-LINE' )
      plot_type = 'LONG-SLICE-RLINE';
   end
end 

if length(who('plot_type'))==0
   plot_type = 'LONG-SLICE-RLINE';
end

if length(who('convert_Pa_to_mbar'))
  if convert_Pa_to_mbar  &  length(who('ytick'))>0
    ytick = ytick ./ 10^2;
  end
end

