
%
% Side attributes
%
if length(who('root_data_dir'))==FALSE
  root_data_dir         = [EPIC_DATA_PATH slash]; 
end
if length(who('planet'))==FALSE
  planet                = 'Venus_Flat';
end
if length(who('experiment_dir'))==FALSE
  experiment_dir        = 'experiment03';
end

nc_file_directory     = [root_data_dir planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];

%
% PlotEpicNC attributes
%
PlotData              = 'PlotEpicNC';

vars_to_plot(1).name  = 'u'; 
vars_to_plot(2).name  = 'v'; 

if length(who('extract_ik'))==FALSE
  extract_ik     = 'bottom'; 
end

if ischar(extract_ik)
  Title                = ['k = ' extract_ik]; 
else
  Title                = ['k = ' num2str(extract_ik)]; 
end

XLabel                 = ' ';
YLabel                 = ' ';
AxisFontSize           = 18 * min(fig_width_mxn) / 600;

plot_type              = 'VECTOR-CART';
vector_arrow_scale     = 3.0;
value_at_poles         = 0.0;
display_time_text_box  = TRUE; 
time_text_box.font_size = 20;
time_text_box.location  = [0.02 0.975];

display_arrow_text_box       = TRUE;
arrow_legend.font_size       = 15 * AxisFontSize/18;
arrow_legend.character_width = 19 * AxisFontSize/18 / 3;  % (divide by 3 to account for # subplots)
arrow_legend.arrow_size      = 16;
arrow_legend.sig_figs        = 2;
arrow_legend.location        = [0.03 0.035];
arrow_legend.font_color      = 'r';


velocity_scaling = 25.0;  % (m/s)
if length(who('velocity_scaling_mxn'))
  velocity_scaling = velocity_scaling_mxn( min(isp, length(velocity_scaling_mxn)) );
end


%
%  Set arrow legend
%
if strcmp(planet, 'Venus')  &  strcmp(extract_ik,'bottom')
  arrow_legend.max_arrow_value = [ '(10 x ' num2str(velocity_scaling/10) ')'];
else
  arrow_legend.max_arrow_value = velocity_scaling;
end

postPlot = [ ...
           ' ch = get(gca,''Children'');' ...
           ' arrows_handle = ch(length(ch));' ...
           ' arrow_length = get( arrows_handle, ''AutoScaleFactor'') * var_max / ' num2str(velocity_scaling) ';' ...
           ' set( arrows_handle, ''AutoScaleFactor'', arrow_length );' ...
           ' al_id = displayArrowLegend( arrow_legend );  display_arrow_text_box=FALSE;' ...
           ];

