
%
% Side attributes
%
if strcmp( slide_type, 'COMPARE-EP_FLUX_DIV' )
  slide_name_prefix         = 'Compare_EP_Flux_Div';
else
  error([ ' slide_type = "' slide_type '" is not valid.  Use "COMPARE-EP_FLUX_DIV".' ])
end

%
% Check the input parameter "compare_subplot"
%
if length(who('compare_subplot'))==0
  error(' Missing parameter compare_subplot(:).<planet, experiment> .')
elseif length(compare_subplot) ~= 2
  error(' Parameter "compare_subplot" must have length 2.')
else
  for itmp=1:2
    if not(isfield(compare_subplot(itmp), 'planet'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').planet = <name>".'])
    elseif not(isfield(compare_subplot(itmp), 'experiment'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').experiment = <name>".'])
    end
  end
end

root_data_dir             = [EPIC_DATA_PATH slash]; 

if length(who('AppendSlides')) == 0
  AppendSlides            = TRUE;
end

if length(who('PresentationSlides')) == 0
  PresentationSlides      = FALSE;
end

if length(who('display_time_text_box')) == 0
  display_time_text_box   = TRUE;
end

ExtractNCSlides           = FALSE;  % extract from makeMxNfigure
DisplayMaxMin             = FALSE;
display_colorbar_fig      = FALSE;


%
% makeMxNfigure attributes
%
PlotSlidesData             = 'makeMxNfigure';

compare_dir1    = ['planet=''' compare_subplot(1).planet ''';   experiment_dir=''' compare_subplot(1).experiment ''';'];
compare_dir2    = ['planet=''' compare_subplot(2).planet ''';   experiment_dir=''' compare_subplot(2).experiment ''';'];
compare_pos1    = ' left_right_justify = 0.68;  ';
compare_pos2    = ' left_right_justify = 0.68;  ';
c1t             = 'Title = '' ''; ';
c2t             = 'Title = '' ''; ';
if isfield(compare_subplot(1), 'title')
  c1t          = ['Title =''' compare_subplot(1).title ''';  '];
end
if isfield(compare_subplot(2), 'title')
  c2t          = ['Title =''' compare_subplot(2).title ''';  '];
end
c1sync_it      = ' ';  % (necessary when ep variables do not start at the same time indices)
c2sync_it      = ' ';
if isfield(compare_subplot(1), 'sync_it')
  c1sync_it    = ['extract_it=extract_it+' num2str(compare_subplot(1).sync_it) '; '];
end
if isfield(compare_subplot(2), 'sync_it')
  c2sync_it    = ['extract_it=extract_it-' num2str(compare_subplot(2).sync_it) '; '];
end
mf1            = ' ';
mf2            = ' ';
if length(who('Extract_FromMatFile'))
  if Extract_FromMatFile
    mf1 = ['mat_file_name = ''TimeAverageEpicData_' compare_subplot(1).planet '''; '];
    mf2 = ['mat_file_name = ''TimeAverageEpicData_' compare_subplot(2).planet '''; '];
    display_time_text_box = FALSE;
  end
end
%topog_sync_it = 'extract_it=extract_it+2;';  
%flat_sync_it  = 'extract_it=extract_it-2;';

nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = [compare_dir1 'ep_flux_mxn;' mf1 compare_pos1 c1t c1sync_it];     nm=nm+1;
subplot_attributes(nm).name      = [compare_dir2 'ep_flux_mxn;' mf2 compare_pos2 c2t c2sync_it];     nm=nm+1;

eval(compare_dir1);
if length(who('postSlidePlot'))
  postSlidePlot   = [postSlidePlot compare_dir1];
else
  postSlidePlot   = compare_dir1;
end


if length(who('axis_limits')) > 0
  if not(isfield(axis_limits, 'mxn'))
    error(' Parameter "axis_limits(:)" is missing field "mxn".')
  end
  if length(axis_limits) ~= 2
    error(' Parameter "axis_limits(:).mxn" must have length 2.')
  end
  for nm=1:2
    if length(axis_limits(nm).mxn) == 4
       subplot_attributes(nm).name = [ subplot_attributes(nm).name 'override_axis_limits=[' num2str(axis_limits(nm).mxn) ']; ' ];
    end
  end
  %override_axis_limits = axis_limits;
end


MxN= [ 2 1 ];

if length(who('check_subplot_time_synch'))==0
  check_subplot_time_synch = TRUE;
end
if length(who('fig_pos_mxn'))==0
  fig_pos_mxn = [ 50, 375 ];   
  %fig_width_mxn = [700 560];        
end
if length(who('fig_width_mxn'))==0
  fig_width_mxn = [700 875];        
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('width_height_ratio'))==0
  width_height_ratio = 1.9;
end

setSlidesOverrides;

 
 
 
