
%
% Side attributes
%
if length(who('vars_to_plot'))==0
  error(' Missing parameter "vars_to_plot"');
end
if strcmp( slide_type, 'COMPARE-TIMEAVE-ZONALAVE' )
  slide_name_prefix          = [vars_to_plot.name '_ZonalAve' ];
  makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-LINE''; ';

elseif strcmp( slide_type, 'COMPARE-TIMEAVE-ZONALANOMALY' )
  slide_name_prefix          = [vars_to_plot.name '_Zonal_Anamoly' ];
  makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-ANOM-LINE''; ';

elseif strcmp( slide_type, 'COMPARE-TIMEAVE-ZONALAVE_VS_PRESSURE' )
  slide_name_prefix          = [vars_to_plot.name '_ZonalAve_Vs_P' ];
  makeSlidesEpicNC_overrides = [ ' plot_type = ''ZONAL-AVE-PCONT''; ' ...
  %makeSlidesEpicNC_overrides = [ ' plot_type = ''ZONAL-AVE-PSURF''; ' ...
                               ];
elseif strcmp( slide_type, 'COMPARE-TIMEAVE-ZONALANOMALY_VS_PRESSURE' )
  slide_name_prefix          = [vars_to_plot.name '_Zonal_Anamoly_Vs_P' ];
  makeSlidesEpicNC_overrides = [ ' plot_type = ''ZONAL-ANOM-PCONT''; ' ...
                               ];
else
  error([ ' slide_type = "' slide_type '" is not valid.  ' ...
          'Use COMPARE-TIMEAVE-ZONALAVE, COMPARE-TIMEAVE-ZONALANOMALY, ' ...
              'COMPARE-TIMEAVE-ZONALANOMALY_VS_PRESSURE, or COMPARE-TIMEAVE-ZONALAVE_VS_PRESSURE.' ])
end

%
% Check the input parameter "compare_subplot"
%
if length(who('compare_subplot'))==0
  error(' Missing parameter compare_subplot(:).<planet, experiment> .')
elseif length(compare_subplot) ~= 2
  error(' Parameter "compare_subplot" must have length 2.')
else
  for itmp=1:2
    if not(isfield(compare_subplot(itmp), 'planet'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').planet = <name>".'])
    elseif not(isfield(compare_subplot(itmp), 'experiment'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').experiment = <name>".'])
    elseif not(isfield(compare_subplot(itmp), 'mat_filename'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').mat_filename = <name>".'])
    end
  end
end

if strfind(slide_name_prefix, '_LonSlice_')
  if length(who('longitude_slice'))==0
     longitude_slice = 0;
  end
  slide_name_prefix = [ slide_name_prefix num2str(longitude_slice) ];
end

root_data_dir             = [EPIC_DATA_PATH slash]; 
mat_file_1                = [root_data_dir compare_subplot(1).planet     slash ...
                                           compare_subplot(1).experiment slash ...
                                          'MatFiles'                     slash compare_subplot(1).mat_filename];
mat_file_2                = [root_data_dir compare_subplot(2).planet     slash ...
                                           compare_subplot(2).experiment slash ...
                                          'MatFiles'                     slash compare_subplot(2).mat_filename];
nc_file_1                = [root_data_dir compare_subplot(1).planet     slash ...
                                          compare_subplot(1).experiment slash 'extract.nc' ];
nc_file_2                = [root_data_dir compare_subplot(2).planet     slash ...
                                          compare_subplot(2).experiment slash 'extract.nc' ];
slides_extract_it        = 1;
AppendSlides             = FALSE;

if length(who('PresentationSlides')) == FALSE
  PresentationSlides        = TRUE;
end

ExtractNCSlides           = FALSE;  
DisplayMaxMin             = FALSE;

if length(who('display_colorbar_fig')) == FALSE
  display_colobar_fig = FALSE;
end
if length(who('auto_close_figures')) == FALSE
  auto_close_figures = FALSE;
end


%
% makeMxNfigure attributes
%
PlotSlidesData  = 'makeMxNfigure';

compare_dir1    = ['planet=''' compare_subplot(1).planet ''';   experiment_dir=''' compare_subplot(1).experiment ''';'];
compare_dir2    = ['planet=''' compare_subplot(2).planet ''';   experiment_dir=''' compare_subplot(2).experiment ''';'];
compare_pos1    = 'left_right_justify = 0.17;  bottom_top_justify=0.3; ';
compare_pos2    = 'left_right_justify = 0.87;  bottom_top_justify=0.3; ';
vte             = ['vars_to_extract(1).name=''' vars_to_plot.name ''';'];
if strfind( slide_type, '_VS_PRESSURE' )
    zw = ' ';
    if length(who('YLabel')) == FALSE
      zw        = [zw 'YLabel=''Pressure  ( mb )''; ']; 
    end
    if length(who('YLabel')) == FALSE
      zw        = [zw 'override_axis_limits = [-90 90 1.5*10^0  4.5*10^4 ];  ' ];
    end
    vte         = [vte ' vars_to_extract(2).name=''p2''; vars_to_extract(3).name=''p3'';'];
else
  if strcmp(vars_to_plot.name, 'u')
    zw          = 'YLabel=''Zonal Wind  ( m/s )'';       override_axis_limits = [-90 90 -100 20];';
  elseif strcmp(vars_to_plot.name, 'v')
    zw          = 'YLabel=''Meridional Wind  ( m/s )'';  override_axis_limits = [-90 90 -100 20];';
  elseif strcmp(vars_to_plot.name, 't2') | strcmp(vars_to_plot.name, 't3')
    zw          = 'YLabel=''Temperature  ( K )'';  '; %override_axis_limits = [-90 90 -100 20];';
  %else
  %  zw          = 'YLabel=''  '';  override_axis_limits = [-90 90 -100 20];';
  end
end
c1t             = 'Title = '' ''; ';
c2t             = 'Title = '' ''; ';
if isfield(compare_subplot(1), 'title')
  c1t           = ['Title =''' compare_subplot(1).title ''';  '];
end
if isfield(compare_subplot(2), 'title')
  c2t           = ['Title =''' compare_subplot(2).title ''';  '];
end

load_vars_1     = [vte 'epic_vars = getEpicVarFromMatFile(vars_to_extract,''' mat_file_1 ''');' ];
load_vars_2     = [vte 'epic_vars = getEpicVarFromMatFile(vars_to_extract,''' mat_file_2 ''');' ];


extract_off_1   = ['ExtractNCMxN=0; nc_file.pntr=netcdf(''' nc_file_1 ''');'];
extract_off_2   = ['ExtractNCMxN=0; nc_file.pntr=netcdf(''' nc_file_2 ''');'];

mxn_file        = ' timeave_mxn; ';
v               = ['vars_to_plot.name = ''' vars_to_plot.name '''; '];

nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = [compare_dir1 load_vars_1 mxn_file v compare_pos1 zw c1t extract_off_1];     nm=nm+1;
subplot_attributes(nm).name      = [compare_dir2 load_vars_2 mxn_file v compare_pos2 zw c2t extract_off_2];     nm=nm+1;

eval(compare_dir1);

if length(who('postSlidePlot'))
  postSlidePlot   = [postSlidePlot compare_dir1];
else
  postSlidePlot   = compare_dir1;
end


%
% Set MxN attributes
%
if length(who('axis_limits')) > 0
  if not(isfield(axis_limits, 'mxn'))
    error(' Parameter "axis_limits(:)" is missing field "mxn".')
  end
  if length(axis_limits) ~= 2
    error(' Parameter "axis_limits(:).mxn" must have length 2.')
  end
  for nm=1:2
    if length(axis_limits(nm).mxn) == 4
       subplot_attributes(nm).name = [ subplot_attributes(nm).name 'override_axis_limits=[' num2str(axis_limits(nm).mxn) ']; ' ];
    end
  end
  %override_axis_limits = axis_limits;
end


MxN= [ 1 2 ];

check_subplot_time_synch = FALSE;
if length(who('fig_pos_mxn'))==0
  fig_pos_mxn = [ 50, 375 ];   
end
if length(who('fig_width_mxn'))==0
  fig_width_mxn = 800;
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('width_height_ratio'))==0
  width_height_ratio = 1.2;
end

setSlidesOverrides;
makeSlidesEpicNC_overrides = [makeSlidesEpicNC_overrides ' display_time_text_box = FALSE; '];

