
%
% Side attributes
%
attribute_name            = 'U_ZonalAve_TopogAndFlat';
root_data_dir             = [EPIC_DATA_PATH slash]; 
planet                    = 'Venus';
experiment_dir            = 'experiment06';

AppendSlides              = TRUE;

%PresentationSlides        = FALSE;
%slide_freq                = 84;

PresentationSlides        = TRUE;
slide_freq                = 1;

slides_extract_it         = 1 : slide_freq : 10000;   
slides_extract_ik         = 'all'; 

ExtractNCSlides           = FALSE;  % extract from makeMxNfigure
DisplayMaxMin             = FALSE;
display_colorbar_fig      = FALSE;


%
% makeMxNfigure attributes
%
makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-LINE''; ';

PlotSlidesData             = 'makeMxNfigure';
postSlidePlot              = [ 'planet=''Venus''; ' ];


topog_dir = 'planet=''Venus'';        experiment_dir=''experiment06'';';
flat_dir  = 'planet=''Venus_Flat'';   experiment_dir=''experiment01'';';
topog_pos = 'left_right_justify = 0.17;  bottom_top_justify=0.3; ';
flat_pos  = 'left_right_justify = 0.87;  bottom_top_justify=0.3; ';
zw        = 'YLabel=''Zonal Wind  ( m/s )'';  override_axis_limits = [-90 90 -100 20];';
ft        = 'Title =''Full Topography'';  ';
nt        = 'Title =''No Topography'';  ';
tb        = 'time_text_box.location = [0.01 0.08]; ';

nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = [topog_dir ' zonal_wind_mxn; '  topog_pos zw ft tb];     nm=nm+1;
subplot_attributes(nm).name      = [flat_dir  ' zonal_wind_mxn; '   flat_pos zw nt tb];     nm=nm+1;



MxN= [ 1 2 ];
if length(who('check_subplot_time_synch'))==0
  check_subplot_time_synch = TRUE;
end
if length(who('fig_pos_mxn'))==0
  fig_pos_mxn = [ 50, 375 ];   
  %fig_width_mxn = [700 560];        
end
if length(who('fig_width_mxn'))==0
  fig_width_mxn = 800;
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('width_height_ratio'))==0
  width_height_ratio = 1.2;
end

setSlidesOverrides;

%if isfield( time_text_box, 'units' )
% makeSlidesEpicNC_overrides = [ makeSlidesEpicNC_overrides 'time_text_box.units     = ''' time_text_box.units ''';' ];
%end
%if isfield( time_text_box, 'adjust_display_time' )
%   makeSlidesEpicNC_overrides = [makeSlidesEpicNC_overrides ...
%                                 'time_text_box.adjust_display_time = ' num2str(time_text_box.adjust_display_time) ';'] ; 
%end




 
