
%
% Side attributes
%
attribute_name            = 'UV_ZonalAve_TopogAndFlat';
root_data_dir             = [EPIC_DATA_PATH slash]; 
planet                    = 'Venus';
experiment_dir            = 'experiment06';
%nc_file_directory         = [root_data_dir planet slash experiment_dir];
%nc_file_name              = 'extract.nc';

AppendSlides              = FALSE;
PresentationSlides        = TRUE;

slide_freq                = 1;
slides_extract_it         = 334; %1 : slide_freq : 10000;   
slides_extract_ik         = 'all'; 

ExtractNCSlides           = FALSE;  % extract from makeMxNfigure
DisplayMaxMin             = FALSE;
display_colorbar_fig      = FALSE;


%
% makeMxNfigure attributes
%
makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-LINE''; ';

PlotSlidesData             = 'makeMxNfigure';
postSlidePlot              = 'planet=''Venus''; ';

full_topography = [ 'planet=''Venus''; experiment_dir=''experiment06''; '      ];
no_topography   = [ 'planet=''Venus_Flat''; experiment_dir=''experiment01''; ' ];
zw = 'YLabel=''Zonal Wind'';  ';
mw = 'YLabel=''Meridional Wind'';  override_axis_limits  = [-90 90 -15.0 15.0]; ';
ft = 'Title =''Full Topography'';  ';
nt = 'Title =''No Topography'';  ';

nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = [ full_topography 'zonal_wind_mxn;' zw ft ];    nm=nm+1;
subplot_attributes(nm).name      = [   no_topography 'zonal_wind_mxn;' zw nt ];    nm=nm+1;
subplot_attributes(nm).name      = [ full_topography 'merid_wind_mxn;' mw ft ];    nm=nm+1;
subplot_attributes(nm).name      = [   no_topography 'merid_wind_mxn;' mw nt ];    nm=nm+1;


MxN= [ 2 2 ];
if length(who('check_subplot_time_synch'))==0
  check_subplot_time_synch = TRUE;
end
if length(who('fig_pos_mxn'))==0
  fig_pos_mxn = [ 50, 375 ];   
  %fig_width_mxn = [700 560];        
end
if length(who('fig_width_mxn'))==0
  fig_width_mxn = 800;
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('width_height_ratio'))==0
  width_height_ratio = 1.2;
end

setSlidesOverrides;

%if isfield( time_text_box, 'units' )
% makeSlidesEpicNC_overrides = [ makeSlidesEpicNC_overrides 'time_text_box.units     = ''' time_text_box.units ''';' ];
%end
%if isfield( time_text_box, 'adjust_display_time' )
%   makeSlidesEpicNC_overrides = [makeSlidesEpicNC_overrides ...
%                                 'time_text_box.adjust_display_time = ' num2str(time_text_box.adjust_display_time) ';'] ; 
%end


 
