
%
% Side attributes
%
if strcmp( slide_type, 'COMPARE-U-ZONALAVE' )
  slide_name_prefix         = 'Compare_U_ZonalAve';
  mxn_file                  = ' zonal_wind_mxn; ';
  makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-LINE''; ';

elseif strcmp( slide_type, 'COMPARE-V-ZONALAVE' )
  slide_name_prefix         = 'Compare_V_ZonalAve';
  mxn_file                  = ' merid_wind_mxn; ';
  makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-LINE''; ';

elseif strcmp( slide_type, 'COMPARE-U-ZONALAVE_VS_PRESSURE' )
  slide_name_prefix         = 'Compare_U_ZonalAve_Vs_P';
  mxn_file                  = ' zonal_wind_mxn; ';
  makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-PCONT''; ';

elseif strcmp( slide_type, 'COMPARE-V-ZONALAVE_VS_PRESSURE' )
  slide_name_prefix         = 'Compare_V_ZonalAve_Vs_P';
  mxn_file                  = ' merid_wind_mxn; ';
  makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-PCONT''; ';

elseif strcmp( slide_type, 'COMPARE-U-LONSLICE' )
  slide_name_prefix         = 'Compare_U_LonSlice_';
  mxn_file                  = ' zonal_wind_mxn; ';
  makeSlidesEpicNC_overrides = ' plot_type = ''LONG-SLICE-LINE''; ';

elseif strcmp( slide_type, 'COMPARE-V-LONSLICE' )
  slide_name_prefix         = 'Compare_V_LonSlice_';
  mxn_file                  = ' merid_wind_mxn; ';
  makeSlidesEpicNC_overrides = ' plot_type = ''LONG-SLICE-LINE''; ';

else
  error([ ' slide_type = "' slide_type '" is not valid.  ' ...
          'Use "COMPARE-U-ZONALAVE", "COMPARE-V-ZONALAVE", "COMPARE-U-LONSLICE", "COMPARE-V-LONSLICE", ' ...
          '"COMPARE-U-ZONALAVE_VS_PRESSURE", or "COMPARE-V-ZONALAVE_VS_PRESSURE".' ])
end

%
% Check the input parameter "compare_subplot"
%
if length(who('compare_subplot'))==0
  error(' Missing parameter compare_subplot(:).<planet, experiment> .')
elseif length(compare_subplot) ~= 2
  error(' Parameter "compare_subplot" must have length 2.')
else
  for itmp=1:2
    if not(isfield(compare_subplot(itmp), 'planet'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').planet = <name>".'])
    elseif not(isfield(compare_subplot(itmp), 'experiment'))
      error([' Missing parameter "compare_subplot(' num2str(itmp) ').experiment = <name>".'])
    end
  end
end

if strfind(slide_name_prefix, '_LonSlice_')
  if length(who('longitude_slice'))==0
     longitude_slice = 0;
  end
  slide_name_prefix = [ slide_name_prefix num2str(longitude_slice) ];
end

root_data_dir             = [EPIC_DATA_PATH slash]; 

if length(who('AppendSlides')) == 0
  AppendSlides              = TRUE;
end

if length(who('PresentationSlides')) == 0
  PresentationSlides        = TRUE;
end

if length(who('display_time_text_box')) == 0
  display_time_text_box   = TRUE;
end

ExtractNCSlides           = FALSE;  % extract from makeMxNfigure
DisplayMaxMin             = FALSE;
display_colorbar_fig      = FALSE;


%
% makeMxNfigure attributes
%
PlotSlidesData  = 'makeMxNfigure';

compare_dir1    = ['planet=''' compare_subplot(1).planet ''';   experiment_dir=''' compare_subplot(1).experiment ''';'];
compare_dir2    = ['planet=''' compare_subplot(2).planet ''';   experiment_dir=''' compare_subplot(2).experiment ''';'];
compare_pos1    = 'left_right_justify = 0.17;  bottom_top_justify=0.3; ';
compare_pos2    = 'left_right_justify = 0.87;  bottom_top_justify=0.3; ';
if strfind(slide_name_prefix, 'Compare_U')
  zw            = 'YLabel=''Zonal Wind  ( m/s )'';       override_axis_limits = [-90 90 -100 20];';
else
  zw            = 'YLabel=''Meridional Wind  ( m/s )'';  override_axis_limits = [-90 90 -100 20];';
end
tb              = 'time_text_box.location = [0.01 0.08]; ';
c1t             = 'Title = '' ''; ';
c2t             = 'Title = '' ''; ';
if isfield(compare_subplot(1), 'title')
  c1t          = ['Title =''' compare_subplot(1).title ''';  '];
end
if isfield(compare_subplot(2), 'title')
  c2t          = ['Title =''' compare_subplot(2).title ''';  '];
end

nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = [compare_dir1 mxn_file  compare_pos1 zw c1t tb];     nm=nm+1;
subplot_attributes(nm).name      = [compare_dir2 mxn_file  compare_pos2 zw c2t tb];     nm=nm+1;

eval(compare_dir1);
if length(who('postSlidePlot'))
  postSlidePlot   = [compare_dir1 postSlidePlot];
else
  postSlidePlot   = compare_dir1;
end


if length(who('axis_limits')) > 0
  if not(isfield(axis_limits, 'mxn'))
    error(' Parameter "axis_limits(:)" is missing field "mxn".')
  end
  if length(axis_limits) ~= 2
    error(' Parameter "axis_limits(:).mxn" must have length 2.')
  end
  for nm=1:2
    if length(axis_limits(nm).mxn) == 4
       subplot_attributes(nm).name = [ subplot_attributes(nm).name 'override_axis_limits=[' num2str(axis_limits(nm).mxn) ']; ' ];
    end
  end
  %override_axis_limits = axis_limits;
end


MxN= [ 1 2 ];

if length(who('check_subplot_time_synch'))==0
  check_subplot_time_synch = TRUE;
end
if length(who('fig_pos_mxn'))==0
  fig_pos_mxn = [ 50, 375 ];   
  %fig_width_mxn = [700 560];        
end
if length(who('fig_width_mxn'))==0
  fig_width_mxn = 800;
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('width_height_ratio'))==0
  width_height_ratio = 1.2;
end

setSlidesOverrides;

if length(who('slides_extract_ik'))
  makeSlidesEpicNC_overrides = [ makeSlidesEpicNC_overrides 'extract_ik = [' num2str(slides_extract_ik) ']; ' ];
end  
if strfind( slide_type, '_VS_PRESSURE' )
  makeSlidesEpicNC_overrides = [ makeSlidesEpicNC_overrides 'vars_to_plot(2).name=''p2'';  vars_to_plot(3).name=''p3''; ' ];
end

%if isfield( time_text_box, 'units' )
% makeSlidesEpicNC_overrides = [ makeSlidesEpicNC_overrides 'time_text_box.units     = ''' time_text_box.units ''';' ];
%end
%if isfield( time_text_box, 'adjust_display_time' )
%   makeSlidesEpicNC_overrides = [makeSlidesEpicNC_overrides ...
%                                 'time_text_box.adjust_display_time = ' num2str(time_text_box.adjust_display_time) ';'] ; 
%end
 
