  

%
% Side attributes
%
if strcmp(slide_type, 'EP_FLUX_DIV')
  slide_name_prefix = 'EP_Flux_Div';
else
  error([ ' slide_type = "' slide_type '" is not valid.  Use "EP_FLUX_DIV".' ])
end

nc_file_directory     = [EPIC_DATA_PATH slash planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];

if length(who('AppendSlides')) == 0
  AppendSlides          = TRUE;
end
if length(who('PresentationSlides')) == 0
  PresentationSlides    = FALSE;
end



%
% PlotData attributes
%
plot_type = 'SCALAR-CONTOUR';
if length(who('contour_plot_type'))==0 
  contour_plot_type = 1;
end
if length(who('num_contour_lines'))==0 
  num_contour_lines = 10;
end

iv=1;
vars_to_plot(iv).name = 'u';         iv=iv+1;
vars_to_plot(iv).name = 'v';         iv=iv+1;
vars_to_plot(iv).name = 'hdry';      iv=iv+1;
vars_to_plot(iv).name = 'theta';     iv=iv+1;
vars_to_plot(iv).name = 'theta2';    iv=iv+1;
vars_to_plot(iv).name = 'mont2';     iv=iv+1;
vars_to_plot(iv).name = 'hdry3';     iv=iv+1;
vars_to_plot(iv).name = 'p3';        iv=iv+1;
vars_to_plot(iv).name = 'heat3';     iv=iv+1;
vars_to_plot(iv).name = 'exner3';    iv=iv+1;


ExtractNCSlides = FALSE;
if isfield( nc_file_name, 'name' )
   fprintf(['\tExtracting NC Files ' nc_file_directory slash ' ' nc_file_name(1).name])
   for inc=1:length( nc_file_name )
      filepath(inc).name = [nc_file_directory slash nc_file_name(inc).name];
      if inc>1
         fprintf([', ' nc_file_name(inc).name]);
      end
      fprintf('\n');
   end
else
   filepath = [nc_file_directory slash nc_file_name];
   fprintf(['\tExtracting NC File ' filepath ' ....\n'])
end


%
% PlotEpicNC attributes
%
PlotSlidesData        = 'EPflux_ExtractProcessPlot';

postSlidePlot         = [ 'box on;  view(0.0, 90.1); '               ...               % (necessary to see plot box)
                          'set(gca,''ZColor'',''w'');  '             ...
                        ];

if length(who('fig_width')) == 0
  fig_width               = 420; 
end
if length(who('use_auto_color_map')) == 0
  use_auto_color_map      = TRUE;
end
if length(who('axis_limits')) > 0
  override_axis_limits = axis_limits;
end

make_x_data_periodic = FALSE;
clear value_at_poles
AxisFontSize = 21.3333 * fig_width / 560;
XLabel = 'Latitude ';
YLabel = 'Potential Temperature [K] ';

if length(who('logarithmic_plot')) == 0
  logarithmic_plot      = TRUE;
end
if length(who('min_logarithmic_limit')) == 0
  min_logarithmic_limit = 1.0e-20;
end


%
% Legend Attributes
%
display_time_text_box = TRUE; 
time_text_box.font_size = 20 * AxisFontSize / 21.3;
  
 
%
% Colorbar attributes
%
if length(who('display_colorbar_fig')) == 0
  display_colorbar_fig  = TRUE;
end
if length(who('cb_width')) == 0
  cb_width                = 0.70;
end
if length(who('cb_text_box_location')) == 0
  cb_text_box_location    = [ 0.02  0.5 ]; 
end
if length(who('cb_text_color')) == 0
  cb_text_color           = 'k';
end
if length(who('cb_background_color')) == 0
  cb_background_color     = 'w';
end
 

