
%
% Side attributes
%
if length(who('vars_to_plot')) == 0
  error(' missing variable "vars_to_plot".')
end

if not( isfield('vars_to_plot', 'name') )
  vtp = vars_to_plot;
  clear vars_to_plot;
  vars_to_plot.name = vtp;
  clear vtp
end

if strcmp(slide_type, 'SCALAR')
  slide_name_prefix = vars_to_plot(1).name;

elseif strcmp(slide_type, 'SCALAR-SPHERE')
  slide_name_prefix = [vars_to_plot(1).name '_Sphere'];

elseif strcmp(slide_type, 'SCALAR-VERTICAL-AVE')
  slide_name_prefix = [vars_to_plot(1).name '_Vertical_Ave'];

elseif strfind(slide_type, 'SCALAR-LONG-SLICE')
  slide_name_prefix = [vars_to_plot(1).name '_LongSlice'];

else
  error([ ' slide_type = "' slide_type '" is not valid.  Use "SCALAR" or "SCALAR-SPHERE".' ])
end

nc_file_directory     = [EPIC_DATA_PATH slash planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];

if length(who('AppendSlides')) == 0
  AppendSlides          = TRUE;
end
if length(who('PresentationSlides')) == 0
  if strfind( slide_name_prefix, 'Sphere' )
    PresentationSlides    = TRUE;
  else
    PresentationSlides    = FALSE;
  end
end
if length(who('Figures_subdir')) == 0  &  not(PresentationSlides)
  Figures_subdir        = 'Figures_Presentations';
end

if ischar(slides_extract_ik)
   slide_name_prefix = [slide_name_prefix '_k' slides_extract_ik];
else
   if not(strfind(slide_type, 'VERTICAL-AVE'))
     slide_name_prefix = [slide_name_prefix '_k' num2str(slides_extract_ik)];
   else
     if length(slides_extract_ik) == 1
       slide_name_prefix = [slide_name_prefix '_k' num2str(slides_extract_ik)];
     else
       slide_name_prefix = [slide_name_prefix '_k' num2str(min(slides_extract_ik)) 'to' num2str(max(slides_extract_ik))];
     end
   end
end





%
% PlotEpicNC attributes
%
PlotSlidesData        = 'PlotEpicNC';
if strcmp( slide_type, 'SCALAR' )
  if length(who('contour_plot_type')) == 0
    plot_type            = 'SCALAR-CART';
  else
    plot_type            = 'SCALAR-CONTOUR';
    display_colorbar_fig = FALSE;
  end

elseif strcmp( slide_type, 'SCALAR-SPHERE' )
  plot_type              = 'SCALAR-SPHERE';

elseif strcmp(slide_type, 'SCALAR-VERTICAL-AVE')
  if length(who('contour_plot_type')) == 0
    plot_type             = 'VERTICAL-AVE-SURF';
  else
    plot_type             = 'VERTICAL-AVE-CONT';
    display_colorbar_fig  = FALSE;
  end

elseif strfind( slide_type, 'LONG-SLICE' )
  plot_type              = slide_type(6:length(slide_type));
  if length(who('longitude_slice'))==0
    longitude_slice = 0.0;
  end

else
  plot_type               = 'SCALAR-CART';
end


if strcmp( vars_to_plot(1).name, 'v' )
  value_at_poles        = 0.0;
end

if length(who('axis_limits')) > 0
  override_axis_limits = axis_limits;
end

if length(who('fig_width'))==0
  fig_width              = 420; 
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('use_auto_color_map'))==0
  use_auto_color_map = TRUE;
end
if length(who('shading_type'))==0
  shading_type       = 'flat'; 
end


%
% Legend Attributes
%
if length(who('display_time_text_box')) == 0
  display_time_text_box  = TRUE; 
end
time_text_box.font_size = 20 * fig_width / 560;
time_text_box.location  = [0.83 0.033];

display_text_box       = FALSE;
display_arrow_text_box = FALSE;

if length(who('postSlidePlot')) == 0 
  postSlidePlot = ' ';
end



%
% Colorbar attributes
%
if length(who('display_colorbar_fig'))==0
  display_colorbar_fig  = TRUE;
end
cb_width              = 0.75;
cb_text_box_location  = [ 0.02  0.5 ]; 
cb_text_color         = 'k';
cb_background_color   = 'w';
 





