
%
% Side attributes
%
if strcmp(slide_type, 'TOPOGRAPHY')
  slide_name_prefix = 'Topography';
elseif strcmp(slide_type, 'TOPOGRAPHY-SPHERE')
  slide_name_prefix = 'Topography_Sphere';
else
  error([ ' slide_type = "' slide_type '" is not valid.  Use "TOPOGRAPHY", or "TOPOGRAPHY-SPHERE"' ])
end

nc_file_directory     = [EPIC_DATA_PATH slash planet slash experiment_dir];
%nc_file_name          = 'epic.nc';
%vars_to_plot(1).name  = 'gz_surface'; 

nc_file_name          = 'extract.nc';
vars_to_plot(1).name  = 'p3'; 

slides_extract_it     = 'first';
slides_extract_ik     = 'bottom'; 


if ischar(slides_extract_ik)
   slide_name_prefix = [slide_name_prefix '_k' slides_extract_ik];
else
   slide_name_prefix = [slide_name_prefix '_k' num2str(slides_extract_ik)];
end

AppendSlides          = FALSE;


%
% PlotEpicNC attributes
%
PlotSlidesData        = 'PlotEpicNC';

plot_type             = 'TOPOGRAPHY-CART';
num_rotations         = 0.0;
%background_color      = 'k';

if length(who('fig_width'))==0
  fig_width             = 560; 
end
if length(who('scale_data')) == FALSE  &  strcmp(vars_to_plot(1).name, 'p3')
  scale_data          = -1.0e-06;
end
if length(who('shading_type')) == FALSE
  shading_type          = 'interp';
end

display_text_box      = FALSE;
display_time_text_box = FALSE; 

%
% turn off the default image writer, and invoke makeSpinAxesSlides().
%
postSlidePlot = [ ...
                ' write_figures_to_image_files = FALSE; ' ...  
                ' makeSpinAxesSlides( bmp_file_directory );' ...
                 ];
                %' write_figures_to_image_files = TRUE; ' ...
                %' makeSpinAxesSlides( ''' write_data_dir planet slash 'Figures' slash slide_name_prefix ''');' ...


if strfind( slide_name_prefix, 'Topography_Sphere' )
   %spherical_coord_plot = TRUE;
   plot_type             = 'TOPOGRAPHY-SPHERE';
end
