

%
% Side attributes
%
if strcmp(slide_type, 'WIND')
  slide_name_prefix = 'Wind';
elseif strcmp(slide_type, 'WIND-SPHERE')
  slide_name_prefix = 'Wind_Sphere';
else
  error([ ' slide_type = "' slide_type '" is not valid.  Use "WIND" or "WIND-SPHERE".' ])
end

nc_file_directory     = [EPIC_DATA_PATH slash planet slash experiment_dir];
tmp_file_name         = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name          = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];

if length(who('AppendSlides')) == 0
  AppendSlides          = TRUE;
end
if length(who('PresentationSlides')) == 0
  if strfind( slide_name_prefix, 'Sphere' )
    PresentationSlides    = TRUE;
  else
    PresentationSlides    = FALSE;
  end
end
if length(who('Figures_subdir')) == 0  &  not(PresentationSlides)
  Figures_subdir        = 'Figures_Presentations';
end

if ischar(slides_extract_ik)
   slide_name_prefix = [slide_name_prefix '_k' slides_extract_ik];
else
   slide_name_prefix = [slide_name_prefix '_k' num2str(slides_extract_ik)];
end


%
% PlotEpicNC attributes
%
PlotSlidesData        = 'PlotEpicNC';

vars_to_plot(1).name  = 'u'; 
vars_to_plot(2).name  = 'v'; 

plot_type              = 'VECTOR-CART';
if length(who('vector_arrow_scale'))==0
  vector_arrow_scale     = 3.0;
end
value_at_poles         = 0.0;

if length(who('velocity_scaling'))==0
  warning(' velocity_scaling was not specified.  Using default value of 100.0 m/s' );
  velocity_scaling = 100.0;
end

if length(who('axis_limits')) > 0
  override_axis_limits = axis_limits;
end

if length(who('fig_width'))==0
  fig_width              = 560; 
end


%
% Legend Attributes
%
if length(who('display_time_text_box')) == 0
  display_time_text_box  = TRUE; 
end
time_text_box.font_size = 20 * fig_width / 560;
time_text_box.location  = [0.83 0.033];

if length(who('display_arrow_text_box')) == 0
  display_arrow_text_box = TRUE;
end
if not( isfield( arrow_legend, 'character_width' ))
  arrow_legend.character_width = 17;
end
if not( isfield( arrow_legend, 'location' ))
  arrow_legend.location        = [0.03 0.035];
end
if not( isfield( arrow_legend, 'sig_figs' ))
  arrow_legend.sig_figs        = 2;
end
if not( isfield( arrow_legend, 'font_size' ))
  arrow_legend.font_size       = 20 * fig_width / 560;
end
if not( isfield( arrow_legend, 'font_weight' ))
  arrow_legend.font_weight     = 'bold';
end
if not( isfield( arrow_legend, 'font_color' ))
  arrow_legend.font_color      = 'r';
end
if not( isfield( arrow_legend, 'edge' ))
  arrow_legend.edge            = 'none';
end
if not( isfield( arrow_legend, 'arrow_size' ))
  arrow_legend.arrow_size      = 30 * fig_width / 560;
end

if not( isfield( arrow_legend, 'max_arrow_value' ))
  arrow_legend.max_arrow_value = velocity_scaling;
end

if length(who('postSlidePlot')) == 0 
  postSlidePlot = ' ';
end

postSlidePlot = [ postSlidePlot ...
           ' ch = get(gca,''Children'');' ...
           ' arrows_handle = ch(length(ch));' ...
           ' arrow_length = get( arrows_handle, ''AutoScaleFactor'') * var_max / ' num2str(velocity_scaling) ';' ...
           ' set( arrows_handle, ''AutoScaleFactor'', arrow_length );' ...
           ];

if strfind( slide_name_prefix, 'Wind_Sphere' )
   arrow_type           = 2;
   plot_type            = 'VECTOR-SPHERE';
   num_rotations        = 0.0;
   postSlidePlot = [ ...
                     ' view(0,20);'              ...
                     postSlidePlot               ...
                   ];
end

if length(who('thin_vector_plot_iters'))
  postSlidePlot = [ ...
                    postSlidePlot ...
                    'thin_vector_plot_iters = [' num2str(thin_vector_plot_iters) '];' ...
                  ]; 
end 


