
%
% Side attributes
%
if strcmp(slide_type, 'WIND-MULTI-LAYER')
  slide_name_prefix = 'Wind';
else
  error([ ' slide_type = "' slide_type '" is not valid.  Use "WIND-MULTI-LAYER".' ])
end

root_data_dir             = [EPIC_DATA_PATH slash]; 

% Specify k layers for subplots and modify attribute name
if length(who('subplot_ik')) == 0
  error(' Must specify  subplot_ik = [ <l1> <l2> <l3> ];')
elseif length(subplot_ik) ~= 3
  error(' WIND-MULTILAYER requires exactly 3 subpots.')
end
for ik=1:length(subplot_ik)
  slide_name_prefix = [slide_name_prefix '_k' num2str(subplot_ik(ik))];
end

if length(who('AppendSlides')) == 0
  AppendSlides              = TRUE;
end
if length(who('PresentationSlides')) == 0
  PresentationSlides        = FALSE;
end
if length(who('Figures_subdir')) == 0
  Figures_subdir            = 'Figures_Presentations';
end

ExtractNCSlides           = FALSE;  % extract from makeMxNfigure
DisplayMaxMin             = FALSE;
display_colorbar_fig      = FALSE;



%
% makeMxNfigure attributes
%

PlotSlidesData             = 'makeMxNfigure';

extract_top = ['extract_ik=' num2str(subplot_ik(1))  '; '];
extract_mid = ['extract_ik=' num2str(subplot_ik(2))  '; '];
extract_bot = ['extract_ik=' num2str(subplot_ik(3))  '; '];
nudge_top   = 'bottom_top_justify = 1.25;  ';
nudge_mid   = 'bottom_top_justify = 0.65;  ';
nudge_bot   = 'bottom_top_justify = 0.06;  ';
arrow_top   = 'arrow_legend.location = [0.03 0.69]; ';
arrow_mid   = 'arrow_legend.location = [0.03 0.36]; ';
arrow_bot   = 'arrow_legend.location = [0.03 0.033]; ';


nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = [extract_top  'total_wind_mxn; ' nudge_top arrow_top ];     nm=nm+1;
subplot_attributes(nm).name      = [extract_mid  'total_wind_mxn; ' nudge_mid arrow_mid ];     nm=nm+1;
subplot_attributes(nm).name      = [extract_bot  'total_wind_mxn; ' nudge_bot arrow_bot ];     nm=nm+1;


MxN= [ 3 1 ];
check_subplot_time_synch = TRUE;

if length(who('fig_pos_mxn')) == 0
  fig_pos_mxn = [ 50, 375 ];   
end
if length(who('fig_width_mxn')) == 0
  fig_width_mxn = 600;
end
if length(who('background_color')) == 0
  background_color = 'w';
end
if length(who('width_height_ratio')) == 0
  width_height_ratio = 1.73;
end


 
