
%
% Side attributes
%
if strcmp(slide_type, 'UVTP-LONSLICE')
  slide_name_prefix = 'UVTP_LonSlice_';
elseif strcmp(slide_type, 'UVTP-ZONALAVE')
  slide_name_prefix = 'UVTP_ZonalAve';
elseif strcmp(slide_type, 'UVTP-ZONALMAX')
  slide_name_prefix = 'UVTP_ZonalMax';
else
  error([ ' slide_type = "' slide_type '" is not valid.  ' ...
          'Use "UVTP-LONSLICE", "UVTP-ZONALAVE", or "UVTP-ZONALMAX".' ])
end

root_data_dir             = [EPIC_DATA_PATH slash]; 

if length(who('slides_extract_ik'))==0
  slides_extract_ik = 'all';
end

if length(who('AppendSlides')) == 0
  AppendSlides              = TRUE;
end
if length(who('PresentationSlides')) == 0
  PresentationSlides        = FALSE;
end

ExtractNCSlides           = FALSE;  % extract from makeMxNfigure
DisplayMaxMin             = FALSE;
display_colorbar_fig      = FALSE;



%
% makeMxNfigure attributes
%
if length(who('longitude_slice'))==0
  longitude_slice = 0;
end

makeSlidesEpicNC_overrides = ' ';
if strfind(slide_name_prefix, 'UVTP_LonSlice_')
   slide_name_prefix = [slide_name_prefix num2str(longitude_slice)];
   makeSlidesEpicNC_overrides = ' plot_type = ''LONG-SLICE-LINE''; ';

elseif strcmp(slide_name_prefix, 'UVTP_ZonalAve')
   makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-AVE-LINE''; ';

elseif strcmp(slide_name_prefix, 'UVTP_ZonalMax')
   makeSlidesEpicNC_overrides = ' plot_type = ''ZONAL-MAX-LINE''; ';

end

PlotSlidesData             = 'makeMxNfigure';

nm=1;  clear subplot_attributes
subplot_attributes(nm).name      = 'zonal_wind_mxn; ';     nm=nm+1;
subplot_attributes(nm).name      = 'merid_wind_mxn; ';     nm=nm+1;
%subplot_attributes(nm).name      = 'temp_mxn; ';     nm=nm+1;
subplot_attributes(nm).name      = 'theta_mxn; ';          nm=nm+1;
subplot_attributes(nm).name      = 'p3_mxn; ';             nm=nm+1;
%subplot_attributes(nm).name      = 'w3_mxn; ';             nm=nm+1;


if length(who('axis_limits')) > 0
  if not(isfield(axis_limits, 'mxn'))
    error(' Parameter "axis_limits(:)" is missing field "mxn".')
  end
  if length(axis_limits) ~= 4
    error(' Parameter "axis_limits(:).mxn" must have length 4.')
  end
  for nm=1:4
    if length(axis_limits(nm).mxn) == 4
       subplot_attributes(nm).name = [ subplot_attributes(nm).name 'override_axis_limits=[' num2str(axis_limits(nm).mxn) ']; ' ];
    end
  end
end


MxN= [ 2 2 ];
check_subplot_time_synch = TRUE;

if length(who('fig_pos_mxn'))==0
  fig_pos_mxn = [ 50, 375 ];   
  %fig_width_mxn = [700 560];        
end
if length(who('fig_width_mxn'))==0
  fig_width_mxn = 800;
end
if length(who('background_color'))==0
  background_color = 'w';
end
if length(who('width_height_ratio'))==0
  width_height_ratio = 1.2;
end
if length(who('time_text_box'))
  if not(isfield('time_text_box','font_size')) 
    time_text_box.font_size = 20 * min(fig_width_mxn) / 800;
  end
end

setSlidesOverrides;

 
