
%
% Side attributes
%
if strcmp(slide_type, 'VORTICITY')
  slide_name_prefix = 'Vorticity';

elseif strcmp(slide_type, 'PVORTICITY')
  slide_name_prefix = 'Pontential_Vorticity';

elseif strcmp(slide_type, 'VORTICITY-SPHERE')
  slide_name_prefix = 'Vorticity_Sphere';

elseif strcmp(slide_type, 'PVORTICITY-SPHERE')
  slide_name_prefix = 'Pontential_Vorticity_Sphere';

elseif strcmp(slide_type, 'VORTICITY-VERTICAL-AVE')
  slide_name_prefix = 'Vorticity_Vertical_Ave';

elseif strcmp(slide_type, 'PVORTICITY-VERTICAL-AVE')
  slide_name_prefix = 'Pontential_Vorticity_Vertical_Ave';

else
  error([ ' slide_type = "' slide_type '" is not valid.  ' ...
          'Use "VORTICITY", "PVORTICITY", "VORTICITY-SPHERE", or "PVORTICITY-SPHERE"' ])
end

nc_file_directory   = [EPIC_DATA_PATH slash planet slash experiment_dir];
tmp_file_name       = getFileNames( 'extract', '.nc', nc_file_directory);
nc_file_name        = [ tmp_file_name(2:length(tmp_file_name))  tmp_file_name(1) ];


if length(who('AppendSlides')) == 0
  AppendSlides          = TRUE;
end
if length(who('PresentationSlides')) == 0
  if strfind( slide_name_prefix, 'Sphere' )
    PresentationSlides    = TRUE;
  else
    PresentationSlides    = FALSE;
  end
end
if length(who('Figures_subdir')) == 0  &  not(PresentationSlides)
  Figures_subdir        = 'Figures_Presentations';
end


if ischar(slides_extract_ik)
   slide_name_prefix = [slide_name_prefix '_k' slides_extract_ik];
else
   if not(strfind(slide_type, 'VERTICAL-AVE'))
     slide_name_prefix = [slide_name_prefix '_k' num2str(slides_extract_ik)];
   else
     if length(slides_extract_ik) == 1
       slide_name_prefix = [slide_name_prefix '_k' num2str(slides_extract_ik)];
     else
       slide_name_prefix = [slide_name_prefix '_k' num2str(min(slides_extract_ik)) 'to' num2str(max(slides_extract_ik))];
     end
   end
end


%
% PlotEpicNC attributes
%
PlotSlidesData          = 'PlotEpicNC';

if strfind(slide_type, 'PVORTICITY')
  vars_to_plot(1).name    = 'pv2'; 
else
  vars_to_plot(1).name    = 'vort2'; 
end

%if strfind(slide_type, 'VERTICAL-AVE')
%  if length(who('contour_plot_type')) == 0
%    plot_type             = 'VERTICAL-AVE-SURF';
%  else
%    plot_type             = 'VERTICAL-AVE-CONT';
%  end
%else
%  plot_type               = 'SCALAR-CART';
%end


if strfind( slide_type, '-SPHERE' )
  plot_type              = 'SCALAR-SPHERE';

elseif strfind(slide_type, 'VERTICAL-AVE')
  if length(who('contour_plot_type')) == 0
    plot_type             = 'VERTICAL-AVE-SURF';
  else
    plot_type             = 'VERTICAL-AVE-CONT';
    display_colorbar_fig  = FALSE;
  end

else
  if length(who('contour_plot_type')) == 0
    plot_type            = 'SCALAR-CART';
  else
    plot_type            = 'SCALAR-CONTOUR';
    display_colorbar_fig = FALSE;
  end
end


if length(who('shading_type')) == 0
  shading_type            = 'interp';
end
if length(who('fig_width')) == 0
  fig_width               = 560; 
end
if length(who('use_auto_color_map')) == 0
  use_auto_color_map      = TRUE;
end
if length(who('axis_limits')) > 0
  override_axis_limits = axis_limits;
end


%
% Legend Attributes
%
if length(who('display_time_text_box')) == 0
  display_time_text_box  = TRUE; 
end
time_text_box.font_size = 20;
time_text_box.location  = [0.01 0.033];
%time_text_box.location  = [0.83 0.033];
%override_axis_limits = [ -40 40 18 48 ];

if length(who('display_colorbar_fig'))==0
  display_colorbar_fig  = FALSE;
end

if length(who('cb_width')) == 0
  cb_width                = 0.75;
end
if length(who('cb_text_box_location')) == 0
  cb_text_box_location    = [ 0.02  0.5 ]; 
end
if length(who('cb_text_color')) == 0
  cb_text_color           = 'k';
end
if length(who('cb_background_color')) == 0
  cb_background_color     = 'w';
end
 


if strfind( slide_name_prefix, 'Sphere' )
%   plot_type            = 'SCALAR-SPHERE';
   num_rotations        = 0.0;
   postSlidePlot = [ ' view(0,20);'              ...
                   ];
end

