
%
% Side attributes
%
attribute_name        = 'ZonalWind';
root_data_dir         = [EPIC_DATA_PATH slash]; 
planet                = 'Venus';
experiment_dir        = 'experiment03';
nc_file_directory     = [root_data_dir planet slash experiment_dir];
nc_file_name          = 'extract.nc';

vars_to_plot.name     = 'u'; 

slide_freq            = 20;
slides_extract_it     = 1 : slide_freq : 10000;   
slides_extract_ik     = 'top'; 

if ischar(slides_extract_ik)
   attribute_name = [attribute_name '_k' slides_extract_ik];
else
   attribute_name = [attribute_name '_k' num2str(slides_extract_ik)];
end



%
% PlotEpicNC attributes
%
PlotSlidesData        = 'PlotEpicNC';

value_at_poles        = 0.0;
fig_width             = 560; 
use_auto_color_map    = TRUE;
zmin = -55.0;  zmax   = 55.0;
display_text_box      = FALSE;
display_time_text_box = TRUE; 


%
% Colorbar attributes
%
display_colorbar_fig  = TRUE;
cb_width              = 0.75;
cb_text_box_location  = [ 0.02  0.5 ]; 
cb_text_color         = 'k';
cb_background_color   = 'w';
 

