%
%                                     makeMxNEpicNC
%
% Script generates figures with subplots.  A sepparate attribute file must exist for each 
%  subplot, and must contain the graphing parameters used by the plotting function, PlotData 
%  (e.g., PlotData='PlotEpicNC';).  Attribute files can be created using the those in 
%  EPIC_PATH/tools/matlab/example_attribute_files/ as templates.  
%
% The MxN input parameters can be set prior to calling this script (e.g., batch generation
%  of animation slides) by setting load_mxn_input_externally=TRUE;
%
% Input: 
%           subplot_attributes(:).name     (names of attribute files; array length must equal # of subplots)
%           planet                         
%           extract_it                     (time indice to extract from nc file)
%           check_subplot_time_synch       (default is TRUE)
%           fig_pos_mxn                    (coordinates of lower left corner of figure)
%           background_color               (default is 'w')
%
%           MxN                            (array specifying the # rows and # columns in figure)
%           fig_width_mxn                  (figure width and height)    
%           width_height_ratio             (ratio of width/height for subplots)
%


%%
%%----------------------- Definitions -----------------------
%%
tic
EpicNC_initialize
checkEPICncPATHs();

load_files_externally        = TRUE;  % (tell PlotEpicNC to by pass file loading and output settings)
load_comparisons_externally  = TRUE;  
extract_ncfile_externally    = TRUE;

SetMxNinput = TRUE;
if length(who('load_nxm_input_externally')) > 0
  SetMxNinput = not(load_nxm_input_externally);
end

ExtractNCMxN  = TRUE;
if length(who('extract_mxn_ncfile_externally')) > 0
  ExtractNCMxN = not(extract_mxn_ncfile_externally);
end

write_data_dir = [EPIC_DATA_PATH slash ];

if isdir(write_data_dir)==FALSE
   mkdir(write_data_dir);
end

addpath( [EPIC_MATLAB_SRC_PATH slash 'EPICncVis' slash 'attributes_mxn'] );
%%
%%----------------------------------------------------------- 
%%


if SetMxNinput
%%
%%----------------- Input Attribute Files ------------------- 
%%
  nm=1;  clear subplot_attributes

  %----------------------------- U,V,T,P ----------------------------------
  subplot_attributes(nm).name      = 'zonal_wind_mxn';     nm=nm+1;
  %subplot_attributes(nm).name      = 'merid_wind_mxn';     nm=nm+1;
  subplot_attributes(nm).name      = 'temp_mxn';     nm=nm+1;
  subplot_attributes(nm).name      = 'theta_mxn';          nm=nm+1;
  subplot_attributes(nm).name      = 'p3_mxn';             nm=nm+1;


  %----------------------------- U,U,V,V ----------------------------------
  %full_topography = [ 'Title=''Full Topography''; '                                             ...
  %                    'planet=''Venus''; experiment_dir=''experiment06''; '                     ...
  %                    'nc_file_directory = [root_data_dir planet slash experiment_dir];'        ...
  %                  ];
  %no_topography   = [ 'Title=''No Topography''; '                                               ...
  %                    'planet=''Venus_Flat''; experiment_dir=''experiment01''; '                ...
  %                    'nc_file_directory = [root_data_dir planet slash experiment_dir];'        ...
  %                  ];
  %subplot_attributes(nm).name      = [ 'zonal_wind_mxn; YLabel=''Zonal Wind''; '      full_topography ];    nm=nm+1;
  %subplot_attributes(nm).name      = [ 'zonal_wind_mxn; YLabel=''Zonal Wind''; '        no_topography ];    nm=nm+1;
  %subplot_attributes(nm).name      = [ 'merid_wind_mxn; YLabel=''Meridional Wind''; ' full_topography ];    nm=nm+1;
  %subplot_attributes(nm).name      = [ 'merid_wind_mxn; YLabel=''Meridional Wind''; '   no_topography ];    nm=nm+1;


  %------------------------- EP Flux, EP Flux ------------------------------
  %topog_dir     = 'planet=''Venus'';        experiment_dir=''experiment06'';';
  %flat_dir      = 'planet=''Venus_Flat'';   experiment_dir=''experiment01'';';
  %topog_specs   = 'Title=''Topography'';      left_right_justify = 0.68;';
  %flat_specs    = 'Title=''No Topography '';  left_right_justify = 0.68;  bottom_top_justify = 0.13;';
  %topog_sync_it = 'extract_it=extract_it+2;';  % (necessary since ep variables do not start at the same time indices)
  %flat_sync_it  = 'extract_it=extract_it-2;';
  % 
  %subplot_attributes(nm).name      = [topog_dir 'ep_flux_mxn;' topog_specs topog_sync_it];     nm=nm+1;
  %subplot_attributes(nm).name      = [flat_dir  'ep_flux_mxn;' flat_specs  flat_sync_it ];     nm=nm+1;


  %------------------------------- U, U ------------------------------------
  %topog_dir = 'planet=''Venus'';        experiment_dir=''experiment06'';';
  %flat_dir  = 'planet=''Venus_Flat'';   experiment_dir=''experiment01'';';
  %topog_pos = 'Title=''Topography'';      left_right_justify = 0.17;  bottom_top_justify=0.3; ';
  %flat_pos  = 'Title=''No Topography '';  left_right_justify = 0.87;  bottom_top_justify=0.3; ';
  %  
  %subplot_attributes(nm).name      = [topog_dir ' zonal_wind_mxn; '  topog_pos];     nm=nm+1;
  %subplot_attributes(nm).name      = [flat_dir  ' zonal_wind_mxn; '   flat_pos];     nm=nm+1;


  %-------------------------- Wind, Wind, Wind -------------------------------
  %extract_top = 'extract_ik=15;  ';    nudge_top   = 'bottom_top_justify = 1.25;  ';
  %extract_mid = 'extract_ik=18;  ';    nudge_mid   = 'bottom_top_justify = 0.65;  ';
  %extract_bot = 'extract_ik=20;  ';    nudge_bot   = 'bottom_top_justify = 0.06;  ';
    
  %subplot_attributes(nm).name      = [extract_top  'total_wind_mxn; ' nudge_top ];     nm=nm+1;
  %subplot_attributes(nm).name      = [extract_mid  'total_wind_mxn; ' nudge_mid ];     nm=nm+1;
  %subplot_attributes(nm).name      = [extract_bot  'total_wind_mxn; ' nudge_bot ];     nm=nm+1;

%%
%%----------------------------------------------------------- 
%%
 

%%
%%---------------------- Figure Input ----------------------- 
%%
  planet         = 'Jupiter';
  experiment_dir = 'spot_test';
    
  extract_it   = 1;  %'first';
  %extract_it   = 200;
  check_subplot_time_synch = TRUE;
    
  fig_pos_mxn = [ 50, 375 ];   
  background_color = 'w';

  slide_name_prefix = 'UTTP_LonSlice_';
  MxN= [ 2 2 ];
  fig_width_mxn = 800;
  %fig_width_mxn = [700 560];        
  width_height_ratio = 1.2;

  %MxN= [ 2 1 ];
  %fig_width_mxn = [700 875];        
  %width_height_ratio = 1.9;

  %MxN= [ 1 2 ];
  %fig_width_mxn = 800;
  %width_height_ratio = 1.2;

  %MxN= [ 3 1 ];
  %fig_width_mxn = 600;
  %width_height_ratio = 1.73;

  %setOutputFileDirectories
  %mxn_filename = [bmp_file_directory slash 'uvtp'];
%%
%%----------------------------------------------------------- 
%%
end



%%
%% Display MxN Figure
%%
if length(who('subplot_attributes')) == 0
  error('No subplot_attributes specified')
end
if length(subplot_attributes) ~= MxN(1)*MxN(2)
  error('Number of subplot_attributes does not equal the number of subplots (MxN)')
end

fig_num = figure;
fig_size = [ fig_pos_mxn(1) fig_pos_mxn(2) fig_width_mxn(1) fig_width_mxn(length(fig_width_mxn)) ] ;
set( gcf, 'Position', fig_size );
subplot( MxN(1), MxN(2), 1 );
if length(who('background_colr'))==0
  background_color = 'w';
end
set( gcf, 'Color'   , background_color );
generate_new_figures = FALSE; % (turn off figure generation in PlotEpicNC)




%%
%% Display Subplots
%% 
MxN_plot_success = TRUE;
for isp=1:length(subplot_attributes)
  subplot( MxN(1), MxN(2), isp )

  run_directory = pwd;
  ClearVariables


  %
  % Set the Slide Attributes
  %
  fprintf(['\t\n\nProcessing ' subplot_attributes(isp).name ' ....\n'])

  makeMxNfigure_defaults
  eval( subplot_attributes(isp).name );
  if length(who('bmp_file_directory'))==0  |  length(who('movie_file_directory'))==0
    setOutputFileDirectories;
  end

  set(gca,'FontSize', AxisFontSize );

  color_bar_orientation=OFF;
  override_figure_orientation = get(gcf,'Position');
  override_axis_orientation   = get(gca,'Position');
  


  %
  % Extract variables from nc file
  %
  if ExtractNCMxN
    extract_from_nc=TRUE;
    if length(who('Extract_FromMatFile'))
      if Extract_FromMatFile
        extract_from_nc=FALSE;
        if length(who('mat_file_name'))==0
          error(' Input "mat_file_name" is not specified')
        end
      end
    end

    if extract_from_nc   
      if isfield( nc_file_name, 'name' )
        fprintf(['\n\tExtracting NC Files ' nc_file_directory slash ' ' nc_file_name(1).name])
        for inc=1:length( nc_file_name )
          filepath(inc).name = [nc_file_directory slash nc_file_name(inc).name];
          if inc>1
            fprintf([', ' nc_file_name(inc).name]);
          end
        end
        fprintf('\n');
      else
        filepath = [nc_file_directory slash nc_file_name];
        fprintf(['\tExtracting NC File ' filepath ' ....\n'])
      end
      clear epic_vars dimensions nc_file
      [epic_vars, dimensions, nc_file] = ExtractEpicNCdata( filepath, vars_to_plot, extract_it, extract_ik );

    else
      mat_file_path = [ nc_file_directory slash 'MatFiles' slash mat_file_name ];
      fprintf(['\n loading mat file ' mat_file_path '.mat\n'])
      eval(['load ' mat_file_path ' epic_vars'])
      if isfield( nc_file_name, 'name' )
        filepath = [nc_file_directory slash nc_file_name(1).name];
      else
        filepath = [nc_file_directory slash nc_file_name];
      end
      nc_file.pntr = netcdf( filepath );

    end

    if length( epic_vars ) > 0
      arrow_legend.units = epic_vars(1).units;
    end
  end

  if length( epic_vars ) == 0  |  isfield(epic_vars, 'data') == FALSE
     MxN_plot_success = FALSE;
     %close( fig_num );
  else
   
     data_size = size(epic_vars(1).data);
     zonal_average_plot_on = FALSE;
     if length(who('zonal_average_plot'))>0
        if zonal_average_plot ~= OFF
           zonal_average_plot_on = TRUE;
        end
     end
   
     longitude_slice_plot_on = FALSE;
     if length(who('longitude_slice_plot'))>0
        if longitude_slice_plot ~= OFF
           longitude_slice_plot_on = TRUE;
        end
     end
   
     %if data_size(2) > 1  &  not(zonal_average_plot_on |  longitude_slice_plot_on)  
     %   warning('More than one depth specified.  See extract_ik.')
     %end
     
     if data_size(1) > 1  
        error('More than one time specified.  See extract_it.')
     end
   
     if length( who('postExtract') ) > 0
        eval( postExtract )
     end
      
     text_box.name  = epic_vars(1).units;
     arrow_box.name = epic_vars(1).units;
      
   
     %
     % Display Subplot
     %
     if length(who('PlotData'))==0
        error('PlotData does not exist (check slide attribute file)')
     end
   
     tmp_extract_it = extract_it;  % ( necessary when extract_it='last' )
     eval( PlotData );
     extract_it = tmp_extract_it;


     %
     % Store Time
     %
     %extract_times = getNCvardata(nc_file, 'time');
     %sp_time(isp) = extract_times(extract_it);
     if length( epic_vars(1).time ) > 1
        error('More than one time was extracted in epic_vars')
     end
     sp_time(isp) = epic_vars(1).time;


     %
     % Set Title Options
     %
     if length(who('Title')) > 0
        title_handle = get(gca,'Title');
   
        if length( who('TitleFont') ) > 0
           set(title_handle, 'FontSize', TitleFont );
        end
   
        if length( who('TitleWeight') ) > 0
           set(title_handle, 'FontWeight', TitleWeight );
        end
     end

     %
     % Force contour lines to show up
     %
     if contour_plot
       clear ch
       ch = findobj('LineColor', [0 0 0]);
       for ich=1:length(ch);
         set(ch(ich),'LineColor',[1 1 1]); 
         set(ch(ich),'LineColor',[0 0 0]); 
       end
       %%if length( ch ) > 1
       %%  set(ch(2),'LineColor',[1 1 1]); 
       %%  set(ch(2),'LineColor',[0 0 0]); 
       %%end
     end
   

     %
     % postPlot option
     %
     if length( who('postPlot') ) > 0
        eval( postPlot );
     end
   
     fprintf('\t(min,max)  : %f, %f\n', zmin, zmax);
     %fprintf('\t(min,max)  :\n');
     %dp([zmin zmax])
   
   
     %
     % Alter Subplot Width and Height
     %
     apos = get( gca, 'Position' );
     apos_orig = apos;
     disp_buf = 1.0;
   
     Xlen = Xupper - Xlower;
     Xlen(1) = Xlen(2) * width_height_ratio;
     if Xlen(1) > Xlen(2)
       apos(4) = disp_buf * (apos(3) * fpos(3) / fpos(4)) * (Xlen(2) / Xlen(1));
       apos(3) = disp_buf * apos(3);
     else
       apos(3) = disp_buf * apos(4) * (fpos(4) / fpos(3)) * (Xlen(1) / Xlen(2));
       apos(4) = disp_buf * apos(4);
     end
     %apos(3)*fpos(3)/(apos(4)*fpos(4))
   
     if length(who('left_right_justify'))==1
        apos(1) = left_right_justify*(1-apos(3));
     end
   
     if length(who('bottom_top_justify'))==1
        apos(2) = bottom_top_justify*(1-apos(4));
     end

     set( gca, 'Position', apos );
   
   end % else, epic_var was extracted
end % loop over subfigures

plot_success = MxN_plot_success;  % necessary for using makeSlidesEpicNC and PlotEpicNC
   
   
if plot_success
   %%
   %% Make sure subplots are synchronized in time
   %%
   if length(who('check_subplot_time_synch'))
     if check_subplot_time_synch
       if mean(sp_time) ~= sp_time(1)
          message = ['  subplot times are not equal: ' num2str(sp_time(1))];
          for isp=2:1:length(sp_time)
             message =  [message ', ' num2str(sp_time(isp))];
          end
          error( message );
       else
          fprintf('\npassed test for subplot time synchronization .....\n')
       end
     end
   end
   
   %%
   %% Resize Figure to Account for width_height_ratio
   %%
   fpos = get(gcf,'Position');
   fpos_orig = fpos;
   
   % alter figure height
   if width_height_ratio > 1  
      fpos(4) = fpos(4) - MxN(1) * ( apos_orig(4)  -  apos(4) ) * fpos(4);
   % alter figure width
   else
      fpos(3) = fpos(3) - MxN(2) * ( apos_orig(3)  -  apos(3) ) * fpos(3);
   end
   
   apos_orig = apos;
   set(gcf,'Position',fpos);
   
   % reset subplots to account for resized figure
   ch = get(gcf,'Children');
   for isp=1:length(ch)
     axes( ch(isp) );
     if not( strcmp( get(gca,'Tag'), 'text-label' ) )
        apos = get(gca,'Position');
      
        if width_height_ratio > 1
           apos(4) = apos_orig(4) * fpos_orig(4) / fpos(4);
        else
           apos(3) = apos_orig(3) * fpos_orig(3) / fpos(3);
        end
        %apos(3)*fpos(3)/(apos(4)*fpos(4))

        set(gca,'Position',apos);
     end
   end
   
   
   %%
   %% write figure to bmp file
   %%
   if length( who('mxn_filename') ) == 1
      fprintf(['\twriting file ' mxn_filename '\n'])
      writeFig2Bitmap( mxn_filename );
   end

else
   close(fig_num)

end % if plot_sucess   


 
elapsed_time = toc;
fprintf(['\nElapsed time for makeMxNfigure is ' num2str(elapsed_time/60.0) ' minutes.\n'])

fprintf('--------------------------------- makeMxNfigure done ---------------------------------\n')

