%
%                                     makeSlidesEpicNC
%
% Script generates slides for animations.  Input parameters are set in attribute files 
%  and images are displayed using the function specified in the variable PlotSlidesData.  
%  Attribute files can be created using the those in EPIC_PATH/tools/matlab/example_attribute_files/ 
%  as templates.  
%
% Input: 
%           subplot_attributes(:).name     (names of attribute files)
%
% NOTES:    The extract.nc file(s) must have the path EPIC_DATA_PATH/<planet>/experiment/extract.nc .
%
%           Set the variable AppendSlides=TRUE to only create slides that do not already exist 
%            in the output directory.
%
%           Presentations=FALSE places slides in Figures/
%           Presentations=TRUE  places slides in Figures_Presentations/
%           Use Figures_subdir to explicitly set the slides subdirectory.
%
%
% Output:
%
% 1.) write_figures_to_image_files=TRUE will write each figure to a .bmp file.  The movie
%     file can then be produced using external software (e.g., GraphicsConverter) to catenate
%     the .bmp files into an animation.  This is recommended over the other output options!
%
% 2.) create_mat_movie_file=TRUE will save the figures to a .mat file.  The movie is then displayed
%     from within matlab using the commands:
%
%     >> load <mat move file>.mat
%     >> figure(MV.fig)
%     >> set(MV.fig, 'Position', MV.fpos)
%     >> movie( MV.fig, MV.Frames, MV.showings, MV.fps, MV.rect )
%


%%
%%----------------------- Definitions -----------------------
%%
starttime_makeSlidesEpicNC = clock;
EpicNC_initialize
checkEPICncPATHs();

load_files_externally         = TRUE;  % (tell PlotEpicNC to by pass file loading and output settings)
load_comparisons_externally   = TRUE;  
extract_ncfile_externally     = TRUE;

load_nxm_input_externally     = TRUE;  % (tell makeMxNfigure to by pass input settings)

DisplayMaxMin                 = TRUE;

write_data_dir                = [EPIC_DATA_PATH slash];
write_figures_to_image_files  = TRUE;
create_mat_movie_file         = FALSE;

if isdir(write_data_dir)==FALSE
   mkdir(write_data_dir);
end

addpath( [EPIC_MATLAB_SRC_PATH slash 'EPICncVis' slash 'attributes_slide'] );
%%
%%----------------------------------------------------------- 
%%


%%
%%----------------- Input Attribute Files ------------------- 
%%
nm=1;  clear slide_attributes

if length(who('slide_type'))==0
  error(' Variable "slide_type" is not defined.')
end


if strfind(slide_type, 'WIND') 
  if strfind(slide_type, 'MULTI-LAYER')
    slide_attributes(nm).name  = 'total_wind_slides_3';      nm=nm+1;
  else
    slide_attributes(nm).name  = 'total_wind_slides';        nm=nm+1;
  end

elseif strfind(slide_type, 'SCALAR') 
  slide_attributes(nm).name  = 'scalar_slides';              nm=nm+1;

elseif strfind(slide_type, 'COMPARE-U')                                 % COMPARE-U and COMPARE-V must be tested in 
  slide_attributes(nm).name  = 'compare_wind_slides';        nm=nm+1;   %  two sepparate elseif statements (Matlab glich).

elseif strfind(slide_type, 'COMPARE-V') 
  slide_attributes(nm).name  = 'compare_wind_slides';        nm=nm+1;

elseif strfind(slide_type, 'UVTP') 
  slide_attributes(nm).name  = 'uvtp_slides';                nm=nm+1;

elseif strfind(slide_type, 'VORTICITY') 
  slide_attributes(nm).name  = 'vorticity_slides';           nm=nm+1;

elseif strfind(slide_type, 'TOPOGRAPHY') 
  slide_attributes(nm).name  = 'topography_slides';          nm=nm+1;

elseif strcmp(slide_type, 'EP_FLUX_DIV') 
  slide_attributes(nm).name  = 'ep_flux_slides';             nm=nm+1;

elseif strcmp(slide_type, 'COMPARE-EP_FLUX_DIV') 
  slide_attributes(nm).name  = 'compare_ep_flux_slides';     nm=nm+1;

elseif strfind(slide_type, 'COMPARE-TIMEAVE') 
  slide_attributes(nm).name  = 'compare_timeave_slides';     nm=nm+1; 

else
  error([' slide_type = "' slide_type '" is not supported.']);
end
%%
%%----------------------------------------------------------- 
%%
 


%%
%% Display Slides
%%
if length(who('slide_attributes')) == 1
for imv=1:length(slide_attributes)

  run_directory = pwd;
  %ClearVariables


  %%
  %% Set the Slide Attributes
  %%
  ExtractNCSlides = TRUE;
  makeSlidesEpicNC_defaults
  eval( slide_attributes(imv).name );
  color_bar_orientation=OFF;

  fprintf(['\n\nProcessing ' slide_name_prefix ' ....\n'])


  %%
  %% Create output directories if necessary (must be done here for AppendSlides option)
  %%
  setOutputFileDirectories;
  bmp_file_directory

  %%
  %% Extract variables from nc file
  %%
  if ExtractNCSlides
     %filepath = [nc_file_directory slash nc_file_name];
     if isfield( nc_file_name, 'name' )
        fprintf(['\tExtracting NC Files ' nc_file_directory slash ' ' nc_file_name(1).name])
        for inc=1:length( nc_file_name )
           filepath(inc).name = [nc_file_directory slash nc_file_name(inc).name];
           if inc>1
              fprintf([', ' nc_file_name(inc).name]);
           end
           fprintf('\n');
        end
     else
        filepath = [nc_file_directory slash nc_file_name];
        fprintf(['\tExtracting NC File ' filepath ' ....\n'])
     end
     [slides_epic_vars, dimensions, nc_file] = ExtractEpicNCdata( filepath, vars_to_plot, ...
                                                                       slides_extract_it, slides_extract_ik );
     if length( who('postExtract') ) > 0
        eval( postExtract )
     end
      
     text_box.name      = slides_epic_vars(1).units;
     arrow_legend.units = slides_epic_vars(1).units;
      
     data_size = size(slides_epic_vars(1).data);
     %num_slides = data_size(1) + slides_extract_it(1)-1;
     %if data_size(2) > 1
     %   warning('More than one depth specified.  See slides_extract_ik.')
     %end
  else
     %num_slides = length(slides_extract_it) + slides_extract_it(1)-1;
  end

  if ischar( slides_extract_it ) 
     num_slides = 1;
  else
     if ExtractNCSlides
        num_slides = data_size(1) + slides_extract_it(1)-1;
     else
        %num_slides = slides_extract_it(length(slides_extract_it));
        num_slides = length(slides_extract_it);
     end
  end


  %%
  %% Set the Initial Slide Number
  %%
  slide_count=1;  last_file=0;
  if length(who('AppendSloppy'))
     if AppendSloppy
        AppendSlides = TRUE;
     end
  else
     AppendSloppy = FALSE;
  end
  if length(who('AppendSlides')) > 0  
    if AppendSlides
       for ip=0:1:9
          Prefix(ip+1).valid = num2str(ip);
       end
       file_format='bmp';
       if length(who('output_file_format'))
         if isfield(output_file_format,'name')
           file_format = output_file_format(1).name;
         else
           file_format = output_file_format;
         end
         if strcmp(file_format,'screen')
           file_format='bmp';
         end
       end
       Suffix.valid = [ '.' file_format ];
       %Suffix.valid = '.bmp';
       existing_files = getFileNames( Prefix, Suffix, bmp_file_directory );
       if length(existing_files) > 0
          last_file = existing_files(length(existing_files)).name;
          del_char = findstr( last_file, Suffix.valid );
          last_file( del_char:length(last_file) ) = [];
          last_file = str2num(last_file);
          slide_count = last_file + 1;
          if ischar( slides_extract_it )
             num_slides = slide_count;
          end
       end
       clear Prefix Suffix existing_files del_char 
    end
  end
  if AppendSloppy
     slide_count = 1;
  end
  %num_slides, slide_count, last_file

  %%
  %% Display Slides
  %%
  if length(who('PlotSlidesData'))==0
     error('PlotSlidesData does not exist (check slide attribute file)')
  end
  all_slides_zmin = 10e10;  all_slides_zmax = -10e10;
  plot_success=TRUE; at_least_one_fig_plotted=FALSE;
  while plot_success == TRUE

     if slide_count <= num_slides
        if AppendSloppy == FALSE
           fprintf(['\n---------------------- making Slide ' num2str(slide_count) ' ---------------------- \n']) 
        else
           fprintf(['\n---------------------- making Slide ' num2str(slide_count+last_file) ' ---------------------- \n']) 
        end

        if ischar(slides_extract_it) 
           data_it=slide_count;
        elseif not( AppendSlides )
           data_it=slide_count;
        else
           data_it = slide_count-(slides_extract_it(1)-1);
           if data_it < 1
             data_it = 1;
             slide_count = slides_extract_it(1);
           end
        end
        if ischar(slides_extract_it)
           extract_it = slides_extract_it;
        else
           extract_it = slides_extract_it(data_it);
        end

        if length(who('slides_extract_ik'))
           extract_ik = slides_extract_ik;
        else
           %warning(' slides_extract_ik was not defined in makeSlidesEpicNC')
        end
  
        if ExtractNCSlides
           if ischar(slides_extract_it)
             if strcmp(slides_extract_it, 'first')
               data_it = 1;
             elseif strcmp(slides_extract_it, 'last')
               N=size(slides_epic_vars(1).data);
               data_it = N(1);
             elseif strcmp(slides_extract_it, 'all')
               N=size(slides_epic_vars(1).data);
               data_it=slide_count - N(1)+1;
             end
           end
           clear epic_vars
           epic_vars = slides_epic_vars;
           for iv=1:length(epic_vars)
              epic_vars(iv).data = [];
              epic_vars(iv).data = slides_epic_vars(iv).data( data_it, :,:,:);
              epic_vars(iv).thi  = 1;
           end
        else
           data_it = 1;
        end
        eval( PlotSlidesData );

        if length( who('arrow_legend') )  &  plot_success
           if isfield( arrow_legend, 'max_arrow_value' ) == FALSE
              arrow_legend.max_arrow_value = max(max(plot_data));  % assumes figure does not have subplots
           end
        end
     else
        plot_success=FALSE;
     end


     if plot_success==TRUE
        at_least_one_fig_plotted=TRUE;

        %
        % Color map
        %
        %if length(who('colormap_type'))
        %  eval([' colormap(' colormap_type ')'])
        %end

   
        %
        % Display Time on Figure
        %
        if ( display_time_text_box  &  length(who('time_text_box'))==TRUE )
           decimals = 2;
           if isfield(time_text_box,'units')
              display_time_units = time_text_box.units;
           else
              display_time_units = 'years';
           end
           if isfield(time_text_box,'adjust_display_time')
              adjust_time = time_text_box.adjust_display_time;
           else
              adjust_time = 0.0;
           end

           if strcmp(display_time_units,'decades')
             this_slide_time_str = trunc2str(epic_vars(1).time(data_it)/3.1556925e8-adjust_time, decimals);
             time_text_box.name = [ 't = ' this_slide_time_str ' decades' ];
           elseif strcmp(display_time_units,'years')
             this_slide_time_str = trunc2str(epic_vars(1).time(data_it)/3.1556925e7-adjust_time, decimals);
             time_text_box.name = [ 't = ' this_slide_time_str ' yrs' ];
           elseif strcmp(display_time_units,'days')
             this_slide_time_str = trunc2str(epic_vars(1).time(data_it)/8.64e4     -adjust_time, decimals);
             time_text_box.name = [ 't = ' this_slide_time_str ' days' ];
           elseif strcmp(display_time_units,'hours')
             this_slide_time_str = trunc2str(epic_vars(1).time(data_it)/3600       -adjust_time, decimals);
             time_text_box.name = [ 't = ' this_slide_time_str ' hrs' ];
           elseif strcmp(display_time_units,'minutes')
             this_slide_time_str = trunc2str(epic_vars(1).time(data_it)/60         -adjust_time, decimals);
             time_text_box.name = [ 't = ' this_slide_time_str ' min' ];
           elseif strcmp(display_time_units,'seconds')
             this_slide_time_str = trunc2str(epic_vars(1).time(data_it)/1          -adjust_time, decimals);
             time_text_box.name = [ 't = ' this_slide_time_str ' sec' ];
           else
             error([' display_time_units = ' display_time_units ' is not supported ' ...
                    ' (valid types are: decades, years, days, hours, minutes, or seconds)']);
           end

           tb_id = displayTextBox( time_text_box );
           time_text_box.id = tb_id;
        end
   

        %
        % postSlidePlot operations
        %
        if length( who('PresentationSlides') ) > 0
           if PresentationSlides
              reverseFigAndAxesColors;
           end
        end
   
        if length( who('postSlidePlot') ) > 0
           eval( postSlidePlot );
        end
   
        if DisplayMaxMin 
           %fprintf('(min,max)  =  %f, %f\n', zmin, zmax );
           fprintf('(min,max)  :\n');
           dp([zmin zmax])
        end
      
        all_slides_zmin = min( all_slides_zmin, zmin );
        all_slides_zmax = max( all_slides_zmax, zmax );
   

        %
        % Display Arrow Legend for Vector Plots
        %
        if ( display_arrow_text_box  &  length(who('arrow_legend'))==TRUE )
          if length(who('arrow_type'))==FALSE
            arrow_type=1;
          end
          al_id = displayArrowLegend( arrow_legend, arrow_type );
        end

        %
        % Save figure as an individual slide
        %
        if write_figures_to_image_files

           if strfind(slide_type,'TIMEAVE')
             output_file_path = [ bmp_file_directory  slash slide_name_prefix ];
           else
             if AppendSloppy==FALSE
                slide_num = slide_count;
             else
                slide_num = slide_count + last_file;
             end
  
             num_zeros = 3 - floor(log10(slide_num));
             if num_zeros>0
                z='0';
                for iz=2:1:num_zeros;
                   z = [z '0'];
                end
                char_slide_num = [z num2str(slide_num)];
             else
                char_slide_num = num2str(slide_num);
             end
             output_file_path = [bmp_file_directory slash char_slide_num];
           end
           
           pause( 0.05 );                 % (let all processes catch up)

           if length(who('output_file_format')) == 0
             output_file_format = 'none';
           end
           if length(who('output_file_resolution')) > 0
             dpi = output_file_resolution;
           else
             dpi = -1; % (triggers default resolution)
           end
           
           if isfield(output_file_format, 'name')
             for ioff=1:length(output_file_format)
               if strcmp(output_file_format(ioff).name, 'screen')
                 file_format = 'bmp';
                 unix(['rm -f ' output_file_path '.bmp ']);
                 fprintf(['\tCapturing bmp file ' output_file_path '.bmp\n'])
                 writeFig2Bitmap( output_file_path );
                 fprintf(['\tFile captured \n'])
               elseif not( strcmp(output_file_format(ioff).name, 'none') )
                 file_format = output_file_format(ioff).name;
                 unix(['rm -f ' output_file_path '.' file_format ' ']);
                 fprintf(['\tWriting ' file_format ' file ' output_file_path '.' file_format '\n'])
                 printToFile( output_file_path, file_format, dpi );
                 fprintf(['\tFile written \n'])
               end
             end
           elseif not( strcmp( output_file_format, 'none' ) )
             if strcmp(output_file_format, 'screen')
               unix(['rm -f ' output_file_path '.bmp ']);
               fprintf(['\tCapturing bmp file ' output_file_path '.bmp\n'])
               writeFig2Bitmap( output_file_path );
               fprintf(['\tFile captured \n'])
             else
               unix(['rm -f ' output_file_path '.' output_file_format ' ']);
               fprintf(['\tWriting ' output_file_format ' file ' output_file_path '.' output_file_format '\n'])
               printToFile( output_file_path, output_file_format, dpi );
               fprintf(['\tFile written \n'])
             end
           end

        end

        %
        % Record figure for MPG writer
        %
        if create_mat_movie_file
           cmap=colormap;
           mvname = [slide_name_prefix '_MV'];
     
           fpos=get(gcf,'Position'); 
           rect=fpos;
           rect(1:2)=[0 0];              %Pixel Coord. of Lower Left Corner 
           eval([mvname '_Frames(:,slide_count) = getframe(gcf,rect); '])
     
           eval([mvname '.fig      = gcf; '])
           eval([mvname '.fpos     = fpos; '])
           eval([mvname '.Frames   = ' mvname '_Frames; '])
           eval([mvname '.showings = repeat_num;'])
           eval([mvname '.fps      = fps; '])
           eval([mvname '.rect     = rect; '])
        end

        close_fig=TRUE;
        if length(who('auto_close_figures'))
          close_fig=auto_close_figures;
        end
        if close_fig
          close(gcf)
        end
        slide_count=slide_count+1;
     end % if plot_success is TRUE

     eval(['cd ' run_directory])

  end % while plot_sucess is TRUE

  %%
  %% Create Movie Files
  %%
  if create_mat_movie_file
     movie_file = [ movie_file_directory slash slide_name_prefix ];

     % copy movie to variable MV
     eval(['MV = ' mvname ';']);
   
     % save movie to .mat file
     if create_mat_movie_file
        fprintf(['\nWriting Mat Movie File ' movie_file '.mat\n'])
        eval(['save ' movie_file ' MV;'])
     end
  end

  %%
  %% make color bar
  %%
    disp_cb = FALSE;
    if at_least_one_fig_plotted
      if length(who('display_colorbar_fig'))>0  &  vector_plot==FALSE  
         disp_cb = display_colorbar_fig;
      end
    end
    if disp_cb==TRUE
       clear text_box 
       LoadDefaultColorBar
     
       if length(who('cb_width'))==1
          color_bar_width = cb_width;
       end
     
       min_color = zmin;
       max_color = zmax;
       clear xtick xticklabel 
       if length(who('cb_tick'))
          xtick=cb_tick;
       else
          if all_slides_zmin>0 
            tic_min =  ceil(abs(all_slides_zmin)/5)*5 * sign(all_slides_zmin);
          else
            tic_min =  floor(abs(all_slides_zmin)/5)*5 * sign(all_slides_zmin);
          end
          if all_slides_zmax>0 
            tic_max = floor(abs(all_slides_zmax)/5)*5 * sign(all_slides_zmax);
          else
            tic_max = ceil(abs(all_slides_zmax)/5)*5 * sign(all_slides_zmax);
          end
          xtick =  tic_min : (tic_max-tic_min)/4 : tic_max;
          if logarithmic_plot
             xtick_interval = floor( (tic_max-tic_min)/5 );
             xtick = round(tic_min) : xtick_interval : round(tic_min)+5*xtick_interval;
          end
       end
       if length(who('cb_ticklabel'))
          xticklabel=cb_ticklabel;
       end
     
       
       if strfind(slide_type,'TIMEAVE')
         output_file_path = [ bmp_file_directory  slash slide_name_prefix '_ColorBar' ];
       else
         output_file_path = [bmp_file_directory '_ColorBar' ];
       end
     
       if length(who('cb_label')) > 0
          text_box.name = cb_label;
       elseif length(who('slides_epic_vars')) > 0
          text_box.name = slides_epic_vars(1).units;
       elseif length(who('epic_vars')) > 0
          text_box.name = epic_vars(1).units;
       end

       if length(who('cb_text_box_location'))
          text_box.location = cb_text_box_location;
       end
     
       ColorBarFig
     
       close(gcf)
    end
  

  %%
  %% Finish Script
  %%
  if DisplayMaxMin  &  at_least_one_fig_plotted
     fprintf('\nAll Slides (min,max)  :\n')
     dp([all_slides_zmin all_slides_zmax])
  end
  if isfield( nc_file, 'pntr' )
     for inc=1:length(nc_file)
        close(nc_file(inc).pntr);
     end
  else
     close(nc_file);
  end

end % loop over slide_attributes

else
  error('No slide_attributes specified')
end


fprintf('\n\n--------------------------------- done ---------------------------------\n')
 
elapsed_time = etime( clock, starttime_makeSlidesEpicNC );
fprintf(['Elapsed time is ' num2str(elapsed_time/60.0) ' minutes.\n'])

