%
% NOTE:  Script produces the standard blue-->red colormap only!!!
%        To generate a colorbar for a different colormap, first run makeSlidesEpicNC 
%        and then run ColorBarFig.  From the drop down menus, select Edit/Colormap...  .  
%        This will pop up the Colormap Editor.  Change the colormap using the menu 
%        item Tools/Standard colormaps .  Save the new figure using 
%        writeFig2Bitmap( [bmp_filename '_2'] ) at the command prompt.
%



   figure
   set(gcf,'Color', 'w');
   
   %
   % Display ColorBar
   %
   if color_bar_orientation==1
      fig_size = [fig_pos(1) fig_pos(2) fig_width fig_squeeze_width];
      set(gcf, 'Position', fig_size);
   
      colorbar_handle = colorbar('horiz');
      %all_colorbar_handles = findobj( 'Tag', 'Colorbar' );
      %colorbar_handle = all_colorbar_handles(1);
   
   
      % hide the graph axes
      apos = get(gca,'Position');
      apos(2) = 2.5;
      set(gca, 'Position', apos);
   
   
      % resize color bar
      cbpos = get( colorbar_handle, 'Position');
      %cbpos(4)= 0.025;
      cbpos(4) = 0.30;
      cbleft   = 0.70*(1.0-color_bar_width);
      cbbottom = 0.70*(1.0-cbpos(4));
      cbpos = [ cbleft  cbbottom  color_bar_width  cbpos(4) ] ;
   
      set(colorbar_handle, 'Position', cbpos);
   
      % set colormap  (e.g., 'gray')
      if length(who('colormap_type'))
         cm_type = colormap_type;
         if strcmp(colormap_type, 'light-gray')
           cm_type='gray';
           min_color = min_color - (max_color-min_color)/3;
         end
         colormap( cm_type );
      end
   
      % set color bar attributes
      set(colorbar_handle, 'FontSize', color_bar_font_size );
      set(colorbar_handle, 'XLim',   [min_color max_color] );
      ch = get(colorbar_handle,'Children');
      set(ch, 'XData', [min_color max_color]);
   
      if length(who('xtick'))
         set(colorbar_handle, 'XTick', xtick);
      end
   
      if ( length(who('logarithmic_plot')) > 0 )
         if logarithmic_plot 
            cbtick      = get( colorbar_handle, 'XTick' ) ;
            log_cbtick  = round(cbtick(1)) : 1 : round(cbtick(length(cbtick)));
            cbticklabel = 10.^log_cbtick;
            set( colorbar_handle, 'XTick'     , log_cbtick  );
            set( colorbar_handle, 'XTickLabel', cbticklabel );
            %set(colorbar_handle,'XScale','log');
         end
      end
   
      if length(who('xticklabel'))
         set(colorbar_handle, 'XTickLabel', xticklabel);
         if logarithmic_plot==TRUE
            clear xticklabel
            xticklabel = str2num( get(colorbar_handle,'XTickLabel') );
            for n=1:length(xticklabel)
               xticklabel(n) = 10.0^xticklabel(n);
            end
            set(colorbar_handle, 'XTickLabel', xticklabel);
         end
      end
   

      % set text color
      if length(who('cb_text_color'))
         set(colorbar_handle, 'XColor', cb_text_color);
         set(colorbar_handle, 'YColor', cb_text_color);
         text_box.text_color = cb_text_color;
      end

      % set background color
      if length(who('cb_background_color'))
         set(gcf, 'Color', cb_background_color);
         text_box.background = cb_background_color;
      end
   
      % display units
      if display_text_box 
         displayTextBox( text_box );
      end

      % reverse colors for presentations
      if length( who('PresentationSlides') ) > 0
         if PresentationSlides
            reverseFigAndAxesColors;
         end
      end
   
      % call post plot process
      if length( who('postColorbarPlot') ) > 0
         eval( postColorbarPlot );
      end
             
   
   else
      error(['color_bar_orientation = ' num2str(color_bar_orientation) ' is not currently supported'])
   end
      
   
   %
   % Write figure to bitmap
   %
   if write_figures_to_image_files == TRUE
      if length(who('output_file_path'))==1

        if isfield(output_file_format, 'name')
          for ioff=1:length(output_file_format)
            if not( strcmp(output_file_format(ioff).name, 'none') )
              if strcmp(output_file_format(ioff).name, 'screen')
                opff_suffix = 'bmp';
              else
                opff_suffix = output_file_format(ioff).name;
              end
              file_format = output_file_format(ioff).name;
              unix(['rm -f ' output_file_path '.' opff_suffix ' ']);
              fprintf(['\tWriting ' opff_suffix ' file ' output_file_path '.' opff_suffix '\n'])
              printToFile( output_file_path, file_format );
              fprintf(['\tFile written \n'])
            end
          end
        elseif not( strcmp( output_file_format, 'none' ) )
          if strcmp(output_file_format, 'screen')
            opff_suffix = 'bmp';
          else
            opff_suffix = output_file_format;
          end
          unix(['rm -f ' output_file_path '.' opff_suffix ' ']);
          fprintf(['\tWriting ' opff_suffix ' file ' output_file_path '.' opff_suffix '\n'])
          printToFile( output_file_path, output_file_format );
          fprintf(['\tFile written \n'])
        end

      end
   end
   



