function LineLatterPlot( axes_attributes, fig_attributes )
%
% Display a "latter" plot by squeezing together two neighboring subplots 
%  such that they appear to share the same y-axis.  Make sure the y-axis 
%  of the two subplots agree!  The subplots are defined in the input parameter
%  axes_attributes which has the following structure:
%
%    axes_attributes(:).Title
%    axes_attributes(:).XLabel
%    axes_attributes(:).YLabel
%    axes_attributes(:).XLimits
%    axes_attributes(:).YLimits
%    axes_attributes(:).ReverseXaxis
%    axes_attributes(:).ReverseYaxis
%    axes_attributes(:).xtick
%    axes_attributes(:).ytick
%    axes_attributes(:).xticklabel
%    axes_attributes(:).yticklabel
%    axes_attributes(:).DisplayBox
%    axes_attributes(:).DisplayGrid
%    axes_attributes(:).DisplayLegend
%
%  * axes_attributes(:).curve(:).name
%  * axes_attributes(:).curve(:).x_data
%  * axes_attributes(:).curve(:).y_data
%
%    axes_attributes(:).curve(:).x_data_scale
%    axes_attributes(:).curve(:).y_data_scale
%    axes_attributes(:).curve(:).line_type
%    axes_attributes(:).curve(:).line_size
%    axes_attributes(:).curve(:).marker_size
%
%
% Figure properties can be specified with the optional input parameter fig_attributes
%  which has the following structure:
%
%    fig_attributes.fig_pos          
%    fig_attributes.fig_width        
%    fig_attributes.fig_color        
%    fig_attributes.AxisFontSize     
%    fig_attributes.latter_margin_LR 
%    fig_attributes.latter_margin_TB 
%    fig_attributes.latter_gap       
%    fig_attributes.subplot_ratio_width_to_height 
%
%
%
% NOTE:  All of the above attributes are optional except for those marked by *.
%

FALSE=0; TRUE=1;
if nargin<1
  error(' Missing input "axes_attributes"')
end
if length(axes_attributes)~=2
  error(' Input "axes_attributes" must have length 2.')
end


fig_pos          = [ 50, 375 ];
fig_width        = [ 980 ];
fig_color        = 'w';
AxisFontSize     = 8;
latter_margin_LR = .05;
latter_margin_TB = .10;
latter_gap       = .04;
subplot_ratio_width_to_height = 1.0;

if nargin>1
  if isfield( fig_attributes, 'fig_pos' )
    fig_pos = fig_attributes.fig_pos;
  end
  if isfield( fig_attributes, 'fig_width' )
    fig_width = fig_attributes.fig_width;
  end
  if isfield( fig_attributes, 'fig_color' )
    fig_color = fig_attributes.fig_color;
  end
  if isfield( fig_attributes, 'AxisFontSize' )
    AxisFontSize = fig_attributes.AxisFontSize;
  end
  if isfield( fig_attributes, 'latter_margin_LR' )
    latter_margin_LR = fig_attributes.latter_margin_LR;
  end
  if isfield( fig_attributes, 'latter_margin_TB' )
    latter_margin_TB = fig_attributes.latter_margin_TB;
  end
  if isfield( fig_attributes, 'latter_gap' )
    latter_gap = fig_attributes.latter_gap;
  end
  if isfield( fig_attributes, 'subplot_ratio_width_to_height' )
    subplot_ratio_width_to_height = fig_attributes.subplot_ratio_width_to_height;
  end
end


fig_num = figure;
fig_pos(3:4) = [ fig_width(1) fig_width(length(fig_width)) ];
set(gcf,'Position', fig_pos);
set(gcf,'Color'   , fig_color);

for iax=1:2
  if iax==1
    ax_id(iax) = subplot(121);
  else
    ax_id(iax) = subplot(122);
  end

  hold on
  clear curve
  curve=axes_attributes(iax).curve;
  for ic=1:length(curve)
    clear x_data y_data line_type line_size marker_size
    x_data = curve(ic).x_data;
    y_data = curve(ic).y_data;
  
    if isfield( curve(ic), 'x_data_scale' )
      if length( curve(ic).x_data_scale ) > 0
        x_data = x_data .* curve(ic).x_data_scale;
      end
    end
  
    if isfield( curve(ic), 'y_data_scale' )
      if length( curve(ic).y_data_scale ) > 0
        y_data = y_data .* curve(ic).y_data_scale;
      end
    end
  
    line_type = '-';
    if isfield( curve(ic), 'line_type' )
      if length(curve(ic).line_type) > 0
        line_type = curve(ic).line_type;
      end
    end
  
    curve(ic).line_id = plot( x_data, y_data, line_type );
  
  
    %
    % Post Plotting Options 
    %
    set(gca,'FontSize', AxisFontSize * min(fig_width)/420 );
     
    if isfield( axes_attributes(iax), 'Title' )
      if length( axes_attributes(iax).Title ) > 0
        title( axes_attributes(iax).Title );
      end
    end
     
    if isfield( axes_attributes(iax), 'XLabel' )
      if length( axes_attributes(iax).XLabel ) > 0
        xlabel( axes_attributes(iax).XLabel );
      end
    end
     
    if isfield( axes_attributes(iax), 'YLabel' )
      if length( axes_attributes(iax).YLabel ) > 0
        ylabel( axes_attributes(iax).YLabel );
      end
    end
     
    if isfield( axes_attributes(iax), 'XLimits' )
      if length( axes_attributes(iax).XLimits ) > 0
        cur_axis = axis;
        cur_axis(1) = axes_attributes(iax).XLimits(1);
        cur_axis(2) = axes_attributes(iax).XLimits(2);
        axis( cur_axis );
      end
    end

    if isfield( axes_attributes(iax), 'YLimits' )
      if length( axes_attributes(iax).YLimits ) > 0
        cur_axis = axis;
        cur_axis(3) = axes_attributes(iax).YLimits(1);
        cur_axis(4) = axes_attributes(iax).YLimits(2);
        axis( cur_axis );
      end
    end
   
    if isfield( axes_attributes(iax), 'LogXData' )
      if length(who('axes_attributes(iax).LogXData')) > 0
        if axes_attributes(iax).LogXData
          set(gca, 'XScale', 'log');
        end
      end
    end

    if isfield( axes_attributes(iax), 'LogYData' )
      if length(who('axes_attributes(iax).LogYData')) > 0
        if axes_attributes(iax).LogYData
          set(gca, 'YScale', 'log');
        end
      end
    end
  
    revX=FALSE;
    if isfield( axes_attributes(iax), 'ReverseXaxis' )
      if length( axes_attributes(iax).ReverseXaxis ) > 0
        revX = axes_attributes(iax).ReverseXaxis;
      end
    end
    revY=FALSE;
    if isfield( axes_attributes(iax), 'ReverseYaxis' )
      if length( axes_attributes(iax).ReverseYaxis ) > 0
        revY = axes_attributes(iax).ReverseYaxis;
      end
    end
    if revX & not(revY)
       view(180,-90);
    elseif not(revX) & revY
       view(0,-90);
    elseif revX & revY
       view(180,90);
    end
    
    if isfield( axes_attributes(iax), 'xtick' )
      if length( axes_attributes(iax).xtick ) > 0
        set(gca,'XTick',axes_attributes(iax).xtick);
      end
    end
    if isfield( axes_attributes(iax), 'ytick' )
      if length( axes_attributes(iax).ytick ) > 0
        set(gca,'YTick',axes_attributes(iax).ytick);
      end
    end
    if isfield( axes_attributes(iax), 'xticklabel' )
      if length( axes_attributes(iax).xticklabel ) > 0
        set(gca,'XTickLabel',axes_attributes(iax).xticklabel);
      end
    end
    if isfield( axes_attributes(iax), 'yticklabel' )
      if length( axes_attributes(iax).yticklabel ) > 0
        set(gca,'YTickLabel',axes_attributes(iax).yticklabel);
      end
    end
    
    if isfield( axes_attributes(iax), 'DisplayBox' )
      if length( axes_attributes(iax).DisplayBox ) > 0
        if axes_attributes(iax).DisplayBox
          box on
        else
          box off
        end
      end
    end
    
    if isfield( axes_attributes(iax), 'DisplayGrid' )
      if length( axes_attributes(iax).DisplayGrid ) > 0
        if axes_attributes(iax).DisplayGrid
          grid on
        else
          grid off
        end
      end
    end
    
    if isfield( axes_attributes(iax), 'SquareAxes' )
      if length( axes_attributes(iax).SquareAxes ) > 0
%         if axes_attributes(iax).SquareAxes
%            fpos = get(gcf,'Position');
%            apos = get(gca,'Position');
%            if fpos(3) > fpos(4)
%                apos(3) = apos(4)*fpos(4) / fpos(3);
%            else
%                apos(4) = apos(3)*fpos(3) / fpos(4);
%            end
%            xbuff = 0.035 * fpos(3)/560;
%            apos(1) = 0.5*(1.0 - apos(3)) + xbuff;
%            set(gca,'Position',apos);
%         end
       end
    end
    
    for ic=1:length(curve)
      if isfield( curve(ic), 'line_size' )
       if length( curve(ic).line_size ) > 0
         set( curve(ic).line_id, 'LineWidth', curve(ic).line_size * min(fig_width)/420 );
       end
      end
  
      if isfield( curve(ic), 'marker_size' )
       if length( curve(ic).marker_size ) > 0
         set( curve(ic).line_id, 'MarkerSize', curve(ic).marker_size * min(fig_width)/420 );
       end
      end
    end
    
  end % loop over curves

end % loop over iax


%
% Change figure and axes positions
%
margins.L    = latter_margin_LR;
margins.R    = latter_margin_LR;
margins.Xgap = latter_gap;
margins.T    = latter_margin_TB;
margins.B    = latter_margin_TB;

setFigureMargins( [1 2], margins, 1.0/subplot_ratio_width_to_height, fig_width, 'FIG_WIDTH' );

for iax=1:2
  axes(ax_id(iax));

  if isfield( axes_attributes(iax), 'DisplayLegend' )
    if length( axes_attributes(iax).DisplayLegend ) > 0
      if axes_attributes(iax).DisplayLegend
         if length(who('LegendLocation'))
            leg_loc = LegendLocation;
         else
            leg_loc = 'Best';
         end
         Legend = 'leg_handle = legend(gca, ';
         for ic=1:length(curve)
            Legend = [ Legend '''' curve(ic).name ''',' ]; 
         end
         Legend = [ Legend  ' ''Location'', ''' leg_loc ''' ); ' ];
         eval( Legend );
         %legend boxoff
      end
    end
  end

end

%fpos = get(gcf,'Position');
%xwidth = 0.5*( 1.0 - latter_gap - 2.0*latter_margin_LR );
%if xwidth<=0
%  error(' subplot width must be a positive value')
%end
%real_xwidth = xwidth*fpos(3);
%real_ywidth = real_xwidth/subplot_ratio_width_to_height;
%fpos(4)     = real_ywidth / ( 1.0 - 2.0*latter_margin_TB );
%
%set(gcf,'Position', fpos );
%
%for iax=1:2
%  axes(ax_id(iax));
%
%  apos = get( ax_id(iax), 'Position' );
%  if iax==1
%    apos(1) = latter_margin_LR;
%  else
%    apos(1) = latter_margin_LR+xwidth+latter_gap;
%  end
%  apos(3) = xwidth;
%  apos(4) = real_ywidth/fpos(4);
%  apos(2) = 0.5*(1.0-apos(4));
%  set( ax_id(iax), 'Position', apos );
%    
%  if isfield( axes_attributes(iax), 'DisplayLegend' )
%    if length( axes_attributes(iax).DisplayLegend ) > 0
%      if axes_attributes(iax).DisplayLegend
%         if length(who('LegendLocation'))
%            leg_loc = LegendLocation;
%         else
%            leg_loc = 'Best';
%         end
%         Legend = 'leg_handle = legend(gca, ';
%         for ic=1:length(curve)
%            Legend = [ Legend '''' curve(ic).name ''',' ]; 
%         end
%         Legend = [ Legend  ' ''Location'', ''' leg_loc ''' ); ' ];
%         eval( Legend );
%         %legend boxoff
%      end
%    end
%  end
%end
%
%
