
if length(who('directory')) == FALSE
   error(' A directory must be specified')
end
if length(who('file_s_line')) == FALSE
   file_s_line = 3;
end

if length(who('fig_pos')) == FALSE
   fig_pos   = [ 50, 375 ];
end
if length(who('fig_width')) == FALSE
   fig_width = [560];
end
if length(who('fig_color')) == FALSE
   fig_color = 'w';
end

if length(who('AxisFontSize')) == FALSE
   AxisFontSize = 20 * min(fig_width) / 560;
end


ac=1;
auto_color(ac).char = 'b';  auto_color(ac).map = [0 0 1];  auto_color(ac).found = FALSE;  ac=ac+1;
auto_color(ac).char = 'r';  auto_color(ac).map = [1 0 0];  auto_color(ac).found = FALSE;  ac=ac+1;
auto_color(ac).char = 'g';  auto_color(ac).map = [0 1 0];  auto_color(ac).found = FALSE;  ac=ac+1;
auto_color(ac).char = 'c';  auto_color(ac).map = [0 1 1];  auto_color(ac).found = FALSE;  ac=ac+1;
auto_color(ac).char = 'm';  auto_color(ac).map = [1 0 1];  auto_color(ac).found = FALSE;  ac=ac+1;
auto_color(ac).char = 'y';  auto_color(ac).map = [1 1 0];  auto_color(ac).found = FALSE;  ac=ac+1;
auto_color(ac).char = 'k';  auto_color(ac).map = [1 1 1];  auto_color(ac).found = FALSE;  ac=ac+1;
 

if length(who('plot_type'))
 
   %----------------------------------------------------------------

   if strcmp(plot_type, 'ZETA-THETA-VS-P')  ...
    | strcmp(plot_type, 'THETA-ZETA-VS-P') 
      filename   = 'vertical.dat';
      file_s_line = 3;

      nl = 1;
      plot_line(nl).name        = '\theta';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'r-s';
      plot_line(nl).col_x_data  = 5;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      plot_line(nl).name        = '\zeta';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'b-o';
      plot_line(nl).col_x_data  = 2;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      DisplayLegend = TRUE;
      LegendLocation = 'NorthWest';

      XLabel        = '( K )';
      YLabel        = 'p  ( mbar )';
      LogYData      = TRUE;
      ReverseYaxis  = TRUE;

      SquareAxes    = TRUE;

   %----------------------------------------------------------------

   elseif strcmp(plot_type, 'ZETA-THETA-K-VS-P')  ...
        | strcmp(plot_type, 'THETA-ZETA-K-VS-P') 
      filename  = 'vertical.dat';
      file_s_line = 3;

      nl = 1;
      plot_line(nl).name        = '\theta';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'k-s';
      plot_line(nl).col_x_data  = 5;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      plot_line(nl).name        = '\zeta';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'k-o';
      plot_line(nl).col_x_data  = 2;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;
 
      %plot_line(nl).name        = 'T';
      %plot_line(nl).filename    = filename;
      %plot_line(nl).file_s_line = file_s_line;
      %plot_line(nl).linetype    = 'k-^';
      %plot_line(nl).col_x_data  = 4;
      %plot_line(nl).x_scale     = 1.0;
      %plot_line(nl).col_y_data  = 3;
      %plot_line(nl).y_scale     = 1.0;
      %nl=nl+1;

      plot_line(nl).name        = 'model layers';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'k--';
      plot_line(nl).col_x_data  = '4';
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      DisplayLegend = TRUE;
      LegendLocation = 'NorthWest';

      XLabel        = '( K )';
      YLabel        = 'p  ( mbar )';
      LogYData      = TRUE;
      ReverseYaxis  = TRUE;

      SquareAxes    = TRUE;

   %----------------------------------------------------------------
 
   elseif strcmp(plot_type, 'T-VS-P')  
      filename  = 'vertical.dat';
      file_s_line = 3;

      nl = 1;
      plot_line(nl).name        = 'TvsP';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'k-s';
      plot_line(nl).col_x_data  = 4;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;

      DisplayLegend = FALSE;

      XLabel        = 'T [K]';
      YLabel        = 'p [mbar]';
      LogYData      = TRUE;
      ReverseYaxis  = TRUE;

      SquareAxes    = TRUE;

   %----------------------------------------------------------------
 
   elseif strcmp(plot_type, 'U-VS-P')  
      filename  = 'vertical.dat';
      file_s_line = 3;

      nl = 1;
      plot_line(nl).name        = 'UvsP';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'k-s';
      plot_line(nl).col_x_data  = 7;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 3;
      plot_line(nl).y_scale     = 1.0;

      DisplayLegend = FALSE;

      XLabel        = 'U [m/s]';
      YLabel        = 'p [mbar]';
      LogYData      = TRUE;
      ReverseYaxis  = TRUE;

      SquareAxes    = TRUE;

   %----------------------------------------------------------------
 
   elseif strcmp(plot_type, 'U-VS-LAT')  
      filename   = 'zonal_wind.dat';
      file_s_line = 7;

      nl = 1;
      plot_line(nl).name        = 'UvsLat';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'k-s';
      plot_line(nl).col_x_data  = 2;
      plot_line(nl).x_scale     = 1.0;
      plot_line(nl).col_y_data  = 1;
      plot_line(nl).y_scale     = 1.0;

      DisplayLegend = FALSE;

      XLabel        = 'U [m/s]';
      YLabel        = 'Latitude';

      SquareAxes    = TRUE;

   %----------------------------------------------------------------
 
   elseif strcmp(plot_type, 'VORTICITY-VS-LAT')  
      filename   = 'zonal_wind.dat';
      file_s_line = 7;

      nl = 1;
      plot_line(nl).name        = 'f';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'b-s';
      plot_line(nl).col_x_data  = 3;
      plot_line(nl).x_scale     = 1.0e-04;
      plot_line(nl).col_y_data  = 1;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      plot_line(nl).name        = '\xi';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'r-o';
      plot_line(nl).col_x_data  = 4;
      plot_line(nl).x_scale     = 1.0e-04;
      plot_line(nl).col_y_data  = 1;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      plot_line(nl).name        = '\xi+f';
      plot_line(nl).filename    = filename;
      plot_line(nl).file_s_line = file_s_line;
      plot_line(nl).linetype    = 'g-^';
      plot_line(nl).col_x_data  = 5;
      plot_line(nl).x_scale     = 1.0e-04;
      plot_line(nl).col_y_data  = 1;
      plot_line(nl).y_scale     = 1.0;
      nl=nl+1;

      DisplayLegend = TRUE;
      LegendLocation = 'Best';

      XLabel        = '[s^{-1}]';
      YLabel        = 'Latitude';

      SquareAxes    = TRUE;

   %----------------------------------------------------------------

   else
      error([ ' plot_type=' plot_type ' is not recognized'])
   end


end


%
% Check for Required Fields in plot_line(:)
%
irf=1;
required_field(irf).name = 'filename';         irf=irf+1;
required_field(irf).name = 'file_s_line';      irf=irf+1;
required_field(irf).name = 'col_x_data';       irf=irf+1;
required_field(irf).name = 'col_y_data';       irf=irf+1;

for irf=1:length(required_field)
  if not(isfield( plot_line, required_field(irf).name ))
    error([' Missing required field plot_line(:).' required_field(irf).name])
  end
  for ipl=1:length(plot_line)
    if eval(['length(plot_line(' num2str(ipl) ').' required_field(irf).name ')==0'])
      error([' Missing required field plot_line(' num2str(ipl) ').' required_field(irf).name])
    end
  end
end




