
%
%  Figure Attribute Defaults
%
if length(who('fig_pos')) == 0
  fig_pos = [50 375];
end
if length(who('generate_new_figures')) == 0
   generate_new_figures = TRUE;
end
if length(who('maximize_display')) == 0
   maximize_display = FALSE;
end
if length(who('alter_fig_width_for_globe')) == 0
   alter_fig_width_for_globe = FALSE;
end
if length(who('disp_axis')) == 0
   disp_axis = TRUE;
end
if length(who('AxisFontSize')) == 0
   AxisFontSize = 16 * min(fig_width) / 420;
end
if length(who('use_auto_color_map')) == 0
   use_auto_color_map = TRUE;
end
if length(who('color_bar_orientation')) == 0  
   color_bar_orientation = OFF;
end
if length(who('color_bar_width')) == 0
   color_bar_width = 0.75;
end
if length(who('color_bar_font_size')) == 0
   color_bar_font_size = 12 * fig_width / 560;
end
if length(who('display_text_box')) == 0
   display_text_box = FALSE;
end
xaxis_label = 'Longitude';
yaxis_label = 'Latitude';
if length(who('background_color')) == 0
   background_color = 'w';
end
if length(who('make_x_data_periodic')) == 0
   make_x_data_periodic = TRUE;
end
if length(who('plot_grid_only')) == 0
   plot_grid_only = FALSE;
end


%
%  Plotting Attribute Defaults
%
if length(who('scale_data')) == 0
   scale_data = 1.0;
end
if length(who('logarithmic_plot')) == 0
   logarithmic_plot = OFF;
end
if length(who('scale_data_after_log')) == 0
   scale_data_after_log = 1.0;
end
if length(who('convert_Pa_to_mbar')) == 0
   convert_Pa_to_mbar = FALSE;
end
if length(who('convert_mbar_to_Pa')) == 0
   convert_mbar_to_Pa = FALSE;
end
if length(who('remap_to_pressure_surfaces')) == 0
   remap_to_pressure_surfaces = FALSE;
end

cart_surf_plot         = TRUE;
cart_line_plot         = FALSE;
cart_reverse_line_plot = FALSE;
k_sigma_line           = -1;
if length(who('k_sigma_line_style')) == 0
  k_sigma_line_style = '-.';
end
if length(who('vector_plot')) == 0
   vector_plot = OFF;
end
if vector_plot
   cart_surf_plot = FALSE;
   color_bar_orientation = OFF;
end
if length(who('vector_arrow_scale')) == 0
   vector_arrow_scale = 1.0;
end
if length(who('thin_vector_plot_iters')) == 0
   thin_vector_plot_iters = 0;
end
if length(thin_vector_plot_iters)==1
   thin_vector_plot_iters(2) = thin_vector_plot_iters(1);
end
if length(who('spherical_coord_plot')) == 0
   spherical_coord_plot = FALSE;
end
if spherical_coord_plot
   cart_surf_plot = FALSE;
end

if length(who('contour_plot')) == 0
   contour_plot = OFF;
end
if contour_plot  |  spherical_coord_plot
   cart_surf_plot = FALSE;
   color_bar_orientation = OFF;
end
if length(who('contour_lines_label')) == 0
   contour_lines_label = 'none';
end

if length(who('topography_plot')) == 0
   topography_plot = OFF;
end
if length(who('num_rotations')) == 0
   num_rotations = 1.0;
end
if length(who('opaque_ik')) == 0
   opaque_ik = 'bottom';
end
if length(who('see_through')) == 0
   see_through = 0.80;
end


if length(who('longitude_slice_plot')) == 0
   longitude_slice_plot = FALSE;
end
if length(who('zonal_average_plot')) == 0
   zonal_average_plot = FALSE;
end
if length(who('zonal_max_plot')) == 0
   zonal_max_plot = FALSE;
end
if length(who('zonal_anomoly_plot')) == 0
   zonal_anomoly_plot = FALSE;
end
if length(who('vertical_ave_plot')) == 0
   vertical_ave_plot = FALSE;
end





%
% Automatic presets for using plot_type
%
if length(who('plot_type'))
if strcmp(plot_type, 'SCALAR-CART')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;

elseif strcmp(plot_type, 'SCALAR-MULTI-LAYER')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = TRUE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;

elseif strcmp(plot_type, 'SCALAR-SPHERE')
   cart_surf_plot       = FALSE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = TRUE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;

elseif strcmp(plot_type, 'SCALAR-CONTOUR')
   cart_surf_plot       = FALSE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = TRUE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;

elseif strcmp(plot_type, 'TOPOGRAPHY-CART')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = TRUE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;

elseif strcmp(plot_type, 'TOPOGRAPHY-SPHERE')
   cart_surf_plot       = FALSE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = TRUE;
   vector_plot          = FALSE;
   spherical_coord_plot = TRUE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;

elseif strcmp(plot_type, 'VECTOR-CART')
   cart_surf_plot       = FALSE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = TRUE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;
   if length( vars_to_plot ) ~= 2
      error('  vector plots require exactly 2 variables ' );
   end

elseif strcmp(plot_type, 'VECTOR-SPHERE')
   cart_surf_plot       = FALSE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = TRUE;
   spherical_coord_plot = TRUE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;
   if length( vars_to_plot ) ~= 2
      error('  vector plots require exactly 2 variables ' );
   end

elseif strcmp(plot_type, 'VECTOR-CONTOUR')
   cart_surf_plot       = FALSE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = TRUE;
   topography_plot      = FALSE;
   vector_plot          = TRUE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;
   color_bar_orientation = OFF;
   if length( vars_to_plot ) ~= 2
      error('  vector plots require exactly 2 variables ' );
   end

elseif strfind(plot_type, 'LONG-SLICE')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;

   if     strfind(plot_type, '-LINE' ),  longitude_slice_plot       = 'line';
   elseif strfind(plot_type, '-RLINE'),  longitude_slice_plot       = 'reverse-line';
   elseif strfind(plot_type, '-SURF' ),  longitude_slice_plot       = 'surf';
   elseif strfind(plot_type, '-PSURF' ), longitude_slice_plot       = 'surf';
                                         remap_to_pressure_surfaces = TRUE;
   elseif strfind(plot_type, '-CONT' ),  longitude_slice_plot       = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
   elseif strfind(plot_type, '-PCONT' ), longitude_slice_plot       = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
                                         remap_to_pressure_surfaces = TRUE;
   else
      longitude_slice_plot = 'line';   % (default)
   end
   
elseif strfind(plot_type, 'ZONAL-AVE')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   vertical_ave_plot    = FALSE;

   if     strfind(plot_type, '-LINE' ),  zonal_average_plot         = 'line';
   elseif strfind(plot_type, '-RLINE'),  zonal_average_plot         = 'reverse-line';
   elseif strfind(plot_type, '-SURF' ),  zonal_average_plot         = 'surf';
   elseif strfind(plot_type, '-PSURF' ), zonal_average_plot         = 'surf';
                                         remap_to_pressure_surfaces = TRUE;
   elseif strfind(plot_type, '-CONT' ),  zonal_average_plot         = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
   elseif strfind(plot_type, '-PCONT' ), zonal_average_plot         = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
                                         remap_to_pressure_surfaces = TRUE;
   else
      zonal_average_plot = 'line';     % (default)
   end
   
elseif strfind(plot_type, 'ZONAL-MAX')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_average_plot   = FALSE;
   zonal_anomoly_plot   = FALSE;

   if     strfind(plot_type, '-LINE' ),  zonal_max_plot             = 'line';
   elseif strfind(plot_type, '-RLINE'),  zonal_max_plot             = 'reverse-line';
   elseif strfind(plot_type, '-SURF' ),  zonal_max_plot             = 'surf';
   elseif strfind(plot_type, '-PSURF' ), zonal_max_plot             = 'surf';
                                         remap_to_pressure_surfaces = TRUE;
   elseif strfind(plot_type, '-CONT' ),  zonal_max_plot             = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
   elseif strfind(plot_type, '-PCONT' ), zonal_max_plot             = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
                                         remap_to_pressure_surfaces = TRUE;
   else
      zonal_max_plot = 'line';     % (default)
   end
   
elseif strfind(plot_type, 'ZONAL-ANOM')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_max_plot       = FALSE;
   zonal_average_plot   = FALSE;
   vertical_ave_plot    = FALSE;

   if     strfind(plot_type, '-LINE' ),  zonal_anomoly_plot         = 'line';
   elseif strfind(plot_type, '-RLINE'),  zonal_anomoly_plot         = 'reverse-line';
   elseif strfind(plot_type, '-SURF' ),  zonal_anomoly_plot         = 'surf';
   elseif strfind(plot_type, '-PSURF' ), zonal_anomoly_plot         = 'surf';
                                         remap_to_pressure_surfaces = TRUE;
   elseif strfind(plot_type, '-CONT' ),  zonal_anomoly_plot         = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
   elseif strfind(plot_type, '-PCONT' ), zonal_anomoly_plot         = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
                                         remap_to_pressure_surfaces = TRUE;
   else
      zonal_anomoly_plot = 'line';     % (default)
   end

   
elseif strfind(plot_type, 'VERTICAL-AVE')
   cart_surf_plot       = TRUE;
   multi_layer_plot     = FALSE;
   cart_line_plot       = FALSE;
   contour_plot         = FALSE;
   topography_plot      = FALSE;
   vector_plot          = FALSE;
   spherical_coord_plot = FALSE;
   longitude_slice_plot = FALSE;
   zonal_max_plot       = FALSE;
   zonal_anomoly_plot   = FALSE;
   zonal_average_plot   = FALSE;

   if     strfind(plot_type, '-SURF' ),  vertical_ave_plot          = 'surf';
   elseif strfind(plot_type, '-CONT' ),  vertical_ave_plot          = 'surf';
                                         cart_surf_plot             = FALSE;
                                         contour_plot               = TRUE;
                                         color_bar_orientation      = OFF;
   else
      vertical_ave_plot = 'surf';     % (default)
   end

   if remap_to_pressure_surfaces
     warning([ ' plot_type="' plot_type '" uses sigmatheta coordinates (remap_to_pressure_surfaces is bi-passed)'])
     remap_to_presssure_surfaces = FALSE;
   end


else
   if ischar(plot_type)
     error([' plot_type = ' plot_type ' is not supported'])
   else
     error([' plot_type = ' num2str(plot_type) ' is not supported'])
   end
end



end % if plot_type exists


%
% Add pressure variables for remap
%
p2_needed=FALSE;  p3_needed=FALSE;
if remap_to_pressure_surfaces
  for iv=1:length(vars_to_plot)
    if strfind(vars_to_plot(iv).name, '3')  |  strcmp(vars_to_plot(iv).name, 'theta')  
      p3_needed=TRUE;
    else
      p2_needed=TRUE;
    end
  end
  if p2_needed
    vars_to_plot(length(vars_to_plot)+1).name = 'p2';
  end
  if p3_needed
    vars_to_plot(length(vars_to_plot)+1).name = 'p3';
  end

  extract_ik_non_remap = extract_ik;
  extract_ik='all';
end

if vector_plot==TRUE
  num_plot_vars = 1;
  if length(vars_to_plot) - p2_needed - p3_needed ~= 2
     error(' vector plots require two variables.')
  end
else
  num_plot_vars = length(vars_to_plot);
  if remap_to_pressure_surfaces
    num_plot_vars = num_plot_vars - p2_needed - p3_needed;
  end
end

if length(who('extend_surface_data'))
  if not(isfield(extend_surface_data,'pressure'))
    error(' parameter "extend_surface_data" is missing the field "pressure"')
  end
  if not(isfield(extend_surface_data,'units'))
    error(' parameter "extend_surface_data" is missing the field "units"')
  end
  if not(strcmp(extend_surface_data.units,'Pa')) & not(strcmp(extend_surface_data.units,'mb'))
    error([' extend_surface_data.units = ' extend_surface_data.units ' is not supported.  Valid options are "Pa" and "mb".'])
  end
end


%
% Modify defaults for LONGITUDE-SLICE
%
longitude_slice_plot_on = FALSE;
if length(longitude_slice_plot)>0
   if longitude_slice_plot~=0
      longitude_slice_plot_on = TRUE;
      if not(  strcmp(longitude_slice_plot,'line')  |   strcmp(longitude_slice_plot,'reverse-line')  ...
           |   strcmp(longitude_slice_plot,'surf') )
         if ischar(longitude_slice_plot)
            error(['longitude_slice_plot = ' longitude_slice_plot ' is not supported'])
         else
            error(['longitude_slice_plot = ' num2str(longitude_slice_plot) ' is not supported'])
         end
      end

      if length(who('longitude_slice')) == 0
         warning('No longitude_slice specified.  Defaulting to long=0.0')
         longitude_slice = 0.0;
      end

      xaxis_label = 'Latitude';

      if strcmp(longitude_slice_plot,'line')  |   strcmp(longitude_slice_plot,'reverse-line')
         cart_surf_plot       = FALSE;
         cart_line_plot       = TRUE;
         color_bar_orientation = OFF;
      end
      if strcmp(longitude_slice_plot,'reverse-line')
         cart_reverse_line_plot   = TRUE;
      end
      if strcmp(longitude_slice_plot,'surf')
         cart_line_plot           = FALSE;
         cart_surf_plot           = TRUE;
         if remap_to_pressure_surfaces
           yaxis_label            = 'Pressure';
         else
           yaxis_label            = 'sigmatheta';
         end
         if contour_plot
            cart_surf_plot        = FALSE;
            if length(who('contour_plot_type'))==FALSE
               contour_plot_type = 1;
            end
            if contour_plot_type == 0
               color_bar_orientation = OFF;
            end
         end
      end
      %contour_plot         = FALSE;
      zonal_average_plot   = FALSE;
      vector_plot          = FALSE;
      spherical_coord_plot = FALSE;

      if length(extract_ik)==1  |  strcmp(extract_ik,'top')  |  strcmp(extract_ik,'bottom')
         error(' LONGITUDE SLICE PLOTS REQUIRE MORE THAN ONE DEPTH LAYER')
      end
   end
end

%
% Modify defaults for ZONAL-AVERAGE
%
zonal_average_plot_on = FALSE;
if length(zonal_average_plot) > 0
   if zonal_average_plot ~= 0
      zonal_average_plot_on = TRUE;
      if not(  strcmp(zonal_average_plot,'line')  |   strcmp(zonal_average_plot,'reverse-line') ...
           |   strcmp(zonal_average_plot,'surf') )
         if ischar(zonal_average_plot)
            error(['zonal_average_plot = ' zonal_average_plot ' is not supported'])
         else
            error(['zonal_average_plot = ' num2str(zonal_average_plot) ' is not supported'])
         end
      end

      xaxis_label = 'Latitude';

      if strcmp(zonal_average_plot,'line')  |   strcmp(zonal_average_plot,'reverse-line')
         cart_line_plot           = TRUE;
         cart_surf_plot           = FALSE;
         color_bar_orientation    = OFF;
      end
      if strcmp(zonal_average_plot,'reverse-line')
         cart_reverse_line_plot   = TRUE;
      end
      if strcmp(zonal_average_plot,'surf')
         cart_line_plot           = FALSE;
         cart_surf_plot           = TRUE;
         if remap_to_pressure_surfaces
           yaxis_label            = 'Pressure';
         else
           yaxis_label            = 'sigmatheta';
         end
         if contour_plot
            cart_surf_plot        = FALSE;
            if length(who('contour_plot_type'))==FALSE
               contour_plot_type = 1;
            end
            if contour_plot_type == 0
               color_bar_orientation = OFF;
            end
         end
      end
      vector_plot = FALSE;
      spherical_coord_plot = FALSE;

      if length(extract_ik)==1  |  strcmp(extract_ik,'top')  |  strcmp(extract_ik,'bottom')
         error(' ZONAL AVERAGE PLOTS REQUIRE MORE THAN ONE DEPTH LAYER')
      end
   end
end

%
% Modify defaults for ZONAL-MAX
%
zonal_max_plot_on = FALSE;
if length(zonal_max_plot) > 0
   if zonal_max_plot ~= 0
      zonal_max_plot_on = TRUE;
      if not(  strcmp(zonal_max_plot,'line')  |   strcmp(zonal_max_plot,'reverse-line') ...
           |   strcmp(zonal_max_plot,'surf') )
         if ischar(zonal_max_plot)
            error(['zonal_max_plot = ' zonal_max_plot ' is not supported'])
         else
            error(['zonal_max_plot = ' num2str(zonal_max_plot) ' is not supported'])
         end
      end

      xaxis_label = 'Latitude';

      if strcmp(zonal_max_plot,'line')  |   strcmp(zonal_max_plot,'reverse-line')
         cart_line_plot           = TRUE;
         cart_surf_plot           = FALSE;
         color_bar_orientation    = OFF;
      end
      if strcmp(zonal_max_plot,'reverse-line')
         cart_reverse_line_plot   = TRUE;
      end
      if strcmp(zonal_max_plot,'surf')
         cart_line_plot           = FALSE;
         cart_surf_plot           = TRUE;
         if remap_to_pressure_surfaces
           yaxis_label            = 'Pressure';
         else
           yaxis_label            = 'sigmatheta';
         end
         if contour_plot
            cart_surf_plot        = FALSE;
            if length(who('contour_plot_type'))==FALSE
               contour_plot_type = 1;
            end
            if contour_plot_type == 0
               color_bar_orientation = OFF;
            end
         end
      end
      vector_plot = FALSE;
      spherical_coord_plot = FALSE;

      if length(extract_ik)==1  |  strcmp(extract_ik,'top')  |  strcmp(extract_ik,'bottom')
         error(' ZONAL MAX PLOTS REQUIRE MORE THAN ONE DEPTH LAYER')
      end
   end
end



%
% Modify defaults for ZONAL-ANOMALY
%
zonal_anomoly_plot_on = FALSE;
if length(zonal_anomoly_plot) > 0
   if zonal_anomoly_plot ~= 0
      zonal_anomoly_plot_on = TRUE;
      if not(  strcmp(zonal_anomoly_plot,'line')  |   strcmp(zonal_anomoly_plot,'reverse-line') ...
           |   strcmp(zonal_anomoly_plot,'surf') )
         if ischar(zonal_anomoly_plot)
            error(['zonal_anomoly_plot = ' zonal_anomoly_plot ' is not supported'])
         else
            error(['zonal_anomoly_plot = ' num2str(zonal_anomoly_plot) ' is not supported'])
         end
      end

      xaxis_label = 'Latitude';

      if strcmp(zonal_anomoly_plot,'line')  |   strcmp(zonal_anomoly_plot,'reverse-line')
         cart_line_plot           = TRUE;
         cart_surf_plot           = FALSE;
         color_bar_orientation    = OFF;
      end
      if strcmp(zonal_anomoly_plot,'reverse-line')
         cart_reverse_line_plot   = TRUE;
      end
      if strcmp(zonal_anomoly_plot,'surf')
         cart_line_plot           = FALSE;
         cart_surf_plot           = TRUE;
         if remap_to_pressure_surfaces
           yaxis_label            = 'Pressure';
         else
           yaxis_label            = 'sigmatheta';
         end
         if contour_plot
            cart_surf_plot        = FALSE;
            if length(who('contour_plot_type'))==FALSE
               contour_plot_type = 1;
            end
            if contour_plot_type == 0
               color_bar_orientation = OFF;
            end
         end
      end
      vector_plot = FALSE;
      spherical_coord_plot = FALSE;

      if length(extract_ik)==1  |  strcmp(extract_ik,'top')  |  strcmp(extract_ik,'bottom')
         error(' ZONAL ANOMALY PLOTS REQUIRE MORE THAN ONE DEPTH LAYER')
      end
   end
end


%
% Modify defaults for VERTICAL-AVE
%
vertical_ave_plot_on = FALSE;
if length(vertical_ave_plot)>0
   if vertical_ave_plot~=0
      vertical_ave_plot_on = TRUE;
   end
end


