
function [plot_data latitude] = addValueAtPoles( plot_data, latitude, value_at_poles )
%
% add or override values at the poles
%

global JLO JHI 

N=size(plot_data);
%mean(plot_data(2,:))

% South Pole
if latitude(1) > -90.0                 
   % first shift all j data by one index
   %for jj=JHI+1:-1:JLO+1
   %   J = jj + JOFFSET();
   %   plot_data(J,:) = plot_data(J-1,:);
   %   latitude(J)    =  latitude(J-1);
   %end
   for jj=N(1)+1:-1:2
      plot_data(jj,:) = plot_data(jj-1,:);
      latitude(jj)    =  latitude(jj-1);
   end

   if strcmp( value_at_poles, 'average' )
     plot_data(1,:) = mean( plot_data(2,:) );
   else
     plot_data(1,:) = value_at_poles(1);
   end
   latitude(1)    = -90.0;

   JLO = JLO-1;
% override value at south pole
else                                  
   plot_data(JLO+JOFFSET(),:)  = value_at_poles(1);
end


% North Pole
N=size(plot_data);
J=N(1);
%J = JHI + JOFFSET();
%mean(plot_data(J,:))
if latitude(J) < 90.0  
%fprintf('adding value at north pole ...')
   if strcmp( value_at_poles, 'average' )
     plot_data(J+1,:) = mean( plot_data(J,:) );
   else
     plot_data(J+1,:)  = value_at_poles(length(value_at_poles));
   end
   latitude(J+1) = 90.0;

   %JHI = JHI+1;
   JHI = J+1 - JOFFSET();

% override value at north pole
else                                  
   plot_data(J,:)  = value_at_poles(length(value_at_poles));
end

plot_y = latitude;

N=size(plot_data);


