function animate_figures( fig_nums, delay )
%
% function animate_figures( fig_nums, delay )
%
% function cycles through figures specified by fig_nums with a time delay between each.
% 
% NOTES:  
%         if not specified, delay defaults to 0.25 seconds.
%         make sure all figures have the same spacial dimensions before calling this routine. 
%
%

if nargin<2
  delay = 0.25;
end
if nargin<1
  error([' Missing input required input "fig_nums":  animate_figures( fig_nums, delay )'])
end

fpos_global = get( fig_nums(1), 'Position' );

for ifn=2:1:length(fig_nums)
  fpos = get( fig_nums(ifn), 'Position');
  fpos(3) = fpos_global(3);
  fpos(4) = fpos_global(4);
  set( fig_nums(1), 'Position', fpos );
end

figure( fig_nums(1) );
for ifn=2:1:length(fig_nums)
  pause( delay );
  figure( fig_nums(ifn) )
end


