%
% Load the EPICncVis path variables defined in EPICncVis_PATHs.m,
%  and verify that each exists.
%


ic=1;
check_list(ic).name = 'EPIC_MATLAB_SRC_PATH';    ic=ic+1;
check_list(ic).name = 'EPIC_MATLAB_USER_PATH';   ic=ic+1;
check_list(ic).name = 'EPIC_DATA_PATH';          ic=ic+1;

for ic=1:length(check_list)
  % Store current values of EPIC_..._PATH variables
  if length(who(check_list(ic).name)) > 0
    prev_value(ic).val = eval(check_list(ic).name);
  else
    prev_value(ic).val = -1;
  end
  
  % Remove ~/ 
  if strcmp( prev_value(ic).val(1), '~' )
    prev_value(ic).val = [ getEnvVariable('HOME') prev_value(ic).val(2:length(prev_value(ic).val)) ];
  end
end


% Load the values of EPIC_..._PATH variables defined in EPICncVis_PATHs
EPICncVis_PATHs


% Check to see if any EPIC_..._PATH variable has changed and display warning
for ic=1:length(check_list)
  if length(who(check_list(ic).name)) == 0
    warning on
    warning(' ');
    fprintf( ['\nThe environment variable ' check_list(ic).name ' has not been set.\n\n'] );

  elseif ischar(prev_value(ic).val)
    if not(strcmp(prev_value(ic).val, eval(check_list(ic).name)))
      warning on
      warning(' ');
      fprintf( ['\nThe environment variable ' check_list(ic).name ' has changed.\n\n'] );

    end
  end
end

clear check_list ic prev_value

