function epic_vars = createZonalAnamolyEpicVar( epic_vars, vars_input )

TRUE=1; FALSE=0;
if nargin<2
  error(' Missing input : epic_vars, vars(:).name')
end

if ischar( vars_input )
  vars.name = vars_input;
else
  vars = vars_input;
end

%
% Find variables
%
for iv=1:length(vars)
  var_found=FALSE;
  for iev=1:length(epic_vars)
    if strcmp( epic_vars(iev).name, vars(iv).name )
      vars(iv).id = iev;
      var_found=TRUE;
    end
  end
  if var_found==FALSE
    error([' Could not find variable "' vars(iv).name '" in epic_vars.'])
  end
end


%
% Define Anamolies in new variables
%
num_epic_vars = length(epic_vars);
for iv=1:length(vars)
  clear data zonal_means
  data = epic_vars( vars(iv).id ).data;
  N=size(data);
  if length(N)==4
    zonal_means = mean( data, 4 );
    for I=1:N(4)
      data(:,:,:,I) = data(:,:,:,I) - zonal_means(:,:,:);
    end
  elseif length(N)==2
    zonal_means = mean( data, 2 );
    for I=1:N(2)
      data(:,I) = data(:,I) - zonal_means(:);
    end
  end

  epic_vars( num_epic_vars+1 )      = epic_vars( vars(iv).id );
  epic_vars( num_epic_vars+1 ).data = data;
  epic_vars( num_epic_vars+1 ).name = [ epic_vars( num_epic_vars+1 ).name '_anamoly' ];
  num_epic_vars = num_epic_vars+1;
end

