function ab_id = displayArrowLegend( arrow_legend, arrow_type )
%
% function ab_id = displayArrowLegend( arrow_legend, arrow_type )
%
%  Input arrow_type can be 1 (default) or 2 and is optional.  It is
%    suggested that 2 be used for square figure plots such as 
%    spherical coordinates.
%
%  Input arrow_legend is a structure with the fields listed below.
%
%       Required:
%                  arrow_legend.max_plot_data
%                  arrow_legend.units                 
%                  arrow_legend.character_width
%                  arrow_legend.location
%
%       Optional:
%                  arrow_legend.scale_max_data
%                  arrow_legend.sig_figs
%                  arrow_legend.font_size
%                  arrow_legend.font_weight
%                  arrow_legend.background
%                  arrow_legend.edge
%                  arrow_legend.arrow_size
%

if nargin<1
   error('  missing input :  arrow_legend')
end
   
if nargin<2
   arrow_type=1;
end
if arrow_type~=1 & arrow_type~=2
   error([' arrow_type=' num2str(arrow_type) ' is not allowed (use 1 or 2)'])
end

      hold on
      current_axes = gca;

      if isfield(arrow_legend, 'background')
         background_color = arrow_legend.background;
      else
         background_color = get(gca, 'Color');
      end


      %
      % display new axes
      %
      axes; 
      set(gca,'Tag','text-label');
      set(gca, 'XTick', []); set(gca, 'YTick', []); axis off
      fpos = get(gcf, 'Position');
      apos = get(gca, 'Position');
      char_width = arrow_legend.character_width;
      set(gca, 'Position', [arrow_legend.location(1)                      arrow_legend.location(2) ...
                            length(arrow_legend.units)*char_width/fpos(3)  2*char_width/fpos(4)     ]);


      %
      % display label
      %
      if not(ischar( arrow_legend.max_arrow_value ))
         scale_max_data = 1.0;
         if isfield(arrow_legend, 'scale_max_data')
            scale_max_data = arrow_legend.scale_max_data;
         end
         sig_figs = 3;
         if isfield(arrow_legend, 'sig_figs')
            sig_figs = arrow_legend.sig_figs;
         end
         max_arrow_value = arrow_legend.max_arrow_value * scale_max_data;
         text_handle = text(0.0, 0.10, 0.0, [ num2str(trunc(max_arrow_value, 1), sig_figs) ' ' arrow_legend.units ] );
      else
         text_handle = text(0.0, 0.10, 0.0, [ arrow_legend.max_arrow_value ' ' arrow_legend.units ] );
      end

      if isfield(arrow_legend, 'font_size')
         set( text_handle, 'FontSize'       , arrow_legend.font_size  );
      end
      if isfield(arrow_legend, 'font_weight')
         set( text_handle, 'FontWeight'       , arrow_legend.font_weight  );
      end

      set( text_handle, 'BackgroundColor', background_color );
      background_color = get(text_handle, 'BackgroundColor');  % doing this allows character definitions of arrow_legend.background

      text_color = [1 1 1] - background_color;
      if isfield(arrow_legend, 'font_color')
         text_color =  arrow_legend.font_color;
      end
      set( text_handle, 'Color', text_color );

      if isfield(arrow_legend, 'edge')
         set( text_handle, 'EdgeColor'      , arrow_legend.edge );
      end

      %
      % display arrow
      %
      if arrow_type==1
         arrow_handle = text(0.0, 0.88, 0.0, '\rightarrow' );
      elseif arrow_type==2
         arrow_handle = text(0.4, 0.50, 0.0, '\leftarrow  ' );
         set( arrow_handle, 'Rotation', 180 );
      end

      if isfield(arrow_legend, 'arrow_size')
         set( arrow_handle(1), 'FontSize'       , arrow_legend.arrow_size  );
      end

      set( arrow_handle, 'BackgroundColor', background_color );

      set( arrow_handle, 'Color', text_color );

      if isfield(arrow_legend, 'edge')
         set( arrow_handle, 'EdgeColor'      , arrow_legend.edge );
      end
      %set( arrow_handle, 'EdgeColor'      , 'w');  % (use for debugging the arrow location)

      set( gca,'Children', [ text_handle arrow_handle]);


      %
      % Reset axes 
      %
      ab_id = gca;

      reset_axes = true;
      if isfield(arrow_legend,'on_top')
        if arrow_legend.on_top
          reset_axes = false;
        end
      end
      if reset_axes
        axes( current_axes );
      end
   
