function text_handle = displayTextBox( text_box )
%
% function text_handle = displayTextBox( text_box )
%
%  Input text_box is a structure with the fields listed below.
%
%       Required:
%                  text_box.character_width
%                  text_box.location
%                  text_box.name
%
%       Optional:
%                  text_box.font_size
%                  text_box.font_weight
%                  text_box.text_color
%                  text_box.background
%                  text_box.edge
%

if nargin<1
   error('  missing input :  text_box')
end
   

      hold on
      current_axes = gca;
      %text( text_box.location(1), text_box.location(2), 0.0, text_box.name );

      if isfield(text_box, 'background')
         background_color = text_box.background;
      else
         background_color = get(gca, 'Color');
      end


      axes; set(gca, 'XTick', []); set(gca, 'YTick', []); axis off
      set(gca,'Tag','text-label');

      fpos = get(gcf, 'Position');
      char_width = text_box.character_width;
      set(gca, 'Position', [text_box.location(1) text_box.location(2) length(text_box.name)*char_width/fpos(3) char_width/fpos(4)]);
      text_handle = text(0.5, 0.5, 0.0, text_box.name);

      %axes_children = get( gca, 'Children' );
      %text_handle   = findobj( axes_children, 'Type', 'text' );
      if isfield(text_box, 'font_size')
         set( text_handle, 'FontSize'       , text_box.font_size  );
      end
      if isfield(text_box, 'font_weight')
         set( text_handle, 'FontWeight'       , text_box.font_weight  );
      end

      set( text_handle, 'BackgroundColor', background_color );
      background_color = get(text_handle, 'BackgroundColor');  % doing this allows character definitions of text_box.background

      text_color = [1 1 1] - background_color;
      if isfield(text_box, 'font_color')
         text_color =  text_box.font_color;
      end
      set(text_handle, 'Color', text_color);

      if isfield(text_box, 'edge')
         set( text_handle, 'EdgeColor'      , text_box.edge       );
      end

      axes( current_axes );
   
