%
%
%Horizontal Stagger:
%
%  Variables are arranged horizontally on a staggered C-grid as shown below.
%  The horizontal locations of variables that coincide with the locations of u,v,h, or q 
%  will be referenced as "U" points, "V" points, "H" points, and "Q" points, respectively.
%         
%                       --------------------------
%                       |                        |
%                       |                        |
%                       |                        |
%                       |                        |
%                                                |
%                       u(k,j,i)    h(k,j,i)     |
%                                                |
%                       |                        |
%                       |                        |
%                       |                        |
%                       |                        |
%                       q(k,j,i) --- v(k,j,i) ----
% 
%
% 
%Vertical Stagger:
%
%   Variables are arranged vertically so that they are "in the layer" or "on the interface"
%   as show below.
% 
%                        k-1/2 ------------------------      "top interface"
%
%
%                          k                                 "in the layer"
%
%
%                        k+1/2 ------------------------      "bottom interface"
%
%
%
%Variables Locations:
%
%                              Horizontal       Vertical
%  |____ Variable Name ____|__    Grid    __|__   Grid   ___|
%  |                       |                |               |
%  |           u           |       U        |      K        |
%  |                       |                |               |
%  |           v           |       V        |      K        |
%  |                       |                |               |
%  |         hdry          |       H        |      K        |
%  |                       |                |               |
%  |         theta         |       H        |    K+1/2      |
%  |                       |                |               |
%  |        nu_turb        |       H        |      K        |
%  |                       |                |               |
%  |         hdry3         |       H        |    K+1/2      |
%  |                       |                |               |
%  |         pdry3         |       H        |    K+1/2      |
%  |                       |                |               |
%  |          p2           |       H        |      K        |
%  |                       |                |               |
%  |          p3           |       H        |    K+1/2      |
%  |                       |                |               |
%  |        theta2         |       H        |      K        |
%  |                       |                |               |
%  |          h2           |       H        |      K        |
%  |                       |                |               |
%  |          h3           |       H        |    K+1/2      |
%  |                       |                |               |
%  |          t2           |       H        |      K        |
%  |                       |                |               |
%  |          t3           |       H        |    K+1/2      |
%  |                       |                |               |
%  |         rho2          |       H        |      K        |
%  |                       |                |               |
%  |         rho3          |       H        |    K+1/2      |
%  |                       |                |               |
%  |        exner2         |       H        |      K        |
%  |                       |                |               |
%  |        exner3         |       H        |    K+1/2      |
%  |                       |                |               |
%  |        fgibb2         |       H        |      K        |
%  |                       |                |               |
%  |         gz2           |       H        |      K        |
%  |                       |                |               |
%  |         gz3           |       H        |    K+1/2      |
%  |                       |                |               |
%  |        mont2          |       H        |      K        |
%  |                       |                |               |
%  |        heat3          |       H        |    K+1/2      |
%  |                       |                |               |
%  |         pv2           |       Q        |      K        |
%  |                       |                |               |
%  |         ri2           |       H        |      K        |
%  |                       |                |               |
%  |         ri3           |       H        |    K+1/2      |
%  |                       |                |               |
%  |        vort2          |       Q        |      K        |
%  |                       |                |               |
%  |       div_uv2         |       H        |      K        |
%  |                       |                |               |
%  |          w3           |       H        |    K+1/2      |
%  |                       |                |               |
%  |        dzdt3          |       H        |    K+1/2      |
%  |                       |                |               |
%  |  diffusion_coef_uv    |       H        |      K        |
%  |                       |                |               |
%  | diffusion_coef_theta  |       H        |      K        |
%  |                       |                |               |
%  |  diffusion_coef_mass  |       H        |      K        |
%  |                       |                |               |
%  |       u_spinup        |       U        |      K        |
%  |                       |                |               |
%  |         ptop          |       H        |   K = -1/2    |
%  |                       |                |               |
%  |      gz_surface       |       H        |  K = Kmax+1/2 |
%  |                       |                |               |
%
%
%
