function fs = f_sigma(sigma)
%
% Part of hybrid vertical coordinate definition,
% sigmatheta = f(sigma)+g(sigma)*theta.
% Use double precision to increase accuracy of diagnostic theta calculations.
%
% (code translated from epic_funcs_diag.c)
%
global zeta0 zeta1 sigma_sigma

%zeta0 
%zeta1
%sigma_sigma

  if (sigma < 0.0) 
    fs = zeta0;
  elseif (sigma <= sigma_sigma) 
    %
    % NOTE: If this formula is changed, then the assignment of sigma_sigma
    %       needs a corresponding change.
    %
    fs = zeta0+sigma*(zeta1-zeta0);
  elseif (sigma < 1.0) 
    fs = (1.0-g_sigma(sigma))*(zeta0+sigma*(zeta1-zeta0));
  else 
    fs = 0.0;
  end


