function gs = g_sigma(sigma)
%
% Part of the hybrid vertical coordinate definition,
% sigmatheta = f(sigma)+g(sigma)*theta.
% Use double precision to increase accuracy of diagnostic theta calculations.
%
% (code translated from epic_funcs_diag.c)
%
  global sigma_sigma

  ALPHA = 50.0;

  coeff = 1.0/(1.0-exp(-ALPHA*(1.0-sigma_sigma)));

  if (sigma <= sigma_sigma) 
    gs = 0.0;
  elseif (sigma >= 1.0) 
    gs = 1.0;
  else 
    gs = coeff*(1.0-exp(-ALPHA*(sigma-sigma_sigma)));
  end
