function VARIABLE = getEnvVariable(env_var_name)
%
% function VARIABLE = getEnvVariable(env_var_name)
%
%  Function returns the value of a shell environement variable
%   defined prior to starting Matlab.
%

if nargin<1
  error('missing input argument "env_var_name"')
end
if not(ischar(env_var_name))
  error('input argument "env_var_name" is not a string')
end


tmp_filename = 'tmp_env_var_value';
hm_id = fopen( tmp_filename );

while hm_id ~= -1
   fclose(hm_id);
   tmp_filename = [tmp_filename '0'];
   hm_id = fopen( tmp_filename );
end

unix(['echo $' env_var_name ' > ' tmp_filename]);

hm_id = fopen( tmp_filename );
VARIABLE = fgetl( hm_id );
fclose( hm_id );

eval(['delete ' tmp_filename])

if length(VARIABLE) == 0
  error([' environment variable "' env_var_name '" has not been set'])
end

