function color = getEpicLineColor( ln, num_lines, cm )
%
% function color = getEpicLineColor( ln, num_lines, cm )
%
%   ln        = line number
%   num_lines = total number of lines
%   cm        = color map (e.g., generate using getEpicLinePlotColorMap() )
%
%

if nargin<3
   error('three input arguments required:  line_number, total_number_of_lines, color_map')
end

size_cm = size(cm);
Ncolors = size_cm(1);
Nshades = size_cm(2);  % (blue, green, red)
if Nshades ~= 3  |  Ncolors < 3
   error('invalid color map')
end


ic = round( (ln-1)/(num_lines-1)*(Ncolors-1) + 1 );
color(1:3) = cm(ic,1:3);


